/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.splendidslimes.entity;

import dev.shadowsoffire.placebo.reload.DynamicHolder;
import io.github.chakyl.splendidslimes.data.SlimeBreed;
import io.github.chakyl.splendidslimes.data.SlimeBreedRegistry;
import io.github.chakyl.splendidslimes.entity.Tarr;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;

public class SlimeEntityBase
extends Slime {
    public static final EntityDataAccessor<String> BREED = SynchedEntityData.m_135353_(SlimeEntityBase.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> SECONDARY_BREED = SynchedEntityData.m_135353_(SlimeEntityBase.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public SlimeEntityBase(EntityType<? extends Slime> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22277_, 16.0);
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_9236_().m_46473_().m_6180_("looting");
        Vec3i vec3i = this.m_213552_();
        if (!this.m_9236_().f_46443_ && this.m_21531_() && this.m_6084_() && !this.f_20890_) {
            for (ItemEntity itementity : this.m_9236_().m_45976_(ItemEntity.class, this.m_20191_().m_82377_((double)vec3i.m_123341_(), (double)vec3i.m_123342_(), (double)vec3i.m_123343_()))) {
                if (itementity.m_213877_() || itementity.m_32055_().m_41619_() || itementity.m_32063_() || !this.m_7243_(itementity.m_32055_())) continue;
                this.m_7581_(itementity);
            }
        }
        this.m_9236_().m_46473_().m_7238_();
    }

    public void setSlimeBreed(String data) {
        this.f_19804_.m_135381_(BREED, (Object)data);
    }

    public String getSlimeBreed() {
        if (this instanceof Tarr) {
            return "splendid_slimes:tarr";
        }
        return (String)this.f_19804_.m_135370_(BREED);
    }

    public void setSlimeSecondaryBreed(String data) {
        this.f_19804_.m_135381_(SECONDARY_BREED, (Object)data);
    }

    public String getSlimeSecondaryBreed() {
        return (String)this.f_19804_.m_135370_(SECONDARY_BREED);
    }

    public boolean isLargo() {
        return !Objects.equals(this.getSlimeSecondaryBreed(), "");
    }

    @NotNull
    protected Component m_5677_() {
        DynamicHolder<SlimeBreed> slime = this.getSlime();
        DynamicHolder<SlimeBreed> secondarySlime = this.getSecondarySlime();
        MutableComponent slimeName = !slime.isBound() ? Component.m_237113_((String)"BROKEN").m_130940_(ChatFormatting.OBFUSCATED) : ((SlimeBreed)slime.get()).name();
        if (secondarySlime.isBound()) {
            return Component.m_237110_((String)"entity.splendid_slimes.largo_splendid_slime", (Object[])new Object[]{slimeName, ((SlimeBreed)secondarySlime.get()).name()});
        }
        return Component.m_237110_((String)"entity.splendid_slimes.splendid_slime", (Object[])new Object[]{slimeName});
    }

    public int getSlimeColor() {
        DynamicHolder<SlimeBreed> slime = this.getSlime();
        if (!slime.isBound()) {
            return 0xFFFFFF;
        }
        return ((SlimeBreed)slime.get()).getColor();
    }

    public int getSecondarySlimeColor() {
        DynamicHolder<SlimeBreed> slime = this.getSecondarySlime();
        if (!slime.isBound()) {
            return -1;
        }
        return ((SlimeBreed)slime.get()).getColor();
    }

    public DynamicHolder<SlimeBreed> getSlime() {
        String type = this.getSlimeBreed();
        if (type.isEmpty()) {
            return SlimeBreedRegistry.INSTANCE.emptyHolder();
        }
        return SlimeBreedRegistry.INSTANCE.holder(new ResourceLocation(type));
    }

    public DynamicHolder<SlimeBreed> getSecondarySlime() {
        String type = this.getSlimeSecondaryBreed();
        if (type.isEmpty()) {
            return SlimeBreedRegistry.INSTANCE.emptyHolder();
        }
        return SlimeBreedRegistry.INSTANCE.holder(new ResourceLocation(type));
    }

    public DynamicHolder<SlimeBreed> getHatSlime() {
        DynamicHolder<SlimeBreed> slime = this.getSecondarySlime();
        if (!slime.isBound()) {
            slime = this.getSlime();
        }
        return slime;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BREED, (Object)"");
        this.f_19804_.m_135372_(SECONDARY_BREED, (Object)"");
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> param) {
        if (BREED.equals(param)) {
            this.m_6210_();
        }
        super.m_7350_(param);
    }

    public void m_7378_(@Nonnull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setSlimeBreed(nbt.m_128461_("Breed"));
        this.setSlimeSecondaryBreed(nbt.m_128461_("SecondaryBreed"));
    }

    public void m_7380_(@Nonnull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128359_("Breed", this.getSlimeBreed());
        nbt.m_128359_("SecondaryBreed", this.getSlimeSecondaryBreed());
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        SpawnGroupData spawn = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (pReason == MobSpawnType.NATURAL) {
            RandomSource randomsource = pLevel.m_213780_();
            int i = randomsource.m_188503_(2);
            if (i < 2 && randomsource.m_188501_() < 0.5f * pDifficulty.m_19057_()) {
                ++i;
            }
            int j = 1 << i;
            this.m_7839_(j, true);
        } else {
            this.m_7839_(0, true);
        }
        return spawn;
    }

    protected boolean m_7483_() {
        return this.m_21515_();
    }
}

