/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.farmlife.common.entities;

import codyhuh.farmlife.registry.FLEntities;
import com.mojang.datafixers.DataFixUtils;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IForgeShearable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Platefish
extends Animal
implements GeoEntity,
IForgeShearable {
    private static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.m_135353_(Platefish.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    @Nullable
    private Platefish leader;
    private int schoolSize = 1;
    public int growTime = this.f_19796_.m_188503_(6000) + 6000;

    public Platefish(EntityType<? extends Animal> p_27557_, Level p_27558_) {
        super(p_27557_, p_27558_);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.1f, 0.5f, false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new BreathAirGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42405_}), false));
        this.f_21345_.m_25352_(5, (Goal)new PlatefishSwimGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new FollowFlockLeaderGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHEARED, (Object)false);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("sheared", this.isSheared());
        tag.m_128405_("GrowPlateTime", this.growTime);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(SHEARED, (Object)tag.m_128471_("sheared"));
        if (tag.m_128441_("GrowPlateTime")) {
            this.growTime = tag.m_128451_("GrowPlateTime");
        }
    }

    public void setSheared(boolean sheared) {
        this.f_19804_.m_135381_(SHEARED, (Object)sheared);
    }

    public boolean isSheared() {
        return (Boolean)this.f_19804_.m_135370_(SHEARED);
    }

    public boolean isShearable(@NotNull ItemStack item, Level level, BlockPos pos) {
        return !this.m_6162_() && !this.isSheared() && super.isShearable(item, level, pos);
    }

    @NotNull
    public List<ItemStack> onSheared(@Nullable Player player, @NotNull ItemStack item, Level level, BlockPos pos, int fortune) {
        this.setSheared(true);
        this.m_146852_(GameEvent.f_157781_, (Entity)player);
        level.m_6269_(null, (Entity)this, SoundEvents.f_11697_, SoundSource.PLAYERS, 1.0f, 1.0f);
        return List.of();
    }

    public void m_7334_(Entity pEntity) {
        if (!(pEntity instanceof Platefish)) {
            super.m_7334_(pEntity);
        }
    }

    public void m_7023_(Vec3 p_213352_1_) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(0.01f, p_213352_1_);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.0015, 0.0));
            }
        } else {
            super.m_7023_(p_213352_1_);
        }
    }

    protected float m_6108_() {
        return 0.999f;
    }

    protected PathNavigation m_6037_(Level p_175447_1_) {
        return new WaterBoundPathNavigation((Mob)this, p_175447_1_);
    }

    public boolean m_6063_() {
        return false;
    }

    protected void updateAir(int air) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(air - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269063_(), 2.0f);
            }
        } else {
            this.m_20301_(300);
        }
    }

    public void m_6075_() {
        int airSupply = this.m_20146_();
        super.m_6075_();
        this.updateAir(airSupply);
    }

    public boolean m_6040_() {
        return true;
    }

    public void m_8107_() {
        if (!this.m_20069_() && this.m_20096_() && this.f_19863_) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f)));
            this.m_6853_(false);
            this.f_19812_ = true;
            this.m_5496_(this.getFlopSound(), this.m_6121_(), this.m_6100_());
        }
        if (this.isSheared() && !this.m_9236_().f_46443_ && this.m_6084_() && !this.m_6162_() && --this.growTime <= 0) {
            this.m_5496_(SoundEvents.f_12534_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            this.growTime = this.f_19796_.m_188503_(6000) + 6000;
            this.setSheared(false);
        }
        super.m_8107_();
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 3.0);
    }

    public boolean m_6573_(Player p_21418_) {
        return false;
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.f_11760_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11761_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11759_;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)((EntityType)FLEntities.PLATEFISH.get()).m_20615_((Level)level);
    }

    public int m_5792_() {
        return this.getMaxSchoolSize();
    }

    public int getMaxSchoolSize() {
        return 8;
    }

    protected boolean canRandomSwim() {
        return !this.isFollower();
    }

    public boolean isFollower() {
        return this.leader != null && this.leader.m_6084_();
    }

    public Platefish startFollowing(Platefish p_27526_) {
        this.leader = p_27526_;
        p_27526_.addFollower();
        return p_27526_;
    }

    public void stopFollowing() {
        this.leader.removeFollower();
        this.leader = null;
    }

    private void addFollower() {
        ++this.schoolSize;
    }

    private void removeFollower() {
        --this.schoolSize;
    }

    public boolean canBeFollowed() {
        return this.hasFollowers() && this.schoolSize < this.getMaxSchoolSize();
    }

    public void m_8119_() {
        List list;
        super.m_8119_();
        if (this.hasFollowers() && this.m_9236_().f_46441_.m_188503_(200) == 1 && (list = this.m_9236_().m_45976_(((Object)((Object)this)).getClass(), this.m_20191_().m_82377_(8.0, 8.0, 8.0))).size() <= 1) {
            this.schoolSize = 1;
        }
    }

    public boolean hasFollowers() {
        return this.schoolSize > 1;
    }

    public boolean inRangeOfLeader() {
        return this.m_20280_((Entity)this.leader) <= 121.0;
    }

    public void pathToLeader() {
        if (this.isFollower()) {
            Path path = this.m_21573_().m_6570_((Entity)this.leader, 3);
            this.m_21573_().m_26536_(path, 1.0);
        }
    }

    public void addFollowers(Stream<? extends Platefish> p_27534_) {
        p_27534_.limit(this.getMaxSchoolSize() - this.schoolSize).filter(p_27538_ -> p_27538_ != this).forEach(p_27536_ -> p_27536_.startFollowing(this));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_27528_, DifficultyInstance p_27529_, MobSpawnType p_27530_, @javax.annotation.Nullable SpawnGroupData p_27531_, @javax.annotation.Nullable CompoundTag p_27532_) {
        super.m_6518_(p_27528_, p_27529_, p_27530_, p_27531_, p_27532_);
        if (p_27531_ == null) {
            p_27531_ = new SchoolSpawnGroupData(this);
        } else {
            this.startFollowing(((SchoolSpawnGroupData)p_27531_).leader);
        }
        return p_27531_;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> e) {
        if (this.m_20069_() && e.isMoving()) {
            e.setAndContinue(RawAnimation.begin().thenLoop("animation.platefish.swim"));
        } else {
            e.setAndContinue(RawAnimation.begin().thenLoop("animation.platefish.idle"));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    static class PlatefishSwimGoal
    extends RandomSwimmingGoal {
        private final Platefish fish;

        public PlatefishSwimGoal(Platefish p_27505_) {
            super((PathfinderMob)p_27505_, 1.0, 2);
            this.fish = p_27505_;
        }

        public boolean m_8036_() {
            return this.fish.canRandomSwim() && super.m_8036_();
        }
    }

    private static class FollowFlockLeaderGoal
    extends Goal {
        private final Platefish mob;
        private int timeToRecalcPath;
        private int nextStartTick;

        public FollowFlockLeaderGoal(Platefish p_25249_) {
            this.mob = p_25249_;
            this.nextStartTick = this.nextStartTick(p_25249_);
        }

        protected int nextStartTick(Platefish p_25252_) {
            return FollowFlockLeaderGoal.m_186073_((int)(200 + p_25252_.m_217043_().m_188503_(200) % 20));
        }

        public boolean m_8036_() {
            if (this.mob.hasFollowers()) {
                return false;
            }
            if (this.mob.isFollower()) {
                return true;
            }
            if (this.nextStartTick > 0) {
                --this.nextStartTick;
                return false;
            }
            this.nextStartTick = this.nextStartTick(this.mob);
            Predicate<Platefish> predicate = p_25258_ -> p_25258_.canBeFollowed() || !p_25258_.isFollower();
            List list = this.mob.m_9236_().m_6443_(((Object)((Object)this.mob)).getClass(), this.mob.m_20191_().m_82377_(16.0, 16.0, 16.0), predicate);
            Platefish platefish = (Platefish)((Object)DataFixUtils.orElse(list.stream().filter(Platefish::canBeFollowed).findAny(), (Object)((Object)this.mob)));
            platefish.addFollowers(list.stream().filter(p_25255_ -> !p_25255_.isFollower()));
            return this.mob.isFollower();
        }

        public boolean m_8045_() {
            return this.mob.isFollower() && this.mob.inRangeOfLeader();
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
        }

        public void m_8041_() {
            this.mob.stopFollowing();
        }

        public void m_8037_() {
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.m_183277_(10);
                this.mob.pathToLeader();
            }
        }
    }

    public static class SchoolSpawnGroupData
    implements SpawnGroupData {
        public final Platefish leader;

        public SchoolSpawnGroupData(Platefish p_27553_) {
            this.leader = p_27553_;
        }
    }
}

