/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CalibratedSculkSensorBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CalibratedSculkSensorBlockEntity;
import net.minecraft.world.level.block.entity.ComparatorBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ComparatorMode;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;

public enum RedstoneProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockState state = accessor.getBlockState();
        Block block = state.m_60734_();
        IThemeHelper t = IThemeHelper.get();
        if (block instanceof LeverBlock) {
            MutableComponent info = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? t.success(Component.m_237115_((String)"tooltip.jade.state_on")) : t.danger(Component.m_237115_((String)"tooltip.jade.state_off"));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.jade.state", (Object[])new Object[]{info}));
            return;
        }
        if (block == Blocks.f_50146_) {
            int delay = (Integer)state.m_61143_((Property)BlockStateProperties.f_61413_);
            tooltip.add((Component)Component.m_237110_((String)"tooltip.jade.delay", (Object[])new Object[]{t.info(delay)}));
            return;
        }
        if (block == Blocks.f_50328_) {
            ComparatorMode mode = (ComparatorMode)state.m_61143_((Property)BlockStateProperties.f_61393_);
            MutableComponent modeInfo = t.info(Component.m_237115_((String)("tooltip.jade.mode_" + (mode == ComparatorMode.COMPARE ? "comparator" : "subtractor"))));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.jade.mode", (Object[])new Object[]{modeInfo}));
            if (accessor.getServerData().m_128441_("Signal")) {
                tooltip.add((Component)Component.m_237110_((String)"tooltip.jade.power", (Object[])new Object[]{t.info(accessor.getServerData().m_128451_("Signal"))}));
            }
            return;
        }
        if (block instanceof CalibratedSculkSensorBlock && accessor.getServerData().m_128441_("Signal")) {
            tooltip.add((Component)Component.m_237110_((String)"jade.input_signal", (Object[])new Object[]{t.info(accessor.getServerData().m_128451_("Signal"))}));
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61426_)) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.jade.power", (Object[])new Object[]{t.info(state.m_61143_((Property)BlockStateProperties.f_61426_))}));
        }
        if (state.m_60734_() instanceof HopperBlock && accessor.getServerData().m_128441_("HopperLocked")) {
            tooltip.add((Component)t.danger(Component.m_237115_((String)"jade.hopper.locked")));
        }
    }

    @Override
    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof ComparatorBlockEntity) {
            ComparatorBlockEntity comparator = (ComparatorBlockEntity)blockEntity;
            data.m_128405_("Signal", comparator.m_59182_());
        } else if (blockEntity instanceof HopperBlockEntity) {
            BlockState state = accessor.getBlockState();
            if (state.m_61138_((Property)BlockStateProperties.f_61431_) && !((Boolean)state.m_61143_((Property)BlockStateProperties.f_61431_)).booleanValue()) {
                data.m_128379_("HopperLocked", true);
            }
        } else if (blockEntity instanceof CalibratedSculkSensorBlockEntity) {
            Direction direction = ((Direction)accessor.getBlockState().m_61143_((Property)CalibratedSculkSensorBlock.f_276692_)).m_122424_();
            int signal = accessor.getLevel().m_277185_(accessor.getPosition().m_121945_(direction), direction);
            data.m_128405_("Signal", signal);
        }
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.MC_REDSTONE;
    }
}

