/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.block.brewingstation;

import de.cristelknight.doapi.common.registry.DoApiSoundEventRegistry;
import de.cristelknight.doapi.common.util.GeneralUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.brewery.block.brewingstation.BrewingstationBlock;
import net.satisfy.brewery.block.entity.BrewstationBlockEntity;
import net.satisfy.brewery.block.property.BrewMaterial;
import net.satisfy.brewery.block.property.Liquid;
import net.satisfy.brewery.registry.BlockStateRegistry;
import net.satisfy.brewery.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrewKettleBlock
extends BrewingstationBlock
implements EntityBlock {
    public static final EnumProperty<Liquid> LIQUID = BlockStateRegistry.LIQUID;
    public static final Map<Direction, VoxelShape> SHAPE;
    private static final Supplier<VoxelShape> voxelShapeSupplier;
    private final BrewMaterial brewMaterial;

    public BrewKettleBlock(BrewMaterial brewMaterial, BlockBehaviour.Properties properties) {
        super(properties);
        this.brewMaterial = brewMaterial;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)MATERIAL, (Comparable)((Object)brewMaterial))).m_61124_(LIQUID, (Comparable)((Object)Liquid.EMPTY)));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.m_61143_((Property)f_54117_));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (interactionHand == InteractionHand.OFF_HAND) {
            return InteractionResult.CONSUME;
        }
        if (level.f_46443_) {
            return InteractionResult.CONSUME;
        }
        ItemStack itemStack = player.m_21120_(interactionHand);
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof BrewstationBlockEntity) {
            BrewstationBlockEntity brewKettleEntity = (BrewstationBlockEntity)blockEntity;
            if (itemStack.m_41619_()) {
                ItemStack returnStack = brewKettleEntity.removeIngredient();
                if (returnStack != null) {
                    player.m_36356_(returnStack);
                    level.m_5594_(null, blockPos, SoundEvents.f_12019_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    level.m_7260_(blockPos, blockState, blockState, 2);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.CONSUME;
            }
            if (itemStack.m_41720_() == ((Block)ObjectRegistry.BEER_MUG.get()).m_5456_()) {
                if (blockState.m_61143_(LIQUID) == Liquid.BEER) {
                    ItemStack beerStack = brewKettleEntity.getBeer();
                    if (beerStack != null) {
                        player.m_36356_(beerStack);
                        if (!player.m_7500_()) {
                            itemStack.m_41774_(1);
                            if (itemStack.m_41619_()) {
                                player.m_150109_().m_36057_(itemStack);
                            }
                            level.m_5594_(null, blockPos, SoundEvents.f_12019_, SoundSource.PLAYERS, 1.0f, 1.0f);
                            level.m_7260_(blockPos, blockState, blockState, 2);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.CONSUME;
                }
                return InteractionResult.PASS;
            }
            if (itemStack.m_41720_() == Items.f_42447_) {
                if (blockState.m_61143_(LIQUID) == Liquid.EMPTY || blockState.m_61143_(LIQUID) == Liquid.DRAINED) {
                    level.m_46597_(blockPos, (BlockState)blockState.m_61124_(LIQUID, (Comparable)((Object)Liquid.FILLED)));
                    level.m_5594_(null, blockPos, SoundEvents.f_11778_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (!player.m_7500_()) {
                        player.m_21008_(interactionHand, new ItemStack((ItemLike)Items.f_42446_));
                    }
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.CONSUME;
            }
            if (itemStack.m_41720_() == Items.f_42446_) {
                Liquid liquid = (Liquid)((Object)blockState.m_61143_(LIQUID));
                if (liquid == Liquid.FILLED || liquid == Liquid.OVERFLOWING) {
                    level.m_46597_(blockPos, (BlockState)blockState.m_61124_(LIQUID, (Comparable)((Object)(liquid == Liquid.OVERFLOWING ? Liquid.FILLED : Liquid.EMPTY))));
                    level.m_5594_(null, blockPos, SoundEvents.f_11781_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (!player.m_7500_()) {
                        player.m_21008_(interactionHand, new ItemStack((ItemLike)Items.f_42447_));
                    }
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.CONSUME;
            }
            if (blockState.m_61143_(LIQUID) != Liquid.BEER) {
                InteractionResult interactionResult = brewKettleEntity.addIngredient(itemStack);
                if (interactionResult == InteractionResult.SUCCESS) {
                    level.m_5594_(null, blockPos, SoundEvents.f_12013_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    level.m_7260_(blockPos, blockState, blockState, 2);
                }
                return interactionResult;
            }
        }
        return super.m_6227_(blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    public void m_214162_(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (blockState.m_61143_(LIQUID) == Liquid.OVERFLOWING) {
            double x = (double)blockPos.m_123341_() + 0.5;
            double y = (double)blockPos.m_123342_() + 0.95;
            double z = (double)blockPos.m_123343_() + 0.5;
            if (randomSource.m_188500_() < 0.3) {
                level.m_7785_(x, y, z, (SoundEvent)DoApiSoundEventRegistry.BREWSTATION_KETTLE.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            double offset = 0.2;
            double offsetX = randomSource.m_188500_() * offset - offset / 2.0;
            double offsetY = randomSource.m_188500_() * 0.1;
            double offsetZ = randomSource.m_188500_() * offset - offset / 2.0;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123795_, x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123772_, x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof BrewstationBlockEntity) {
                BrewstationBlockEntity brewstationEntity = (BrewstationBlockEntity)blockEntity;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)brewstationEntity);
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, moved);
        }
    }

    @Override
    @NotNull
    public ItemStack m_7397_(BlockGetter getter, BlockPos pos, BlockState state) {
        BrewMaterial material = (BrewMaterial)((Object)state.m_61143_((Property)MATERIAL));
        switch (material) {
            case COPPER: {
                return new ItemStack((ItemLike)ObjectRegistry.COPPER_BREWINGSTATION.get());
            }
            case WOOD: {
                return new ItemStack((ItemLike)ObjectRegistry.WOODEN_BREWINGSTATION.get());
            }
            case NETHERITE: {
                return new ItemStack((ItemLike)ObjectRegistry.NETHERITE_BREWINGSTATION.get());
            }
        }
        return super.m_7397_(getter, pos, state);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        Level level = blockPlaceContext.m_43725_();
        BlockPos mainPos = blockPlaceContext.m_8083_();
        BlockState blockState = super.m_5573_(blockPlaceContext);
        if (blockState == null) {
            return null;
        }
        Direction facing = (Direction)blockState.m_61143_((Property)f_54117_);
        BlockPos backPos = mainPos.m_121945_(facing.m_122424_());
        BlockPos sidePos = mainPos.m_121945_(facing.m_122428_());
        BlockPos diagonalPos = sidePos.m_121945_(facing.m_122424_());
        BlockPos topPos = diagonalPos.m_7494_();
        boolean placeable = this.canPlace(level, backPos, sidePos, diagonalPos, topPos);
        return placeable ? blockState : null;
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        super.m_6402_(level, blockPos, blockState, livingEntity, itemStack);
        if (level.f_46443_) {
            return;
        }
        Direction facing = (Direction)blockState.m_61143_((Property)f_54117_);
        BlockPos backPos = blockPos.m_121945_(facing.m_122424_());
        BlockPos sidePos = blockPos.m_121945_(facing.m_122428_());
        BlockPos diagonalPos = sidePos.m_121945_(facing.m_122424_());
        BlockPos topPos = diagonalPos.m_7494_();
        if (!this.canPlace(level, backPos, sidePos, diagonalPos, topPos)) {
            return;
        }
        level.m_7731_(backPos, (BlockState)((BlockState)((Block)ObjectRegistry.BREW_TIMER.get()).m_49966_().m_61124_((Property)f_54117_, (Comparable)facing)).m_61124_((Property)MATERIAL, (Comparable)((Object)this.brewMaterial)), 3);
        level.m_7731_(sidePos, (BlockState)((BlockState)((Block)ObjectRegistry.BREW_WHISTLE.get()).m_49966_().m_61124_((Property)f_54117_, (Comparable)facing)).m_61124_((Property)MATERIAL, (Comparable)((Object)this.brewMaterial)), 3);
        level.m_7731_(diagonalPos, (BlockState)((BlockState)((Block)ObjectRegistry.BREW_OVEN.get()).m_49966_().m_61124_((Property)f_54117_, (Comparable)facing)).m_61124_((Property)MATERIAL, (Comparable)((Object)this.brewMaterial)), 3);
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof BrewstationBlockEntity) {
            BrewstationBlockEntity brewKettleEntity = (BrewstationBlockEntity)blockEntity;
            brewKettleEntity.setComponents(blockPos, backPos, sidePos, diagonalPos);
        }
    }

    private boolean canPlace(Level level, BlockPos ... blockPoses) {
        for (BlockPos blockPos : blockPoses) {
            if (level.m_8055_(blockPos).m_60795_()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new BrewstationBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof BlockEntityTicker) {
                ((BlockEntityTicker)blockEntity).m_155252_(world, pos, state1, blockEntity);
            }
        };
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LIQUID});
    }

    static {
        voxelShapeSupplier = () -> {
            VoxelShape shape = Shapes.m_83040_();
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.125, (double)0.875, (double)0.125, (double)1.0));
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.125, (double)0.0, (double)1.0, (double)1.0, (double)0.125));
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.875, (double)0.125, (double)0.125, (double)1.0, (double)1.0, (double)1.0));
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.125, (double)0.125, (double)0.125, (double)1.0, (double)1.0));
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.125, (double)0.9375, (double)0.875, (double)1.0, (double)1.0));
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.5625, (double)0.09375, (double)0.875, (double)0.5625, (double)0.96875));
            return shape;
        };
        SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
                map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)voxelShapeSupplier.get()));
            }
        });
    }
}

