/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.block;

import de.cristelknight.doapi.common.block.FacingBlock;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.brewery.block.entity.BeerMugBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeerMugFlowerPotBlock
extends FacingBlock
implements EntityBlock {
    private static final VoxelShape SHAPE;
    private static final Supplier<VoxelShape> voxelShapeSupplier;

    public BeerMugFlowerPotBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        BeerMugBlockEntity be = (BeerMugBlockEntity)world.m_7702_(pos);
        if (be == null) {
            return InteractionResult.PASS;
        }
        ItemStack handStack = player.m_21120_(hand);
        Item flower = be.getFlower();
        if (player.m_6144_() && flower != null) {
            if (!world.f_46443_) {
                player.m_36356_(new ItemStack((ItemLike)flower));
                be.setFlower(null);
                world.m_7260_(pos, state, state, 3);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        if (!player.m_6144_() && handStack.m_41619_() && flower != null) {
            if (!world.f_46443_) {
                player.m_36356_(flower.m_7968_());
                be.setFlower(null);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        if (!player.m_6144_() && this.fitInPot(handStack) && flower == null) {
            if (!world.f_46443_) {
                be.setFlower(handStack.m_41720_());
                if (!player.m_7500_()) {
                    handStack.m_41774_(1);
                }
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public boolean fitInPot(ItemStack item) {
        return item.m_204117_(ItemTags.f_13145_);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof BeerMugBlockEntity) {
                BeerMugBlockEntity be = (BeerMugBlockEntity)blockEntity;
                Item flower = be.getFlower();
                if (flower != null) {
                    Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)flower.m_7968_());
                }
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, moved);
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BeerMugBlockEntity(pos, state);
    }

    static {
        voxelShapeSupplier = () -> {
            VoxelShape shape = Shapes.m_83040_();
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.5, (double)0.375), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.625, (double)0.6875, (double)0.5, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.625, (double)0.0, (double)0.375, (double)0.6875, (double)0.5, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.375, (double)0.375, (double)0.5, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)0.0625, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
            return shape;
        };
        SHAPE = voxelShapeSupplier.get();
    }
}

