/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.shape;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import snownee.kiwi.customization.shape.BlockShapeType;
import snownee.kiwi.customization.shape.ConfiguringShape;

public record ConfigureCrossCollisionShape(float nodeWidth, float extensionWidth, float nodeHeight, float extensionBottom, float extensionHeight) implements ConfiguringShape
{
    public static Codec<ConfigureCrossCollisionShape> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("post_width").forGetter(ConfigureCrossCollisionShape::nodeWidth), (App)Codec.FLOAT.fieldOf("side_width").forGetter(ConfigureCrossCollisionShape::extensionWidth), (App)Codec.FLOAT.fieldOf("post_max_y").forGetter(ConfigureCrossCollisionShape::nodeHeight), (App)Codec.FLOAT.fieldOf("side_min_y").forGetter(ConfigureCrossCollisionShape::extensionBottom), (App)Codec.FLOAT.fieldOf("side_max_y").forGetter(ConfigureCrossCollisionShape::extensionHeight)).apply((Applicative)instance, ConfigureCrossCollisionShape::new));
    }

    @Override
    public void configure(Block block, BlockShapeType type) {
        if (!(block instanceof CrossCollisionBlock)) {
            throw new IllegalArgumentException("Block %s is not a CrossCollisionBlock".formatted(block));
        }
        CrossCollisionBlock crossCollisionBlock = (CrossCollisionBlock)block;
        VoxelShape[] shapes = crossCollisionBlock.m_52326_(this.nodeWidth / 2.0f, this.extensionWidth / 2.0f, this.nodeHeight, this.extensionBottom, this.extensionHeight);
        switch (type) {
            case MAIN: {
                crossCollisionBlock.f_52316_ = shapes;
                break;
            }
            case COLLISION: {
                crossCollisionBlock.f_52315_ = shapes;
                break;
            }
            case INTERACTION: {
                throw new UnsupportedOperationException();
            }
        }
    }
}

