/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.shape;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import snownee.kiwi.customization.block.KBlockUtils;
import snownee.kiwi.customization.shape.BakingContext;
import snownee.kiwi.customization.shape.ShapeGenerator;
import snownee.kiwi.customization.shape.UnbakedShape;
import snownee.kiwi.customization.shape.UnbakedShapeCodec;

public record ChoicesShape(List<String> keys, Map<String, ShapeGenerator> valueMap) implements ShapeGenerator
{
    public static <T extends Comparable<T>> ShapeGenerator chooseOneProperty(Property<T> property, Map<T, ShapeGenerator> valueMap) {
        return new ChoicesShape(List.of(property.m_61708_()), property.m_6908_().stream().collect(Collectors.toUnmodifiableMap(arg_0 -> property.m_6940_(arg_0), valueMap::get)));
    }

    public static ShapeGenerator chooseBooleanProperty(BooleanProperty property, ShapeGenerator trueShape, ShapeGenerator falseShape) {
        return new ChoicesShape(List.of(property.m_61708_()), Map.of("true", trueShape, "false", falseShape));
    }

    @Override
    public VoxelShape getShape(BlockState blockState, CollisionContext context) {
        String key = this.keys.size() == 1 ? KBlockUtils.getValueString(blockState, this.keys.get(0)) : String.join((CharSequence)",", (CharSequence[])this.keys.stream().map(k -> KBlockUtils.getValueString(blockState, k)).toArray(String[]::new));
        return this.valueMap.get(key).getShape(blockState, context);
    }

    public record Unbaked(List<String> keys, Map<String, UnbakedShape> choices) implements UnbakedShape
    {
        public static Codec<Unbaked> codec(UnbakedShapeCodec parentCodec) {
            return ExtraCodecs.m_264370_((Codec)RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_263723_.listOf().fieldOf("keys").forGetter(Unbaked::keys), (App)Codec.unboundedMap((Codec)ExtraCodecs.f_263723_, (Codec)parentCodec).fieldOf("choices").forGetter(Unbaked::choices)).apply((Applicative)instance, Unbaked::new)), $ -> {
                if ($.keys().isEmpty()) {
                    return DataResult.error(() -> "Keys must not be empty");
                }
                if ($.choices().isEmpty()) {
                    throw new IllegalArgumentException("Choices must not be empty");
                }
                return DataResult.success((Object)$);
            });
        }

        @Override
        public ShapeGenerator bake(BakingContext context) {
            return new ChoicesShape(this.keys, this.choices.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> ((UnbakedShape)e.getValue()).bake(context))));
        }

        @Override
        public Stream<UnbakedShape> dependencies() {
            return this.choices.values().stream();
        }
    }
}

