/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Objects;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import snownee.kiwi.Kiwi;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.shadowed.com.ezylang.evalex.Expression;
import snownee.kiwi.shadowed.com.ezylang.evalex.data.EvaluationValue;
import snownee.kiwi.util.KEval;

public class KiwiCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext registryAccess, Commands.CommandSelection environment) {
        LiteralArgumentBuilder builder = Commands.m_82127_((String)"kiwi");
        builder.then(Commands.m_82127_((String)"dev_env_rules").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"do_not_run_this_if_you_do_not_know_what_it_does").requires(ctx -> ctx.m_6761_(2))).executes(ctx -> KiwiCommand.debugRules((CommandSourceStack)ctx.getSource()))));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reload").requires(ctx -> ctx.m_6761_(2))).then(Commands.m_82129_((String)"fileName", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String fileName = StringArgumentType.getString((CommandContext)ctx, (String)"fileName");
            if (KiwiConfigManager.refresh(fileName)) {
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.kiwi.reload.success", (Object[])new Object[]{fileName}), true);
                return 1;
            }
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237110_((String)"commands.kiwi.reload.failed", (Object[])new Object[]{fileName}));
            return 0;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"eval").requires(ctx -> ctx.m_6761_(2))).then(Commands.m_82129_((String)"expression", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> KiwiCommand.eval((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"expression")))));
        dispatcher.register(builder);
    }

    private static int debugRules(CommandSourceStack commandSourceStack) {
        Commands commands = commandSourceStack.m_81377_().m_129892_();
        List<String> rules = List.of("gamerule doDaylightCycle false", "gamerule doWeatherCycle false", "gamerule doMobLoot false", "gamerule doMobSpawning false", "gamerule keepInventory true", "gamerule doTraderSpawning false", "gamerule doInsomnia false", "difficulty peaceful", "kill @e[type=!minecraft:player]", "time set day", "weather clear", "gamerule doMobLoot true");
        for (String rule : rules) {
            commands.m_230957_(commandSourceStack, rule);
        }
        return 1;
    }

    private static int eval(CommandSourceStack source, String expString) {
        try {
            EvaluationValue value = new Expression(expString, KEval.config()).evaluate();
            String s = value.isNumberValue() ? value.getNumberValue().toPlainString() : Objects.toString(value.getValue());
            source.m_288197_(() -> Component.m_237113_((String)s), false);
            return value.isNullValue() ? 0 : value.getNumberValue().intValue();
        }
        catch (Throwable e) {
            if (!Platform.isProduction()) {
                Kiwi.LOGGER.error(expString, e);
            }
            source.m_81352_((Component)Component.m_237113_((String)e.getLocalizedMessage()));
            return 0;
        }
    }
}

