/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.buzzier_bees.core.registry;

import com.teamabnormals.blueprint.core.api.BlockSetTypeRegistryHelper;
import com.teamabnormals.blueprint.core.util.PropertyUtil;
import com.teamabnormals.blueprint.core.util.item.CreativeModeTabContentsPopulator;
import com.teamabnormals.blueprint.core.util.registry.BlockSubRegistryHelper;
import com.teamabnormals.buzzier_bees.common.block.ButtercupBlock;
import com.teamabnormals.buzzier_bees.common.block.CrystallizedHoneyBlock;
import com.teamabnormals.buzzier_bees.common.block.HoneyLampBlock;
import com.teamabnormals.buzzier_bees.common.block.HoneycombDoorBlock;
import com.teamabnormals.buzzier_bees.common.block.HoneycombTrapDoorBlock;
import com.teamabnormals.buzzier_bees.common.block.SpecialCandleBlock;
import com.teamabnormals.buzzier_bees.common.block.SpecialCandleCakeBlock;
import com.teamabnormals.buzzier_bees.core.BuzzierBees;
import com.teamabnormals.buzzier_bees.core.other.BBConstants;
import com.teamabnormals.buzzier_bees.core.registry.BBMobEffects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BBBlocks {
    public static final BlockSubRegistryHelper HELPER = (BlockSubRegistryHelper)BuzzierBees.REGISTRY_HELPER.getBlockSubHelper();
    public static final RegistryObject<Block> CRYSTALLIZED_HONEY_BLOCK = HELPER.createBlock("crystallized_honey_block", () -> new CrystallizedHoneyBlock(BBBlockProperties.CRYSTALLIZED_HONEY));
    public static final RegistryObject<Block> HONEY_LAMP = HELPER.createBlock("honey_lamp", () -> new HoneyLampBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50489_).m_60918_(SoundType.f_56751_)));
    public static final RegistryObject<Block> HONEYCOMB_BRICKS = HELPER.createBlock("honeycomb_bricks", () -> new Block(BBBlockProperties.HONEYCOMB_BRICKS));
    public static final RegistryObject<Block> HONEYCOMB_BRICK_STAIRS = HELPER.createBlock("honeycomb_brick_stairs", () -> new StairBlock(() -> ((Block)HONEYCOMB_BRICKS.get()).m_49966_(), BBBlockProperties.HONEYCOMB_BRICKS));
    public static final RegistryObject<Block> HONEYCOMB_BRICK_SLAB = HELPER.createBlock("honeycomb_brick_slab", () -> new SlabBlock(BBBlockProperties.HONEYCOMB_BRICKS));
    public static final RegistryObject<Block> HONEYCOMB_BRICK_WALL = HELPER.createBlock("honeycomb_brick_wall", () -> new WallBlock(BBBlockProperties.HONEYCOMB_BRICKS));
    public static final RegistryObject<Block> CHISELED_HONEYCOMB_BRICKS = HELPER.createBlock("chiseled_honeycomb_bricks", () -> new Block(BBBlockProperties.HONEYCOMB_BRICKS));
    public static final RegistryObject<Block> HONEYCOMB_TILES = HELPER.createBlock("honeycomb_tiles", () -> new Block(BBBlockProperties.HONEYCOMB_BRICKS));
    public static final RegistryObject<Block> HONEYCOMB_TILE_STAIRS = HELPER.createBlock("honeycomb_tile_stairs", () -> new StairBlock(() -> ((Block)HONEYCOMB_TILES.get()).m_49966_(), BBBlockProperties.HONEYCOMB_BRICKS));
    public static final RegistryObject<Block> HONEYCOMB_TILE_SLAB = HELPER.createBlock("honeycomb_tile_slab", () -> new SlabBlock(BBBlockProperties.HONEYCOMB_BRICKS));
    public static final RegistryObject<Block> HONEYCOMB_TILE_WALL = HELPER.createBlock("honeycomb_tile_wall", () -> new WallBlock(BBBlockProperties.HONEYCOMB_BRICKS));
    public static final RegistryObject<Block> HONEYCOMB_DOOR = HELPER.createBlock("honeycomb_door", () -> new HoneycombDoorBlock(BBBlockProperties.HONEYCOMB_DOOR));
    public static final RegistryObject<Block> HONEYCOMB_TRAPDOOR = HELPER.createBlock("honeycomb_trapdoor", () -> new HoneycombTrapDoorBlock(BBBlockProperties.HONEYCOMB_TRAPDOOR));
    public static final RegistryObject<Block> SOUL_CANDLE = HELPER.createBlock("soul_candle", () -> new SpecialCandleBlock(BBConstants.SMALL_SOUL_FIRE_FLAME, BBBlockProperties.SOUL_CANDLE));
    public static final RegistryObject<Block> SOUL_CANDLE_CAKE = HELPER.createBlockNoItem("soul_candle_cake", () -> new SpecialCandleCakeBlock((Block)SOUL_CANDLE.get(), BBConstants.SMALL_SOUL_FIRE_FLAME, BBBlockProperties.SOUL_CANDLE_CAKE));
    public static final RegistryObject<Block> ENDER_CANDLE = HELPER.createBlock("ender_candle", () -> new SpecialCandleBlock(BBConstants.SMALL_ENDER_FIRE_FLAME, BBBlockProperties.ENDER_CANDLE));
    public static final RegistryObject<Block> ENDER_CANDLE_CAKE = HELPER.createBlockNoItem("ender_candle_cake", () -> new SpecialCandleCakeBlock((Block)ENDER_CANDLE.get(), BBConstants.SMALL_ENDER_FIRE_FLAME, BBBlockProperties.ENDER_CANDLE_CAKE));
    public static final RegistryObject<Block> CUPRIC_CANDLE = HELPER.createBlock("cupric_candle", () -> new SpecialCandleBlock(BBConstants.SMALL_CUPRIC_FIRE_FLAME, BBBlockProperties.CUPRIC_CANDLE));
    public static final RegistryObject<Block> CUPRIC_CANDLE_CAKE = HELPER.createBlockNoItem("cupric_candle_cake", () -> new SpecialCandleCakeBlock((Block)CUPRIC_CANDLE.get(), BBConstants.SMALL_CUPRIC_FIRE_FLAME, BBBlockProperties.CUPRIC_CANDLE_CAKE));
    public static final RegistryObject<Block> BUTTERCUP = HELPER.createBlock("buttercup", () -> new ButtercupBlock((Supplier<MobEffect>)BBMobEffects.SUNNY, 12, PropertyUtil.flower()));
    public static final RegistryObject<Block> WHITE_CLOVER = HELPER.createBlock("white_clover", () -> new FlowerBlock(() -> MobEffects.f_19590_, 6, PropertyUtil.flower()));
    public static final RegistryObject<Block> PINK_CLOVER = HELPER.createBlock("pink_clover", () -> new FlowerBlock(() -> MobEffects.f_19590_, 12, PropertyUtil.flower()));
    public static final RegistryObject<Block> POTTED_WHITE_CLOVER = HELPER.createBlockNoItem("potted_white_clover", () -> new FlowerPotBlock((Block)WHITE_CLOVER.get(), PropertyUtil.flowerPot((FeatureFlag[])new FeatureFlag[0])));
    public static final RegistryObject<Block> POTTED_PINK_CLOVER = HELPER.createBlockNoItem("potted_pink_clover", () -> new FlowerPotBlock((Block)PINK_CLOVER.get(), PropertyUtil.flowerPot((FeatureFlag[])new FeatureFlag[0])));
    public static final RegistryObject<Block> POTTED_BUTTERCUP = HELPER.createBlockNoItem("potted_buttercup", () -> new FlowerPotBlock((Block)BUTTERCUP.get(), PropertyUtil.flowerPot((FeatureFlag[])new FeatureFlag[0])));

    public static void setupTabEditors() {
        CreativeModeTabContentsPopulator.mod((String)"buzzier_bees").tab(CreativeModeTabs.f_256788_).addItems(new Supplier[]{() -> Blocks.f_50720_, HONEYCOMB_BRICKS, HONEYCOMB_BRICK_STAIRS, HONEYCOMB_BRICK_SLAB, HONEYCOMB_BRICK_WALL, CHISELED_HONEYCOMB_BRICKS, HONEYCOMB_TILES, HONEYCOMB_TILE_STAIRS, HONEYCOMB_TILE_SLAB, HONEYCOMB_TILE_WALL, HONEYCOMB_DOOR, HONEYCOMB_TRAPDOOR}).tab(CreativeModeTabs.f_256776_).addItemsAfter((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50719_}), new Supplier[]{CRYSTALLIZED_HONEY_BLOCK}).addItemsAfter((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50071_}), new Supplier[]{WHITE_CLOVER, PINK_CLOVER, BUTTERCUP}).tab(CreativeModeTabs.f_256791_).addItemsAfter(BBBlocks.modLoaded((ItemLike)Blocks.f_152482_, "caverns_and_chasms"), new Supplier[]{CUPRIC_CANDLE}).addItemsAfter(BBBlocks.modLoaded((ItemLike)Blocks.f_152482_, "endergetic"), new Supplier[]{ENDER_CANDLE}).addItemsAfter((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_152482_}), new Supplier[]{SOUL_CANDLE}).addItemsAfter((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50489_}), new Supplier[]{HONEY_LAMP});
    }

    public static Predicate<ItemStack> modLoaded(ItemLike item, String ... modids) {
        return stack -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}).test(stack) && BlockSubRegistryHelper.areModsLoaded((String[])modids);
    }

    public static class BBBlockProperties {
        public static final BlockSetType HONEYCOMB = BlockSetTypeRegistryHelper.register((BlockSetType)new BlockSetType("buzzier_bees:honeycomb", true, SoundType.f_56753_, SoundEvents.f_12626_, SoundEvents.f_12627_, SoundEvents.f_12628_, SoundEvents.f_12629_, SoundEvents.f_12636_, SoundEvents.f_12637_, SoundEvents.f_12631_, SoundEvents.f_12632_));
        public static final BlockBehaviour.Properties CRYSTALLIZED_HONEY = BlockBehaviour.Properties.m_284310_().m_60955_().m_60911_(0.98f).m_60978_(0.3f).m_60918_(SoundType.f_56744_).m_278166_(PushReaction.DESTROY);
        public static final BlockBehaviour.Properties HONEYCOMB_BRICKS = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283750_).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56753_);
        public static final BlockBehaviour.Properties HONEYCOMB_DOOR = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283750_).m_60978_(3.0f).m_60955_().m_278166_(PushReaction.DESTROY);
        public static final BlockBehaviour.Properties HONEYCOMB_TRAPDOOR = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283750_).m_60978_(3.0f).m_60955_().m_278166_(PushReaction.DESTROY).m_60922_(PropertyUtil::never);
        public static final BlockBehaviour.Properties SOUL_CANDLE = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_60955_().m_60978_(0.1f).m_60918_(SoundType.f_154653_).m_60953_(SpecialCandleBlock.DIM_LIGHT_EMISSION).m_278166_(PushReaction.DESTROY);
        public static final BlockBehaviour.Properties SOUL_CANDLE_CAKE = BlockBehaviour.Properties.m_284310_().m_280606_().m_60978_(0.5f).m_60918_(SoundType.f_56745_).m_278166_(PushReaction.DESTROY).m_60953_(BBBlockProperties.getLightValueLit(2));
        public static final BlockBehaviour.Properties ENDER_CANDLE = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283889_).m_60955_().m_60978_(0.1f).m_60918_(SoundType.f_154653_).m_60953_(CandleBlock.f_152793_).m_278166_(PushReaction.DESTROY);
        public static final BlockBehaviour.Properties ENDER_CANDLE_CAKE = BlockBehaviour.Properties.m_284310_().m_280606_().m_60978_(0.5f).m_60918_(SoundType.f_56745_).m_278166_(PushReaction.DESTROY).m_60953_(BBBlockProperties.getLightValueLit(3));
        public static final BlockBehaviour.Properties CUPRIC_CANDLE = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283750_).m_60955_().m_60978_(0.1f).m_60918_(SoundType.f_154653_).m_60953_(SpecialCandleBlock.DIM_LIGHT_EMISSION).m_278166_(PushReaction.DESTROY);
        public static final BlockBehaviour.Properties CUPRIC_CANDLE_CAKE = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_).m_60953_(BBBlockProperties.getLightValueLit(2));

        private static ToIntFunction<BlockState> getLightValueLit(int lightValue) {
            return state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? lightValue : 0;
        }
    }
}

