/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.networkLink;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.packagerLink.LogisticsManager;
import com.simibubi.create.content.logistics.packagerLink.RequestPromise;
import com.simibubi.create.content.logistics.packagerLink.RequestPromiseQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import ru.zznty.create_factory_abstractions.api.generic.stack.GenericStack;
import ru.zznty.create_factory_abstractions.generic.support.BigGenericStack;
import ru.zznty.create_factory_abstractions.generic.support.GenericInventorySummary;
import ru.zznty.create_factory_logistics.logistics.networkLink.NetworkLinkMode;

abstract class BaseNetworkHandler {
    protected final UUID network;
    private final NetworkLinkMode mode;
    private List<GenericStack> cachedIngredients = null;

    BaseNetworkHandler(UUID network, NetworkLinkMode mode) {
        this.network = network;
        this.mode = mode;
    }

    protected List<GenericStack> summary() {
        if (this.cachedIngredients == null) {
            RequestPromiseQueue queue;
            if (this.mode.includesStored()) {
                GenericInventorySummary summary = GenericInventorySummary.of((InventorySummary)LogisticsManager.getSummaryOfNetwork((UUID)this.network, (boolean)true));
                this.cachedIngredients = summary.get();
            } else {
                this.cachedIngredients = new ArrayList<GenericStack>();
            }
            if (this.mode.includesPromised() && (queue = Create.LOGISTICS.getQueuedPromises(this.network)) != null) {
                for (RequestPromise promise : queue.flatten(false)) {
                    BigGenericStack stack = BigGenericStack.of((BigItemStack)promise.promisedStack);
                    if (stack.get().isEmpty()) continue;
                    this.cachedIngredients.add(stack.get());
                }
            }
        }
        return this.cachedIngredients;
    }
}

