/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.crafting;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public record StackedIngredient(Ingredient ingredient, int count) {
    public static final StackedIngredient EMPTY = new StackedIngredient(Ingredient.f_43901_, 0);

    public static StackedIngredient fromJson(JsonElement element) {
        Preconditions.checkArgument((boolean)element.isJsonObject(), (Object)"Element must be a json object");
        Ingredient ingredient = Ingredient.m_43917_((JsonElement)element);
        int count = GsonHelper.m_13824_((JsonObject)((JsonObject)element), (String)"count", (int)1);
        return new StackedIngredient(ingredient, count);
    }

    public static StackedIngredient fromNetwork(FriendlyByteBuf buffer) {
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        int count = buffer.readInt();
        return new StackedIngredient(ingredient, count);
    }

    public static StackedIngredient of(TagKey<Item> tag, int count) {
        return new StackedIngredient(Ingredient.m_204132_(tag), count);
    }

    public static StackedIngredient of(ItemStack stack) {
        return new StackedIngredient(Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}), stack.m_41613_());
    }

    public static StackedIngredient of(Ingredient ingredient, int count) {
        return new StackedIngredient(ingredient, count);
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        this.ingredient.m_43923_(buffer);
        buffer.writeInt(this.count);
    }

    public JsonElement toJson() {
        JsonElement element = this.ingredient.m_43942_();
        if (element instanceof JsonObject) {
            JsonObject object = (JsonObject)element;
            object.addProperty("count", (Number)this.count);
        }
        return element;
    }
}

