/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import traben.entity_model_features.EMF;
import traben.entity_model_features.EMFManager;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.models.jem_objects.EMFPartData;
import traben.entity_model_features.models.parts.EMFModelPartRoot;

public class EMFUtils {
    private static final String MOD_ID_SHORT = "EMF";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"EMF");

    @NotNull
    public static ResourceLocation res(String fullPath) {
        return new ResourceLocation(fullPath);
    }

    @NotNull
    public static ResourceLocation res(String namespace, String path) {
        return new ResourceLocation(namespace, path);
    }

    public static EMFModelPartRoot getArrowOrNull(ModelLayerLocation layer) {
        if (EMF.testForForgeLoadingError()) {
            return null;
        }
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        ModelPart part = modelPartData.m_171583_(32, 32);
        ModelPart possiblyEMF = EMFManager.getInstance().injectIntoModelRootGetter(layer, part);
        if (possiblyEMF instanceof EMFModelPartRoot) {
            return (EMFModelPartRoot)possiblyEMF;
        }
        return null;
    }

    public static void overrideMessage(String originalClass, String overriddenClassFromMod, boolean wasReverted) {
        LOGGER.warn("[EMF]: Entity model [" + originalClass + "] has been overridden by [" + overriddenClassFromMod + "] likely from a mod.");
        if (wasReverted) {
            LOGGER.warn("[EMF]: Prevent model overrides option is enabled! EMF will attempt to revert the new model [" + overriddenClassFromMod + "] back into the original model [" + originalClass + "]. THIS MAY HAVE UNINTENDED EFFECTS ON THE OTHER MOD, DISABLE THIS EMF SETTING IF IT CAUSES CRASHES!");
        }
    }

    public static void log(String message) {
        EMFUtils.log(message, false, false);
    }

    public static void log(String message, boolean inChat) {
        EMFUtils.log(message, inChat, false);
    }

    public static void log(String message, boolean inChat, boolean noPrefix) {
        if (inChat) {
            LocalPlayer plyr = Minecraft.m_91087_().f_91074_;
            if (plyr != null) {
                plyr.m_5661_(Component.m_130674_((String)((noPrefix ? "" : "\u00a76[EMF]:\u00a7r ") + message)), false);
            } else {
                LOGGER.info((noPrefix ? "" : "[EMF]: ") + message);
            }
        } else {
            LOGGER.info((noPrefix ? "" : "[EMF]: ") + message);
        }
    }

    public static void chat(String message) {
        LocalPlayer plyr = Minecraft.m_91087_().f_91074_;
        if (plyr != null) {
            plyr.m_5661_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(message)), false);
        }
    }

    public static void logWarn(String message) {
        EMFUtils.logWarn(message, false);
    }

    public static void logWarn(String message, boolean inChat) {
        if (inChat) {
            LocalPlayer plyr = Minecraft.m_91087_().f_91074_;
            if (plyr != null) {
                plyr.m_5661_(Component.m_130674_((String)("\u00a76[EMF]\u00a7r: " + message)), false);
            } else {
                LOGGER.warn("[EMF]: " + message);
            }
        } else {
            LOGGER.warn("[EMF]: " + message);
        }
    }

    public static void logError(String message) {
        EMFUtils.logError(message, false);
    }

    public static void logError(String message, boolean inChat) {
        if (inChat) {
            LocalPlayer plyr = Minecraft.m_91087_().f_91074_;
            if (plyr != null) {
                plyr.m_5661_(Component.m_130674_((String)("\u00a76[EMF]\u00a7r: " + message)), false);
            } else {
                LOGGER.error("[EMF]: " + message);
            }
        } else {
            LOGGER.error("[EMF]: " + message);
        }
    }

    @Nullable
    public static EMFPartData readModelPart(ResourceLocation location) {
        EMFPartData eMFPartData;
        Optional res = Minecraft.m_91087_().m_91098_().m_213713_(location);
        if (res.isEmpty()) {
            if (((EMFConfig)EMF.config().getConfig()).logModelCreationData) {
                EMFUtils.log("jpm failed " + location + " does not exist", false);
            }
            return null;
        }
        Resource jpmResource = (Resource)res.get();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        BufferedReader reader = new BufferedReader(new InputStreamReader(jpmResource.m_215507_()));
        try {
            eMFPartData = (EMFPartData)gson.fromJson((Reader)reader, EMFPartData.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                if (((EMFConfig)EMF.config().getConfig()).logModelCreationData) {
                    EMFUtils.log("jpm [" + location.toString() + "] failed " + e, false);
                }
                return null;
            }
        }
        reader.close();
        return eMFPartData;
    }

    public static String getIdUnique(Set<String> known, String desired) {
        while (known.contains(desired) || ((String)desired).isBlank()) {
            desired = (String)desired + "#";
        }
        return desired;
    }
}

