/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.containers;

import com.alc.moreminecarts.misc.SingleSlot;
import com.alc.moreminecarts.proxy.MoreMinecartsPacketHandler;
import com.alc.moreminecarts.registry.MMContainers;
import com.alc.moreminecarts.tile_entities.AbstractCommonLoader;
import com.alc.moreminecarts.tile_entities.FilterUnloaderTile;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

public class FilterUnloaderContainer
extends AbstractContainerMenu {
    private final Container inventory;
    private final ContainerData data;
    private final Level level;
    private AbstractCommonLoader tile;

    public FilterUnloaderContainer(int n, Level world, Inventory player_inventory, Player player_entity) {
        super((MenuType)MMContainers.MINECART_LOADER_CONTAINER.get(), n);
        this.tile = null;
        this.level = player_inventory.f_35978_.m_9236_();
        this.inventory = new SimpleContainer(18);
        this.data = new SimpleContainerData(5);
        this.CommonInitialization(player_inventory);
    }

    public FilterUnloaderContainer(int n, Level world, BlockPos pos, Inventory player_inventory, Player player_entity) {
        super((MenuType)MMContainers.FILTER_UNLOADER_CONTAINER.get(), n);
        BlockEntity te = world.m_7702_(pos);
        FilterUnloaderTile unloader = (FilterUnloaderTile)te;
        this.inventory = unloader;
        this.data = unloader.dataAccess;
        this.tile = unloader;
        this.level = player_inventory.f_35978_.m_9236_();
        this.CommonInitialization(player_inventory);
    }

    public FilterUnloaderContainer(int p_38969_, Inventory p_38970_, Container p_38971_, ContainerData p_38972_, BlockPos tilePos) {
        super((MenuType)MMContainers.FILTER_UNLOADER_CONTAINER.get(), p_38969_);
        this.level = p_38970_.f_35978_.m_9236_();
        this.tile = (AbstractCommonLoader)this.level.m_7702_(tilePos);
        this.inventory = p_38971_;
        this.data = p_38972_;
        this.CommonInitialization(p_38970_);
    }

    public void CommonInitialization(Inventory player_inventory) {
        int i;
        FilterUnloaderContainer.m_38869_((Container)this.inventory, (int)18);
        FilterUnloaderContainer.m_38886_((ContainerData)this.data, (int)5);
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot(this.inventory, i, 8 + i * 18, 29));
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new SingleSlot(this.inventory, 9 + i, 8 + i * 18, 51));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)player_inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)player_inventory, k, 8 + k * 18, 142));
        }
        this.m_38884_(this.data);
    }

    public boolean m_6875_(Player player) {
        return this.inventory.m_6542_(player);
    }

    public ItemStack m_7648_(Player p_82846_1_, int p_82846_2_) {
        int containerRows = 1;
        ItemStack lvt_3_1_ = ItemStack.f_41583_;
        Slot lvt_4_1_ = (Slot)this.f_38839_.get(p_82846_2_);
        if (lvt_4_1_ != null && lvt_4_1_.m_6657_()) {
            ItemStack lvt_5_1_ = lvt_4_1_.m_7993_();
            lvt_3_1_ = lvt_5_1_.m_41777_();
            if (p_82846_2_ < containerRows * 9 ? !this.m_38903_(lvt_5_1_, containerRows * 9, this.f_38839_.size(), true) : !this.m_38903_(lvt_5_1_, 0, containerRows * 9, false)) {
                return ItemStack.f_41583_;
            }
            if (lvt_5_1_.m_41619_()) {
                lvt_4_1_.m_5852_(ItemStack.f_41583_);
            } else {
                lvt_4_1_.m_6654_();
            }
        }
        return lvt_3_1_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSize() {
        return 18;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public FluidStack getFluids() {
        if (this.tile == null) {
            this.AttemptFindTile();
            if (this.tile == null) {
                return null;
            }
        }
        return this.tile.getFluidStack();
    }

    public int getEnergy() {
        if (this.tile == null) {
            this.AttemptFindTile();
            if (this.tile == null) {
                return 0;
            }
        }
        return this.tile.getEnergyAmount();
    }

    protected void AttemptFindTile() {
        BlockPos location = new BlockPos(this.data.m_6413_(2), this.data.m_6413_(3), this.data.m_6413_(4));
        if (location.m_123341_() == 0 && location.m_123342_() == 0 && location.m_123343_() == 0) {
            return;
        }
        BlockEntity ent = this.level.m_7702_(location);
        if (ent == null || !(ent instanceof AbstractCommonLoader)) {
            return;
        }
        this.tile = (AbstractCommonLoader)ent;
    }

    public boolean getRedstoneOutput() {
        return (this.data.m_6413_(0) & 0x10) == 16;
    }

    public boolean getLockedMinecartsOnly() {
        return this.data.m_6413_(0) % 2 == 1;
    }

    public boolean getLeaveOneInStack() {
        return (this.data.m_6413_(0) & 2) == 2;
    }

    public AbstractCommonLoader.ComparatorOutputType getComparatorOutputType() {
        return AbstractCommonLoader.ComparatorOutputType.fromInt((this.data.m_6413_(0) & 0xC) >> 2);
    }

    public FilterUnloaderTile.FilterType getFilterType() {
        return FilterUnloaderTile.FilterType.fromInt((this.data.m_6413_(0) & 0x60) >> 5);
    }

    public MoreMinecartsPacketHandler.MinecartLoaderPacket getCurrentPacket() {
        return new MoreMinecartsPacketHandler.MinecartLoaderPacket(false, this.getLockedMinecartsOnly(), this.getLeaveOneInStack(), this.getComparatorOutputType(), this.getRedstoneOutput(), this.getFilterType());
    }

    public boolean getIsUnloader() {
        return this.data.m_6413_(1) >= 1;
    }

    public void setOptions(boolean locked_minecarts_only, boolean leave_one_in_stack, AbstractCommonLoader.ComparatorOutputType comparator_output, boolean redstone_output, FilterUnloaderTile.FilterType filterType) {
        int options = (locked_minecarts_only ? 1 : 0) + ((leave_one_in_stack ? 1 : 0) << 1) + (comparator_output.toInt() << 2) + ((redstone_output ? 1 : 0) << 4) + (filterType.toInt() << 5);
        this.m_7511_(0, options);
        this.m_38946_();
    }
}

