/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.unusualfishmod.common.entity;

import codyhuh.unusualfishmod.common.entity.util.misc.UFAnimations;
import codyhuh.unusualfishmod.core.registry.UFItems;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class LobedSkipper
extends PathfinderMob
implements Bucketable,
GeoEntity {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(LobedSkipper.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int jumpTicks;
    private int jumpDuration;
    private boolean wasOnGround;
    private int currentMoveTypeDuration;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public LobedSkipper(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.f_21343_ = new SkipperJumpController();
        this.f_21342_ = new SkipperMoveController();
        this.setMovementSpeed(0.0);
        this.m_274367_(1.1f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22279_, 0.5);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 0.5f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Nonnull
    public MoveControl m_21566_() {
        return this.f_21342_;
    }

    @Nonnull
    public JumpControl m_21569_() {
        return this.f_21343_;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected float m_6431_(@Nonnull Pose pose, EntityDimensions size) {
        return 0.2f * size.f_20378_;
    }

    public void m_8119_() {
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.m_6862_(false);
        }
        super.m_8119_();
        this.f_19859_ = this.f_20886_;
        this.m_146922_(this.f_20885_);
    }

    protected float m_6118_() {
        float motion = super.m_6118_();
        return motion;
    }

    public void m_8024_() {
        if (this.currentMoveTypeDuration > 0) {
            --this.currentMoveTypeDuration;
        }
        if (this.m_20096_()) {
            SkipperJumpController jumpHelper;
            if (!this.wasOnGround) {
                this.m_6862_(false);
                this.checkLandingDelay();
            }
            if (!(jumpHelper = (SkipperJumpController)this.f_21343_).getIsJumping()) {
                if (this.f_21342_.m_24995_() && this.currentMoveTypeDuration == 0) {
                    Path path = this.f_21344_.m_26570_();
                    Vec3 Vector3d = new Vec3(this.f_21342_.m_25000_(), this.f_21342_.m_25001_(), this.f_21342_.m_25002_());
                    if (path != null && path.m_77399_() < path.m_77398_()) {
                        Vector3d = path.m_77380_((Entity)this);
                    }
                    this.calculateRotationYaw(Vector3d.f_82479_, Vector3d.f_82481_);
                    this.startJumping();
                }
            } else if (!jumpHelper.canJump()) {
                this.enableJumpControl();
            }
        }
        this.wasOnGround = this.m_20096_();
    }

    public boolean m_5843_() {
        return false;
    }

    private void calculateRotationYaw(double x, double z) {
        Vec3 pos = this.m_20182_();
        this.m_146922_((float)(Mth.m_14136_((double)(z - pos.f_82481_), (double)(x - pos.f_82479_)) * 57.29577951308232) - 90.0f);
    }

    private void enableJumpControl() {
        ((SkipperJumpController)this.f_21343_).setCanJump(true);
    }

    private void disableJumpControl() {
        ((SkipperJumpController)this.f_21343_).setCanJump(false);
    }

    private void updateMoveTypeDuration() {
        this.currentMoveTypeDuration = this.f_21342_.m_24999_() < 2.2 ? 10 : 1;
    }

    private void checkLandingDelay() {
        this.updateMoveTypeDuration();
        this.disableJumpControl();
    }

    protected void m_6135_() {
        super.m_6135_();
        double d0 = this.f_21342_.m_24999_();
        if (d0 > 0.0) {
            Vec3 motion = this.m_20184_();
            double d1 = motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_;
            if (d1 < 0.01) {
                this.m_19920_(0.1f, new Vec3(0.0, 0.0, 1.0));
            }
        }
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_7605_((Entity)this, (byte)1);
        }
    }

    public void setMovementSpeed(double newSpeed) {
        this.m_21573_().m_26517_(newSpeed);
        this.f_21342_.m_6849_(this.f_21342_.m_25000_(), this.f_21342_.m_25001_(), this.f_21342_.m_25002_(), newSpeed);
    }

    public void m_6862_(boolean jumping) {
        super.m_6862_(jumping);
    }

    public void startJumping() {
        this.m_6862_(true);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 1) {
            this.jumpDuration = 10;
            this.jumpTicks = 0;
        } else {
            super.m_7822_(id);
        }
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Bucketed", this.m_27487_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_27497_(compound.m_128471_("Bucketed"));
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean p_203706_1_) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)p_203706_1_);
    }

    public void m_6872_(ItemStack bucket) {
        CompoundTag compoundnbt = bucket.m_41784_();
        compoundnbt.m_128350_("Health", this.m_21223_());
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    public boolean m_6785_(double p_213397_1_) {
        return !this.m_27487_() && !this.m_8077_();
    }

    public void m_142278_(CompoundTag p_148832_) {
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_11779_;
    }

    protected InteractionResult m_6071_(Player p_27477_, InteractionHand p_27478_) {
        return Bucketable.m_148828_((Player)p_27477_, (InteractionHand)p_27478_, (LivingEntity)this).orElse(super.m_6071_(p_27477_, p_27478_));
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)UFItems.SKIPPER_BUCKET.get());
    }

    public static boolean canSpawn(EntityType type, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        return worldIn.m_8055_(pos.m_7495_()).m_60815_();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    private <E extends GeoEntity> PlayState predicate(AnimationState<E> event) {
        if (this.m_20069_()) {
            if (event.isMoving()) {
                event.setAnimation(UFAnimations.SWIM);
            } else {
                event.setAnimation(UFAnimations.IDLE);
            }
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public class SkipperJumpController
    extends JumpControl {
        private boolean canJump;

        public SkipperJumpController() {
            super((Mob)LobedSkipper.this);
        }

        public boolean getIsJumping() {
            return this.f_24897_;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean canJumpIn) {
            this.canJump = canJumpIn;
        }

        public void m_8124_() {
            if (this.f_24897_) {
                LobedSkipper.this.startJumping();
                this.f_24897_ = false;
            }
        }
    }

    public class SkipperMoveController
    extends MoveControl {
        private double nextJumpSpeed;

        public SkipperMoveController() {
            super((Mob)LobedSkipper.this);
        }

        public void m_8126_() {
            if (LobedSkipper.this.m_20096_() && !LobedSkipper.this.f_20899_ && !((SkipperJumpController)LobedSkipper.this.f_21343_).getIsJumping()) {
                LobedSkipper.this.setMovementSpeed(0.0);
            } else if (this.m_24995_()) {
                LobedSkipper.this.setMovementSpeed(this.nextJumpSpeed);
            }
            super.m_8126_();
        }

        public void m_6849_(double x, double y, double z, double speedIn) {
            if (LobedSkipper.this.m_20069_()) {
                speedIn = 1.5;
            }
            super.m_6849_(x, y, z, speedIn);
            if (speedIn > 0.0) {
                this.nextJumpSpeed = speedIn;
            }
        }
    }
}

