/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.placementcondition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.worldgen.placementcondition.PlacementCondition;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.InclusiveRange;

public record GridPlacementCondition(int radius, int distBetweenPoints, PlacementCondition condition, InclusiveRange<Integer> allowedCount) implements PlacementCondition
{
    public static final MapCodec<GridPlacementCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.f_144629_.fieldOf("radius").forGetter(GridPlacementCondition::radius), (App)Codec.intRange((int)4, (int)1024).fieldOf("distance_between_points").forGetter(GridPlacementCondition::distBetweenPoints), (App)PlacementCondition.BASE_CODEC.fieldOf("condition").forGetter(GridPlacementCondition::condition), (App)InclusiveRange.f_184562_.fieldOf("allowed_count").forGetter(GridPlacementCondition::allowedCount)).apply((Applicative)instance, GridPlacementCondition::new));

    @Override
    public boolean test(PlacementCondition.Context context, BlockPos pos) {
        int count = 0;
        for (int x = pos.m_123341_() - this.radius; x <= pos.m_123341_() + this.radius; x += this.distBetweenPoints) {
            for (int z = pos.m_123343_() - this.radius; z <= pos.m_123343_() + this.radius; z += this.distBetweenPoints) {
                if (!this.condition.test(context, new BlockPos(x, pos.m_123342_(), z)) || (Integer)this.allowedCount.f_184564_() >= ++count) continue;
                return false;
            }
        }
        return this.allowedCount.m_184578_((Comparable)Integer.valueOf(count));
    }

    @Override
    public MapCodec<? extends PlacementCondition> codec() {
        return CODEC;
    }
}

