/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.server.data;

import com.bonker.stardewfishing.StardewFishing;
import com.bonker.stardewfishing.server.ModifierOperation;
import com.bonker.stardewfishing.server.event.StardewMinigameStartedEvent;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public final class MinigameModifiers {
    private static final Component PIXELS = Component.m_237115_((String)"tooltip.stardew_fishing.modifier.pixels");
    private static final Component SECONDS = Component.m_237115_((String)"tooltip.stardew_fishing.modifier.seconds");
    private static final Component PIXELS_PER_SECOND = Component.m_237115_((String)"tooltip.stardew_fishing.modifier.pixels_per_second");
    private static final Component PIXELS_PER_SECOND_SQUARED = Component.m_237115_((String)"tooltip.stardew_fishing.modifier.pixels_per_second_squared");
    private static final Component PERCENT = Component.m_237115_((String)"tooltip.stardew_fishing.modifier.percent");
    private static final Component TIERS = Component.m_237115_((String)"tooltip.stardew_fishing.modifier.tiers");
    private final Map<Type, ModifierOperation> modifierMap;
    private final List<Component> tooltip;
    public static final Codec<MinigameModifiers> CODEC = RecordCodecBuilder.create(inst -> inst.group(MinigameModifiers.m(0), MinigameModifiers.m(1), MinigameModifiers.m(2), MinigameModifiers.m(3), MinigameModifiers.m(4), MinigameModifiers.m(5), MinigameModifiers.m(6), MinigameModifiers.m(7), MinigameModifiers.m(8), MinigameModifiers.m(9), MinigameModifiers.m(10)).apply((Applicative)inst, (xva$0, xva$1, xva$2, xva$3, xva$4, xva$5, xva$6, xva$7, xva$8, xva$9, xva$10) -> new MinigameModifiers((ModifierOperation)xva$0, (ModifierOperation)xva$1, (ModifierOperation)xva$2, (ModifierOperation)xva$3, (ModifierOperation)xva$4, (ModifierOperation)xva$5, (ModifierOperation)xva$6, (ModifierOperation)xva$7, (ModifierOperation)xva$8, (ModifierOperation)xva$9, (ModifierOperation)xva$10)));

    public MinigameModifiers(ModifierOperation ... operations) {
        if (operations.length != Type.values().length) {
            throw new RuntimeException("Minigame modifiers does not cover all types: " + Arrays.toString(operations));
        }
        this.modifierMap = new TreeMap<Type, ModifierOperation>();
        for (int i = 0; i < operations.length; ++i) {
            this.modifierMap.put(Type.values()[i], operations[i]);
        }
        this.tooltip = this.makeTooltip();
    }

    public void apply(StardewMinigameStartedEvent event) {
        event.setIdleTime(this.modifierMap.get((Object)Type.IDLE_TIME).apply(event.getIdleTime()));
        event.setTopSpeed(this.modifierMap.get((Object)Type.TOP_SPEED).apply(event.getTopSpeed()));
        event.setUpAcceleration(this.modifierMap.get((Object)Type.UP_ACCELERATION).apply(event.getUpAcceleration()));
        event.setDownAcceleration(this.modifierMap.get((Object)Type.DOWN_ACCELERATION).apply(event.getDownAcceleration()));
        event.setAvgDistance(this.modifierMap.get((Object)Type.AVG_DISTANCE).apply(event.getAvgDistance()));
        event.setMoveVariation(this.modifierMap.get((Object)Type.MOVE_VARIATION).apply(event.getMoveVariation()));
        event.setLineStrength(this.modifierMap.get((Object)Type.LINE_STRENGTH).apply(event.getLineStrength()));
        event.setBarSize(this.modifierMap.get((Object)Type.BAR_SIZE).apply(event.getBarSize()));
        event.setTreasureChanceBonus(this.modifierMap.get((Object)Type.TREASURE_CHANCE_BONUS).apply(event.getTreasureChanceBonus()));
        event.setExpMultiplier(this.modifierMap.get((Object)Type.EXP_MULTIPLIER).apply(event.getExpMultiplier()));
        event.setQualityBoost(this.modifierMap.get((Object)Type.QUALITY_BOOST).apply(event.getQualityBoost()));
    }

    public void appendTooltip(List<Component> list) {
        list.addAll(this.tooltip);
    }

    public MinigameModifiers merge(MinigameModifiers other) {
        for (Type type : Type.values()) {
            this.modifierMap.computeIfPresent(type, (t, operation) -> operation.merge(other.modifierMap.get(t)));
        }
        return this;
    }

    private List<Component> makeTooltip() {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        boolean combineAccelerations = this.modifierMap.get((Object)Type.UP_ACCELERATION).equals(this.modifierMap.get((Object)Type.DOWN_ACCELERATION));
        for (Map.Entry<Type, ModifierOperation> entry : this.modifierMap.entrySet()) {
            Type type = entry.getKey();
            ModifierOperation operation = entry.getValue();
            if (combineAccelerations && type == Type.DOWN_ACCELERATION || !StardewFishing.QUALITY_FOOD_INSTALLED && type == Type.QUALITY_BOOST || !operation.matters()) continue;
            Object key = combineAccelerations && type == Type.UP_ACCELERATION ? "tooltip.stardew_fishing.modifier.both_acceleration" : "tooltip.stardew_fishing.modifier." + type;
            MutableComponent operationComponent = Component.m_237113_((String)(type == Type.IDLE_TIME ? operation.toString(0.05) : operation.toString()));
            if (operation.type() != ModifierOperation.Type.MULTIPLICATION) {
                operationComponent = operationComponent.m_7220_(type.getUnits());
            }
            boolean good = operation.isPositive() == type.higherIsBetter();
            operationComponent = operationComponent.m_130948_(good ? StardewFishing.GREEN : StardewFishing.RED);
            tooltip.add((Component)Component.m_237110_((String)key, (Object[])new Object[]{operationComponent}).m_130948_(StardewFishing.LIGHTER_COLOR));
        }
        return tooltip;
    }

    private static RecordCodecBuilder<MinigameModifiers, ModifierOperation> m(int i) {
        return ModifierOperation.CODEC.optionalFieldOf(Type.values()[i].toString(), (Object)ModifierOperation.DEFAULT).forGetter(o -> o.modifierMap.get((Object)Type.values()[i]));
    }

    public static enum Type {
        IDLE_TIME,
        TOP_SPEED,
        UP_ACCELERATION,
        DOWN_ACCELERATION,
        AVG_DISTANCE,
        MOVE_VARIATION,
        LINE_STRENGTH,
        BAR_SIZE,
        TREASURE_CHANCE_BONUS,
        EXP_MULTIPLIER,
        QUALITY_BOOST;


        public boolean higherIsBetter() {
            return switch (this) {
                case IDLE_TIME, LINE_STRENGTH, BAR_SIZE, TREASURE_CHANCE_BONUS, EXP_MULTIPLIER, QUALITY_BOOST -> true;
                default -> false;
            };
        }

        public Component getUnits() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case IDLE_TIME -> SECONDS;
                case BAR_SIZE, AVG_DISTANCE, MOVE_VARIATION -> PIXELS;
                case TOP_SPEED -> PIXELS_PER_SECOND;
                case UP_ACCELERATION, DOWN_ACCELERATION -> PIXELS_PER_SECOND_SQUARED;
                case LINE_STRENGTH, TREASURE_CHANCE_BONUS, EXP_MULTIPLIER -> PERCENT;
                case QUALITY_BOOST -> TIERS;
            };
        }

        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

