/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.mixin.iris;

import com.google.common.collect.ImmutableSet;
import com.llamalad7.mixinextras.sugar.Local;
import dev.djefrey.colorwheel.accessors.IrisRenderingPipelineAccessor;
import dev.djefrey.colorwheel.accessors.ShadowRenderTargetsAccessor;
import dev.djefrey.colorwheel.accessors.ShadowRendererAccessor;
import dev.djefrey.colorwheel.engine.BeginTranslucentRenderFunction;
import dev.djefrey.colorwheel.engine.ClrwlEngine;
import dev.engine_room.flywheel.impl.visualization.VisualizationManagerImpl;
import net.irisshaders.iris.gl.framebuffer.GlFramebuffer;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.shaderpack.programs.ProgramSource;
import net.irisshaders.iris.shadows.ShadowRenderTargets;
import net.irisshaders.iris.shadows.ShadowRenderer;
import net.irisshaders.iris.targets.RenderTargets;
import net.minecraft.world.level.LevelAccessor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={IrisRenderingPipeline.class})
public abstract class IrisRenderingPipelineMixin
implements IrisRenderingPipelineAccessor {
    @Shadow
    @Final
    private RenderTargets renderTargets;
    @Shadow
    @Final
    private ImmutableSet<Integer> flippedAfterPrepare;
    @Shadow
    @Final
    private ImmutableSet<Integer> flippedAfterTranslucent;
    @Shadow
    @Final
    private ShadowRenderer shadowRenderer;
    @Unique
    private boolean colorwheel$hasFramebufferChanged = false;
    @Unique
    private BeginTranslucentRenderFunction colorwheel$beginTranslucentCallback = null;

    @Override
    public GlFramebuffer colorwheel$createSolidGbuffersFramebuffer(ProgramSource sources) {
        int[] drawBuffers = sources.getDirectives().getDrawBuffers();
        return this.renderTargets.createGbufferFramebuffer(this.flippedAfterPrepare, drawBuffers);
    }

    @Override
    public GlFramebuffer colorwheel$createTranslucentGbuffersFramebuffer(ProgramSource sources) {
        int[] drawBuffers = sources.getDirectives().getDrawBuffers();
        return this.renderTargets.createGbufferFramebuffer(this.flippedAfterTranslucent, drawBuffers);
    }

    @Override
    public GlFramebuffer colorwheel$createShadowFramebuffer(ProgramSource sources) {
        int[] drawBuffers = sources.getDirectives().getDrawBuffers();
        ShadowRenderTargets targets = ((ShadowRendererAccessor)this.shadowRenderer).getTargets();
        return targets.createShadowFramebuffer(ImmutableSet.of(), drawBuffers);
    }

    @Override
    public RenderTargets colorwheel$getGbuffersRenderTargets() {
        return this.renderTargets;
    }

    @Override
    public ShadowRenderTargets colorwheel$getShadowRenderTargets() {
        return ((ShadowRendererAccessor)this.shadowRenderer).getTargets();
    }

    @Override
    public boolean colorwheel$consumeFramebufferChanged() {
        boolean val = this.colorwheel$hasFramebufferChanged;
        this.colorwheel$hasFramebufferChanged = false;
        return val;
    }

    @Inject(method={"beginLevelRendering()V"}, at={@At(value="RETURN")}, remap=false)
    private void onBeginLevelRendering(CallbackInfo ci, @Local boolean changed) {
        if (changed) {
            this.colorwheel$hasFramebufferChanged = true;
        }
    }

    @Inject(method={"beginTranslucents()V"}, at={@At(value="RETURN")}, remap=false)
    private void onBeginTranslucents(CallbackInfo ci) {
        if (this.colorwheel$beginTranslucentCallback != null) {
            this.colorwheel$beginTranslucentCallback.onBeginTranslucent();
        }
    }

    @Override
    public void colorwheel$setBeginTranslucentsCallback(BeginTranslucentRenderFunction fct) {
        this.colorwheel$beginTranslucentCallback = fct;
    }

    @Override
    public void colorwheel$destroyGbuffersFramebuffer(GlFramebuffer framebuffer) {
        this.renderTargets.destroyFramebuffer(framebuffer);
    }

    @Override
    public void colorwheel$destroyShadowFramebuffer(GlFramebuffer framebuffer) {
        ShadowRendererAccessor renderer = (ShadowRendererAccessor)this.shadowRenderer;
        ShadowRenderTargetsAccessor renderTargets = (ShadowRenderTargetsAccessor)renderer.getTargets();
        renderTargets.colorwheel$destroyFramebuffer(framebuffer);
    }

    @Inject(method={"destroy()V"}, at={@At(value="HEAD")}, remap=false)
    public void colorwheel$onDelete(CallbackInfo ci) {
        ClrwlEngine engine = ClrwlEngine.ENGINES.get((IrisRenderingPipeline)this);
        if (engine != null) {
            VisualizationManagerImpl.reset((LevelAccessor)engine.level());
        }
    }
}

