/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.ok_zoomer.utils;

import com.mojang.blaze3d.platform.InputConstants;
import io.github.ennuil.ok_zoomer.config.ConfigEnums;
import io.github.ennuil.ok_zoomer.config.OkZoomerConfigManager;
import io.github.ennuil.ok_zoomer.key_binds.ZoomKeyBinds;
import io.github.ennuil.ok_zoomer.utils.ModUtils;
import io.github.ennuil.ok_zoomer.utils.Portals;
import io.github.ennuil.ok_zoomer.zoom.Zoom;
import java.util.function.Predicate;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoomUtils {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Ok Zoomer");
    public static final TagKey<Item> ZOOM_DEPENDENCIES_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)ModUtils.id("zoom_dependencies"));
    public static int zoomStep = 0;
    private static Predicate<LocalPlayer> hasSpyglass = player -> player.m_7500_();
    private static boolean safeSmartOcclusion = false;

    public static void changeZoomDivisor(boolean increase) {
        if (OkZoomerConfigManager.CONFIG.features.scrollingMode.value() == ConfigEnums.ScrollingModes.EXPONENTIAL) {
            Minecraft minecraft = Minecraft.m_91087_();
            int scrollBase = (Integer)OkZoomerConfigManager.CONFIG.zoomValues.scrollBase.value();
            int scrollResolution = (Integer)OkZoomerConfigManager.CONFIG.zoomValues.scrollResolution.value();
            int upperScrollStep = (Integer)OkZoomerConfigManager.CONFIG.zoomValues.scrollStepLimit.value();
            int lowerScrollStep = 0;
            int lastZoomStep = zoomStep;
            zoomStep = increase ? Math.min(zoomStep + 1, upperScrollStep) : Math.max(zoomStep - 1, -lowerScrollStep);
            double divisor = 1.0;
            if (zoomStep != 0) {
                divisor = Math.pow(scrollBase, (double)zoomStep / (double)scrollResolution);
                Zoom.setZoomDivisor(divisor);
            } else {
                Zoom.setZoomDivisor(1.0);
            }
            if (lastZoomStep != zoomStep && ((Boolean)OkZoomerConfigManager.CONFIG.tweaks.scrollSounds.value()).booleanValue()) {
                minecraft.f_91074_.m_5496_(Portals.getScrollSound(), 1.0f, 1.0f);
            }
            if (((Boolean)OkZoomerConfigManager.CONFIG.tweaks.debugScrolling.value()).booleanValue()) {
                minecraft.f_91074_.m_5661_((Component)Component.m_237113_((String)(zoomStep + " - " + divisor)), true);
            }
        } else {
            double zoomDivisor = (Double)OkZoomerConfigManager.CONFIG.legacyScrollValues.zoomDivisor.value();
            double minimumZoomDivisor = (Double)OkZoomerConfigManager.CONFIG.legacyScrollValues.minimumZoomDivisor.value();
            double maximumZoomDivisor = (Double)OkZoomerConfigManager.CONFIG.legacyScrollValues.maximumZoomDivisor.value();
            int upperScrollStep = (Integer)OkZoomerConfigManager.CONFIG.legacyScrollValues.upperScrollSteps.value();
            int lowerScrollStep = (Integer)OkZoomerConfigManager.CONFIG.legacyScrollValues.lowerScrollSteps.value();
            int n = zoomStep = increase ? Math.min(zoomStep + 1, upperScrollStep) : Math.max(zoomStep - 1, -lowerScrollStep);
            if (zoomStep > 0) {
                Zoom.setZoomDivisor(zoomDivisor + (maximumZoomDivisor - zoomDivisor) / (double)upperScrollStep * (double)zoomStep);
            } else if (zoomStep == 0) {
                Zoom.setZoomDivisor(zoomDivisor);
            } else {
                Zoom.setZoomDivisor(zoomDivisor + (minimumZoomDivisor - zoomDivisor) / (double)lowerScrollStep * (double)(-zoomStep));
            }
        }
    }

    public static void resetZoomDivisor(boolean userPrompted) {
        if (!userPrompted && !((Boolean)OkZoomerConfigManager.CONFIG.tweaks.forgetZoomDivisor.value()).booleanValue()) {
            return;
        }
        if (OkZoomerConfigManager.CONFIG.features.scrollingMode.value() == ConfigEnums.ScrollingModes.EXPONENTIAL) {
            int scrollBase = (Integer)OkZoomerConfigManager.CONFIG.zoomValues.scrollBase.value();
            int scrollResolution = (Integer)OkZoomerConfigManager.CONFIG.zoomValues.scrollResolution.value();
            zoomStep = (Integer)OkZoomerConfigManager.CONFIG.zoomValues.defaultScrollStep.value();
            Zoom.setZoomDivisor(Math.pow(scrollBase, (double)zoomStep / (double)scrollResolution));
        } else {
            zoomStep = 0;
            Zoom.setZoomDivisor((Double)OkZoomerConfigManager.CONFIG.legacyScrollValues.zoomDivisor.value());
        }
    }

    public static void keepZoomStepsWithinBounds() {
        boolean isExponential = OkZoomerConfigManager.CONFIG.features.scrollingMode.value() == ConfigEnums.ScrollingModes.EXPONENTIAL;
        int upperScrollStep = isExponential ? (Integer)OkZoomerConfigManager.CONFIG.zoomValues.scrollStepLimit.value() : (Integer)OkZoomerConfigManager.CONFIG.legacyScrollValues.upperScrollSteps.value();
        int lowerScrollStep = isExponential ? 0 : (Integer)OkZoomerConfigManager.CONFIG.legacyScrollValues.lowerScrollSteps.value();
        zoomStep = Mth.m_14045_((int)zoomStep, (int)(-lowerScrollStep), (int)upperScrollStep);
    }

    public static void unbindConflictingKey(Minecraft client, boolean userPrompted) {
        if (ZoomKeyBinds.ZOOM_KEY.m_90864_()) {
            if (client.f_91066_.f_92057_.m_90864_()) {
                if (userPrompted) {
                    LOGGER.info("[Ok Zoomer] The \"Save Toolbar Activator\" keybind was occupying C! Unbinding...");
                    client.m_91300_().m_94922_((Toast)SystemToast.m_94847_((Minecraft)client, (SystemToast.SystemToastIds)SystemToast.SystemToastIds.TUTORIAL_HINT, (Component)Component.m_237115_((String)"toast.ok_zoomer.title"), (Component)Component.m_237115_((String)"toast.ok_zoomer.unbind_conflicting_key.success")));
                } else {
                    LOGGER.info("[Ok Zoomer] The \"Save Toolbar Activator\" keybind was occupying C! Unbinding... This process won't be repeated until specified in the config.");
                }
                client.f_91066_.f_92057_.m_90848_(InputConstants.f_84822_);
                client.f_91066_.m_92169_();
                KeyMapping.m_90854_();
            } else {
                LOGGER.info("[Ok Zoomer] No conflicts with the \"Save Toolbar Activator\" keybind were found!");
                if (userPrompted) {
                    client.m_91300_().m_94922_((Toast)SystemToast.m_94847_((Minecraft)client, (SystemToast.SystemToastIds)SystemToast.SystemToastIds.TUTORIAL_HINT, (Component)Component.m_237115_((String)"toast.ok_zoomer.title"), (Component)Component.m_237115_((String)"toast.ok_zoomer.unbind_conflicting_key.no_conflict")));
                }
            }
        }
    }

    public static boolean hasSpyglass(LocalPlayer player) {
        return hasSpyglass.test(player);
    }

    public static void addSpyglassProvider(Predicate<LocalPlayer> provider) {
        hasSpyglass = hasSpyglass.or(provider);
    }

    public static void enableSafeSmartOcclusion() {
        safeSmartOcclusion = true;
    }

    public static boolean hasSmartOcclusion() {
        return (Boolean)OkZoomerConfigManager.CONFIG.tweaks.smartOcclusion.value() != false && safeSmartOcclusion;
    }

    public static boolean canSeeDistantEntities() {
        return switch ((ConfigEnums.SeeDistantEntitiesModes)OkZoomerConfigManager.CONFIG.tweaks.seeDistantEntities.value()) {
            default -> throw new IncompatibleClassChangeError();
            case ConfigEnums.SeeDistantEntitiesModes.SAFE -> safeSmartOcclusion;
            case ConfigEnums.SeeDistantEntitiesModes.ON -> true;
            case ConfigEnums.SeeDistantEntitiesModes.OFF -> false;
        };
    }
}

