/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.rawlxxxviii.visual_keybinder.ui_list;

import com.gmail.rawlxxxviii.visual_keybinder.screen.AlternativeKeybindScreen;
import com.gmail.rawlxxxviii.visual_keybinder.util.KeyUtil;
import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultKeyBindsList
extends ContainerObjectSelectionList<Entry> {
    private final AlternativeKeybindScreen parentScreen;
    protected final Options options;
    private String categoryFilter = "";
    private String keyMappingFilter = "";

    public DefaultKeyBindsList(AlternativeKeybindScreen parentScreen, Minecraft minecraft, Options options, int left, int top, int width, int height) {
        super(minecraft, width, height, top, height + top, 20);
        this.parentScreen = parentScreen;
        this.options = options;
        this.m_93496_(false);
        this.f_93393_ = left;
        this.f_93392_ = width + this.f_93393_;
        this.buildEntries();
    }

    public void setCategoryFilter(String value) {
        this.categoryFilter = value;
        this.buildEntries();
    }

    public void setKeyMappingFilter(String value) {
        this.keyMappingFilter = value;
        this.buildEntries();
    }

    private boolean isFilterMatch(String value, String filter) {
        return value.toLowerCase().contains(filter.toLowerCase());
    }

    private boolean hasFilterMatch(List<String> list, String filter) {
        for (String s : list) {
            if (!this.isFilterMatch(s, filter)) continue;
            return true;
        }
        return false;
    }

    private void buildEntries() {
        this.m_93516_();
        Object[] allKeyMappings = (KeyMapping[])ArrayUtils.clone((Object[])this.options.f_92059_);
        Arrays.sort(allKeyMappings);
        HashMap<String, List> categoryMappingsGroup = new HashMap<String, List>();
        for (Object keyMapping : allKeyMappings) {
            String category = keyMapping.m_90858_();
            if (!categoryMappingsGroup.containsKey(category)) {
                categoryMappingsGroup.put(category, new ArrayList());
            }
            ((List)categoryMappingsGroup.get(category)).add(keyMapping);
        }
        categoryMappingsGroup.forEach((arg_0, arg_1) -> this.lambda$buildEntries$1((KeyMapping[])allKeyMappings, arg_0, arg_1));
        if (this.m_6702_().isEmpty()) {
            this.m_7085_((AbstractSelectionList.Entry)new TitleEntry((Component)Component.m_237113_((String)"No results"), Color.DARK_GRAY.getRGB()));
        }
        this.m_93410_(this.m_93517_());
    }

    public int m_5759_() {
        return this.f_93388_;
    }

    public void onBindingsUpdated() {
        this.buildEntries();
    }

    protected int m_5756_() {
        return this.f_93388_ + this.f_93393_ - 6;
    }

    private /* synthetic */ void lambda$buildEntries$1(KeyMapping[] allKeyMappings, String category, List keyMappings) {
        if (!this.categoryFilter.isEmpty() && !this.isFilterMatch(Component.m_237115_((String)category).getString(), this.categoryFilter)) {
            return;
        }
        if (!this.keyMappingFilter.isEmpty() && !this.hasFilterMatch(keyMappings.stream().map(x -> Component.m_237115_((String)x.m_90860_()).getString()).toList(), this.keyMappingFilter)) {
            return;
        }
        this.m_7085_((AbstractSelectionList.Entry)new CategoryEntry((Component)Component.m_237115_((String)category)));
        for (KeyMapping keyMapping : keyMappings) {
            if (!this.keyMappingFilter.isEmpty() && !this.isFilterMatch(Component.m_237115_((String)keyMapping.m_90860_()).getString(), this.keyMappingFilter)) continue;
            this.m_7085_((AbstractSelectionList.Entry)new KeyEntry(keyMapping, (Component)Component.m_237115_((String)keyMapping.m_90860_()), KeyUtil.hasConflict(allKeyMappings, keyMapping), KeyUtil.hasDefaultConflict(allKeyMappings, keyMapping)));
        }
        this.m_7085_((AbstractSelectionList.Entry)new EmptyEntry());
    }

    @OnlyIn(value=Dist.CLIENT)
    public class TitleEntry
    extends Entry {
        final Component name;
        private final int color;

        public TitleEntry(Component p_193886_, int color) {
            this.name = p_193886_;
            this.color = color;
        }

        public void m_6311_(GuiGraphics guiGraphics, int p_193889_, int y, int p_193891_, int p_193892_, int height, int p_193894_, int p_193895_, boolean p_193896_, float p_193897_) {
            guiGraphics.m_280588_(DefaultKeyBindsList.this.getLeft(), DefaultKeyBindsList.this.getTop(), DefaultKeyBindsList.this.getRight(), DefaultKeyBindsList.this.getBottom());
            guiGraphics.m_280430_(((DefaultKeyBindsList)DefaultKeyBindsList.this).f_93386_.f_91062_, this.name, DefaultKeyBindsList.this.getLeft() + 5, y + height - 4, this.color);
            guiGraphics.m_280618_();
        }

        public List<? extends GuiEventListener> m_6702_() {
            return List.of();
        }

        public Optional<GuiEventListener> m_94729_(double p_94730_, double p_94731_) {
            return super.m_94729_(p_94730_, p_94731_);
        }

        public void m_94757_(double p_94758_, double p_94759_) {
            super.m_94757_(p_94758_, p_94759_);
        }

        public boolean m_6375_(double p_94695_, double p_94696_, int p_94697_) {
            return super.m_6375_(p_94695_, p_94696_, p_94697_);
        }

        public boolean m_6348_(double p_94722_, double p_94723_, int p_94724_) {
            return super.m_6348_(p_94722_, p_94723_, p_94724_);
        }

        public boolean m_7979_(double p_94699_, double p_94700_, int p_94701_, double p_94702_, double p_94703_) {
            return super.m_7979_(p_94699_, p_94700_, p_94701_, p_94702_, p_94703_);
        }

        public boolean m_6050_(double p_94686_, double p_94687_, double p_94688_) {
            return super.m_6050_(p_94686_, p_94687_, p_94688_);
        }

        public boolean m_7933_(int p_94710_, int p_94711_, int p_94712_) {
            return super.m_7933_(p_94710_, p_94711_, p_94712_);
        }

        public boolean m_7920_(int p_94715_, int p_94716_, int p_94717_) {
            return super.m_7920_(p_94715_, p_94716_, p_94717_);
        }

        public boolean m_5534_(char p_94683_, int p_94684_) {
            return super.m_5534_(p_94683_, p_94684_);
        }

        public void m_94725_(@Nullable GuiEventListener p_94726_) {
            super.m_94725_(p_94726_);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return List.of();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class CategoryEntry
    extends Entry {
        final Component name;

        public CategoryEntry(Component p_193886_) {
            this.name = p_193886_;
        }

        public void m_6311_(@NotNull GuiGraphics guiGraphics, int p_193889_, int p_193890_, int p_193891_, int p_193892_, int p_193893_, int p_193894_, int p_193895_, boolean p_193896_, float p_193897_) {
            guiGraphics.m_280588_(DefaultKeyBindsList.this.getLeft(), DefaultKeyBindsList.this.getTop(), DefaultKeyBindsList.this.getRight(), DefaultKeyBindsList.this.getBottom());
            guiGraphics.m_280430_(((DefaultKeyBindsList)DefaultKeyBindsList.this).f_93386_.f_91062_, this.name, DefaultKeyBindsList.this.getLeft() + 5, p_193890_ + p_193893_ - 10, AlternativeKeybindScreen.CATEGORY_COLOR);
            guiGraphics.m_280618_();
        }

        public List<? extends GuiEventListener> m_6702_() {
            return List.of();
        }

        public Optional<GuiEventListener> m_94729_(double p_94730_, double p_94731_) {
            return super.m_94729_(p_94730_, p_94731_);
        }

        public void m_94757_(double p_94758_, double p_94759_) {
            super.m_94757_(p_94758_, p_94759_);
        }

        public boolean m_6375_(double p_94695_, double p_94696_, int p_94697_) {
            return super.m_6375_(p_94695_, p_94696_, p_94697_);
        }

        public boolean m_6348_(double p_94722_, double p_94723_, int p_94724_) {
            return super.m_6348_(p_94722_, p_94723_, p_94724_);
        }

        public boolean m_7979_(double p_94699_, double p_94700_, int p_94701_, double p_94702_, double p_94703_) {
            return super.m_7979_(p_94699_, p_94700_, p_94701_, p_94702_, p_94703_);
        }

        public boolean m_6050_(double p_94686_, double p_94687_, double p_94688_) {
            return super.m_6050_(p_94686_, p_94687_, p_94688_);
        }

        public boolean m_7933_(int p_94710_, int p_94711_, int p_94712_) {
            return super.m_7933_(p_94710_, p_94711_, p_94712_);
        }

        public boolean m_7920_(int p_94715_, int p_94716_, int p_94717_) {
            return super.m_7920_(p_94715_, p_94716_, p_94717_);
        }

        public boolean m_5534_(char p_94683_, int p_94684_) {
            return super.m_5534_(p_94683_, p_94684_);
        }

        public void m_94725_(@Nullable GuiEventListener p_94726_) {
            super.m_94725_(p_94726_);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return List.of();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class KeyEntry
    extends Entry {
        private final KeyMapping key;
        private final Component name;
        private final Button changeButton;
        private final Button resetButton;
        private final boolean isConflicting;
        private final boolean isDefaultConflicting;

        KeyEntry(KeyMapping p_193916_, Component p_193917_, boolean isConflicting, boolean isDefaultConflicting) {
            this.key = p_193916_;
            this.name = p_193917_;
            this.isConflicting = isConflicting;
            this.isDefaultConflicting = isDefaultConflicting;
            this.changeButton = new Button.Builder(p_193917_, p_193939_ -> DefaultKeyBindsList.this.parentScreen.setKeyMappingToChange(p_193916_)).m_252794_(0, 0).m_253046_(100, 20).m_253136_();
            this.resetButton = new Button.Builder((Component)Component.m_237113_((String)"(").m_130946_(this.key.m_90861_().m_84875_().getString()).m_130946_(")"), p_193935_ -> {
                this.key.setToDefault();
                DefaultKeyBindsList.this.options.m_92159_(p_193916_, p_193916_.m_90861_());
                KeyMapping.m_90854_();
                DefaultKeyBindsList.this.parentScreen.onBindingsChanged();
            }).m_252794_(0, 0).m_253046_(90, 20).m_253136_();
        }

        public boolean isConflicting() {
            return this.isConflicting;
        }

        public Button getChangeButton() {
            return this.changeButton;
        }

        public Button getResetButton() {
            return this.resetButton;
        }

        public void m_6311_(@NotNull GuiGraphics guiGraphics, int p_193924_, int p_193925_, int p_193926_, int p_193927_, int p_193928_, int p_193929_, int p_193930_, boolean p_193931_, float p_193932_) {
            guiGraphics.m_280588_(DefaultKeyBindsList.this.getLeft(), DefaultKeyBindsList.this.getTop(), DefaultKeyBindsList.this.getRight(), DefaultKeyBindsList.this.getBottom());
            guiGraphics.m_280430_(((DefaultKeyBindsList)DefaultKeyBindsList.this).f_93386_.f_91062_, this.name, DefaultKeyBindsList.this.getLeft() + 5, p_193925_ + p_193928_ - 10, 0xFFFFFF);
            this.changeButton.m_252865_(p_193926_ + (int)((float)DefaultKeyBindsList.this.getWidth() * 0.43f));
            this.changeButton.m_253211_(p_193925_);
            this.changeButton.m_93674_(Math.max(40, Math.min(120, (int)((float)DefaultKeyBindsList.this.getWidth() * 0.27f))));
            this.changeButton.m_93666_((Component)(DefaultKeyBindsList.this.parentScreen.getKeyMappingToChange() == this.key ? Component.m_237113_((String)"> ... <") : this.key.m_90863_()));
            this.changeButton.setFGColor(this.key.m_90862_() ? AlternativeKeybindScreen.UNBOUND_COLOR : (this.isConflicting ? AlternativeKeybindScreen.CONFLICT_COLOR : 0xFFFFFF));
            this.changeButton.m_88315_(guiGraphics, p_193929_, p_193930_, p_193932_);
            this.resetButton.m_252865_(this.changeButton.m_252754_() + this.changeButton.m_5711_() + 2);
            this.resetButton.m_93674_(Math.max(40, Math.min(120, (int)((float)DefaultKeyBindsList.this.getWidth() * 0.23f))));
            this.resetButton.m_253211_(p_193925_);
            boolean bl = this.resetButton.f_93623_ = !this.key.m_90864_();
            this.resetButton.setFGColor(this.key.m_90864_() ? Color.gray.getRGB() : (this.isDefaultConflicting ? AlternativeKeybindScreen.CONFLICT_COLOR : AlternativeKeybindScreen.RESET_COLOR));
            this.resetButton.m_88315_(guiGraphics, p_193929_, p_193930_, p_193932_);
            guiGraphics.m_280618_();
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.changeButton, (Object)this.resetButton);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)this.changeButton, (Object)this.resetButton);
        }

        public boolean m_6375_(double p_193919_, double p_193920_, int p_193921_) {
            if (this.changeButton.m_6375_(p_193919_, p_193920_, p_193921_)) {
                return true;
            }
            return this.resetButton.m_6375_(p_193919_, p_193920_, p_193921_);
        }

        public boolean m_6348_(double p_193941_, double p_193942_, int p_193943_) {
            return this.changeButton.m_6348_(p_193941_, p_193942_, p_193943_) || this.resetButton.m_6348_(p_193941_, p_193942_, p_193943_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class EmptyEntry
    extends Entry {
        public List<? extends NarratableEntry> m_142437_() {
            return List.of();
        }

        public void m_6311_(@NotNull GuiGraphics p_193888_, int p_193889_, int p_193890_, int p_193891_, int p_193892_, int p_193893_, int p_193894_, int p_193895_, boolean p_193896_, float p_193897_) {
        }

        public List<? extends GuiEventListener> m_6702_() {
            return List.of();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
    }
}

