/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.rawlxxxviii.visual_keybinder;

import com.gmail.rawlxxxviii.visual_keybinder.KeyBoardLayout;
import com.gmail.rawlxxxviii.visual_keybinder.KeyboardLayoutKey;
import com.gmail.rawlxxxviii.visual_keybinder.screen.AlternativeKeybindScreen;
import com.gmail.rawlxxxviii.visual_keybinder.util.KeyUtil;
import java.awt.Color;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.resources.ResourceLocation;

public class KeyButton
extends ImageButton {
    private final KeyboardLayoutKey keyboardLayoutKey;
    private final AlternativeKeybindScreen parentScreen;
    private final KeyBoardLayout keyBoardLayout;

    public KeyButton(AlternativeKeybindScreen parentScreen, KeyBoardLayout keyBoardLayout, KeyboardLayoutKey keyboardLayoutKey, int x, int y, Button.OnPress onPress) {
        super(x, y, keyboardLayoutKey.isWide() ? 60 : 16, 16, keyboardLayoutKey.isWide() ? 120 : 0, 0, 16, new ResourceLocation("visual_keybinder", "textures/gui/gui.png"), 512, 512, onPress, keyboardLayoutKey.getKey().m_84875_());
        this.keyBoardLayout = keyBoardLayout;
        this.parentScreen = parentScreen;
        this.keyboardLayoutKey = keyboardLayoutKey;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float p_93660_) {
        if (!this.f_93624_) {
            return;
        }
        float scale = this.getScale();
        this.f_93622_ = this.checkIsMouseOver(mouseX, mouseY);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(this.getDiffX(), this.getDiffY(), 1.0f);
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        this.m_87963_(guiGraphics, mouseX, mouseY, p_93660_);
        this.renderOverlay(guiGraphics, mouseX, mouseY, p_93660_);
        guiGraphics.m_280168_().m_85849_();
    }

    private float getScale() {
        float minScale = 0.3f;
        float maxScale = 1.2f;
        float scaleX = Math.max(minScale, Math.min(maxScale, (float)this.parentScreen.getLayoutWidth() / (float)this.keyBoardLayout.getWidth()));
        float scaleY = Math.max(minScale, Math.min(maxScale, (float)this.parentScreen.getLayoutHeight() / (float)this.keyBoardLayout.getHeight()));
        return Math.min(scaleX, scaleY);
    }

    private float getDiffX() {
        float scale = this.getScale();
        int centerXOrigin = this.parentScreen.getLayoutLeft() + this.parentScreen.getLayoutWidth() / 2;
        float centerXAfterScale = (float)centerXOrigin * scale;
        return (float)centerXOrigin - centerXAfterScale;
    }

    private float getDiffY() {
        float scale = this.getScale();
        int centerYOrigin = this.parentScreen.getLayoutTop() + this.parentScreen.getLayoutHeight() / 2;
        float centerYAfterScale = (float)centerYOrigin * scale;
        return (float)centerYOrigin - centerYAfterScale;
    }

    private boolean checkIsMouseOver(double mouseX, double mouseY) {
        float scale = this.getScale();
        float diffX = this.getDiffX();
        float diffY = this.getDiffY();
        return mouseX >= (double)((float)this.m_252754_() * scale + diffX) && mouseY >= (double)((float)this.m_252907_() * scale + diffY) && mouseX < (double)((float)(this.m_252754_() + this.f_93618_) * scale + diffX) && mouseY < (double)((float)(this.m_252907_() + this.f_93619_) * scale + diffY);
    }

    protected boolean m_93680_(double mouseX, double mouseY) {
        return this.f_93623_ && this.f_93624_ && this.checkIsMouseOver(mouseX, mouseY);
    }

    public KeyMapping[] getKeymappings() {
        return this.parentScreen.getKeyMappings(this.keyboardLayoutKey);
    }

    public boolean isEmpty() {
        return this.getKeymappings().length < 1;
    }

    public boolean hasConflict() {
        return KeyUtil.hasConflict(this.getKeymappings());
    }

    private void renderOverlay(GuiGraphics guiGraphics, int p_94283_, int p_94284_, float p_94285_) {
        boolean isEmpty = this.isEmpty();
        boolean hasConflict = this.hasConflict();
        int canvasX = this.keyboardLayoutKey.isWide() ? 120 : 0;
        guiGraphics.m_280163_(new ResourceLocation("visual_keybinder", "textures/gui/gui.png"), this.m_252754_(), this.m_252907_(), isEmpty ? (float)(canvasX + 3 * this.f_93618_) : (hasConflict ? (float)(canvasX + this.f_93618_) : (float)(canvasX + 2 * this.f_93618_)), (float)(this.m_198029_() ? 16 : 0), this.f_93618_, this.f_93619_, 512, 512);
        if (this.parentScreen.getDetailsList() != null && this.parentScreen.getDetailsList().getSelectedKey().getKey().m_84873_() == this.keyboardLayoutKey.getKey().m_84873_()) {
            guiGraphics.m_280163_(new ResourceLocation("visual_keybinder", "textures/gui/gui.png"), this.m_252754_(), this.m_252907_(), (float)(canvasX + 4 * this.f_93618_), 0.0f, this.f_93618_, this.f_93619_, 512, 512);
        }
        guiGraphics.m_280653_(this.parentScreen.getMinecraft().f_91062_, this.keyboardLayoutKey.getKey().m_84875_(), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, isEmpty ? Color.gray.getRGB() : (hasConflict ? AlternativeKeybindScreen.CONFLICT_COLOR : Color.WHITE.getRGB()));
    }
}

