/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.lootjs;

import com.almostreliable.lootjs.core.LootEntry;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.mixin.MixinLootEntry;
import com.yanny.ali.plugin.lootjs.node.ItemStackNode;
import com.yanny.ali.plugin.lootjs.node.ItemTagNode;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class Utils {
    @NotNull
    public static <T> List<T> getCapturedInstances(Predicate<?> predicate, Class<T> requiredType) {
        ArrayList<T> instances = new ArrayList<T>();
        try {
            Field[] fields;
            for (Field field : fields = predicate.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                Object entry = field.get(predicate);
                if (!requiredType.isInstance(entry)) continue;
                instances.add(requiredType.cast(entry));
            }
        }
        catch (IllegalAccessException e) {
            System.err.println("Error while accessing field: " + e.getMessage());
        }
        catch (SecurityException e) {
            System.err.println("Security error while accessing field: " + e.getMessage());
        }
        return instances;
    }

    public static IDataNode getEntry(IServerUtils utils, LootEntry entry, int sumWeight, List<LootItemFunction> functions, List<LootItemCondition> conditions, boolean preserveCount) {
        MixinLootEntry mixinLootEntry = (MixinLootEntry)entry;
        List<LootItemFunction> allFunctions = Stream.concat(functions.stream(), mixinLootEntry.getPostModifications().stream()).toList();
        List<LootItemCondition> allConditions = Stream.concat(conditions.stream(), mixinLootEntry.getConditions().stream()).toList();
        LootEntry.Generator generator = mixinLootEntry.getGenerator();
        int weight = mixinLootEntry.getWeight();
        if (generator instanceof LootEntry.ItemGenerator) {
            LootEntry.ItemGenerator itemGenerator = (LootEntry.ItemGenerator)generator;
            return new ItemStackNode(utils, itemGenerator.item(), (float)weight / (float)sumWeight, allFunctions, allConditions, preserveCount);
        }
        if (generator instanceof LootEntry.VanillaWrappedLootEntry) {
            LootEntry.VanillaWrappedLootEntry lootEntry = (LootEntry.VanillaWrappedLootEntry)generator;
            LootPoolEntryContainer entryContainer = lootEntry.entry();
            return utils.getEntryFactory(utils, entryContainer).create(utils, entryContainer, 1.0f, sumWeight, allFunctions, allConditions);
        }
        if (generator instanceof LootEntry.RandomIngredientGenerator) {
            LootEntry.RandomIngredientGenerator ingredientGenerator = (LootEntry.RandomIngredientGenerator)generator;
            Ingredient ingredient = ingredientGenerator.ingredient();
            if (ingredient.f_43902_.length > 0) {
                Ingredient.Value value = ingredient.f_43902_[0];
                if (value instanceof Ingredient.ItemValue) {
                    Ingredient.ItemValue itemValue = (Ingredient.ItemValue)value;
                    return new ItemStackNode(utils, itemValue.f_43951_, (float)weight / (float)sumWeight, allFunctions, allConditions, preserveCount);
                }
                if (value instanceof Ingredient.TagValue) {
                    Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
                    return new ItemTagNode(utils, (TagKey<? extends ItemLike>)tagValue.f_43959_, (float)weight / (float)sumWeight, allFunctions, allConditions, preserveCount);
                }
                throw new IllegalStateException("Invalid ingredient type: " + value.getClass().getCanonicalName());
            }
            throw new IllegalStateException("Ingredient has no entries");
        }
        throw new IllegalStateException("Invalid generator type: " + generator.getClass().getCanonicalName());
    }
}

