/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.network.packet;

import java.util.Optional;
import java.util.function.Supplier;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.core.ZetterRegistries;
import me.dantaeusb.zetter.network.ClientHandler;
import me.dantaeusb.zetter.network.packet.SCanvasSyncPacket;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import me.dantaeusb.zetter.storage.CanvasDataType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SCanvasSyncViewPacket<T extends AbstractCanvasData>
extends SCanvasSyncPacket<T> {
    private final InteractionHand hand;

    public SCanvasSyncViewPacket(String canvasCode, T canvasData, long timestamp, InteractionHand hand) {
        super(canvasCode, canvasData, timestamp);
        this.hand = hand;
    }

    public static SCanvasSyncViewPacket<?> readPacketData(FriendlyByteBuf networkBuffer) {
        try {
            String type = networkBuffer.m_130136_(128);
            String canvasCode = networkBuffer.m_130136_(128);
            long timestamp = networkBuffer.readLong();
            byte handCode = networkBuffer.readByte();
            InteractionHand hand = InteractionHand.values()[handCode];
            CanvasDataType canvasDataType = (CanvasDataType)ZetterRegistries.CANVAS_TYPE.get().getValue(new ResourceLocation(type));
            if (canvasDataType == null) {
                throw new IllegalArgumentException("Unable to find canvas type " + type);
            }
            Object canvasData = canvasDataType.readPacketData(networkBuffer);
            return new SCanvasSyncViewPacket(canvasCode, canvasData, timestamp, hand);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Zetter.LOG.warn("Exception while reading SCanvasSyncMessage: " + e);
            return null;
        }
    }

    @Override
    public void writePacketData(FriendlyByteBuf networkBuffer) {
        networkBuffer.m_130072_(this.canvasData.getType().resourceLocation.toString(), 128);
        networkBuffer.m_130072_(this.canvasCode, 128);
        networkBuffer.writeLong(this.timestamp);
        networkBuffer.writeByte(this.hand.ordinal());
        CanvasDataType canvasDataType = (CanvasDataType)ZetterRegistries.CANVAS_TYPE.get().getValue(this.canvasData.getType().resourceLocation);
        assert (canvasDataType != null);
        canvasDataType.writePacketData(this.canvasData, networkBuffer);
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public static void handle(SCanvasSyncViewPacket<?> packetIn, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            Zetter.LOG.warn("SCanvasSyncViewMessage context could not provide a ClientWorld.");
            return;
        }
        ctx.enqueueWork(() -> ClientHandler.processCanvasSyncView(packetIn, (Level)clientWorld.get()));
    }

    @Override
    public String toString() {
        return "SCanvasSyncViewMessage[canvas=" + this.canvasCode + ",timestamp=" + this.timestamp + "]";
    }
}

