/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.item;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PaletteItem
extends Item {
    public static final String NBT_TAG_NAME_PALETTE_COLORS = "paletteColors";
    public static int PALETTE_SIZE = 16;

    public PaletteItem() {
        super(new Item.Properties().m_41503_(8192));
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public static int[] getPaletteColors(ItemStack stack) {
        int[] paletteColors;
        CompoundTag compoundNBT = stack.m_41783_();
        if (compoundNBT != null && compoundNBT.m_128441_(NBT_TAG_NAME_PALETTE_COLORS)) {
            paletteColors = compoundNBT.m_128465_(NBT_TAG_NAME_PALETTE_COLORS);
            if (paletteColors.length != PALETTE_SIZE) {
                int[] fixedPaletteColors = new int[PALETTE_SIZE];
                System.arraycopy(paletteColors, 0, fixedPaletteColors, 0, paletteColors.length);
                int[] defaultPaletteColors = PaletteItem.getDefaultPaletteColors();
                if (PALETTE_SIZE - paletteColors.length >= 0) {
                    System.arraycopy(defaultPaletteColors, paletteColors.length, fixedPaletteColors, paletteColors.length, PALETTE_SIZE - paletteColors.length);
                }
                paletteColors = fixedPaletteColors;
                PaletteItem.setPaletteColors(stack, paletteColors);
            }
        } else {
            paletteColors = PaletteItem.getDefaultPaletteColors();
        }
        return paletteColors;
    }

    public static int[] getDefaultPaletteColors() {
        int[] paletteColors = new int[PALETTE_SIZE];
        paletteColors[0] = -5636096;
        paletteColors[1] = -43691;
        paletteColors[2] = -5614336;
        paletteColors[3] = -171;
        paletteColors[4] = -16733696;
        paletteColors[5] = -11141291;
        paletteColors[6] = -11141121;
        paletteColors[7] = -16733526;
        paletteColors[8] = -16777046;
        paletteColors[9] = -11184641;
        paletteColors[10] = -5635926;
        paletteColors[11] = -43521;
        paletteColors[12] = -11184811;
        paletteColors[13] = -5592406;
        paletteColors[14] = -16777216;
        paletteColors[15] = -1;
        return paletteColors;
    }

    public static void setPaletteColors(ItemStack stack, int[] paletteColors) {
        if (paletteColors.length != PALETTE_SIZE) {
            return;
        }
        CompoundTag compoundNBT = stack.m_41784_();
        compoundNBT.m_128385_(NBT_TAG_NAME_PALETTE_COLORS, paletteColors);
    }

    public static void updatePaletteColor(ItemStack stack, int paletteSlot, int color) {
        int[] colors = PaletteItem.getPaletteColors(stack);
        colors[paletteSlot] = color;
        PaletteItem.setPaletteColors(stack, colors);
    }
}

