/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.entity.item.container;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.capability.canvastracker.CanvasTracker;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.core.ItemStackHandlerListener;
import me.dantaeusb.zetter.core.ZetterItems;
import me.dantaeusb.zetter.entity.item.EaselEntity;
import me.dantaeusb.zetter.item.CanvasItem;
import me.dantaeusb.zetter.storage.CanvasData;
import me.dantaeusb.zetter.storage.util.CanvasHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class EaselContainer
extends ItemStackHandler {
    public static final int STORAGE_SIZE = 2;
    public static final int CANVAS_SLOT = 0;
    public static final int PALETTE_SLOT = 1;
    @Nullable
    private CanvasHolder<CanvasData> canvas;
    private EaselEntity easel;
    private List<ItemStackHandlerListener> listeners;

    public EaselContainer(EaselEntity easelEntity) {
        super(2);
        this.easel = easelEntity;
    }

    @Deprecated
    public EaselContainer() {
        super(2);
    }

    public void addListener(ItemStackHandlerListener listener) {
        if (this.listeners == null) {
            this.listeners = Lists.newArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeListener(ItemStackHandlerListener listener) {
        this.listeners.remove(listener);
    }

    public void damagePalette(int damage) {
        int maxDamage = this.getPaletteStack().m_41776_() - 1;
        int newDamage = this.getPaletteStack().m_41773_() + damage;
        newDamage = Math.min(newDamage, maxDamage);
        this.getPaletteStack().m_41721_(newDamage);
    }

    public CanvasHolder<CanvasData> getCanvas() {
        return this.canvas;
    }

    public void handleCanvasChange(@Nullable String canvasCode) {
        if (canvasCode == null) {
            this.canvas = null;
            return;
        }
        CanvasTracker canvasTracker = Helper.getLevelCanvasTracker(this.easel.m_9236_());
        CanvasData canvas = (CanvasData)((Object)canvasTracker.getCanvasData(canvasCode));
        if (canvas == null) {
            this.canvas = null;
            return;
        }
        this.canvas = new CanvasHolder<CanvasData>(canvasCode, canvas);
    }

    public boolean stillValid(Player player) {
        if (this.easel != null && this.easel.m_6084_()) {
            return player.m_20275_((double)this.easel.getPos().m_123341_() + 0.5, (double)this.easel.getPos().m_123342_() + 0.5, (double)this.easel.getPos().m_123343_() + 0.5) <= 64.0;
        }
        return false;
    }

    public boolean isItemValid(int index, ItemStack stack) {
        if (index == 0 && stack.m_41720_() == ZetterItems.CANVAS.get()) {
            int[] canvasSize = CanvasItem.getBlockSize(stack);
            assert (canvasSize != null);
            return canvasSize[0] <= 2 && canvasSize[1] <= 2;
        }
        return index == 1 && stack.m_41720_() == ZetterItems.PALETTE.get();
    }

    public ItemStack getCanvasStack() {
        return this.getStackInSlot(0);
    }

    public ItemStack getPaletteStack() {
        return this.getStackInSlot(1);
    }

    public ItemStack extractCanvasStack() {
        return this.extractItem(0, this.getSlotLimit(0), false);
    }

    public ItemStack extractPaletteStack() {
        return this.extractItem(1, this.getSlotLimit(1), false);
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public void setCanvasStack(ItemStack canvasStack) {
        this.setStackInSlot(0, canvasStack);
    }

    public void setPaletteStack(ItemStack canvasStack) {
        this.setStackInSlot(1, canvasStack);
    }

    public void changed() {
        this.onContentsChanged(0);
    }

    protected void onLoad() {
        this.handleCanvasChange(CanvasItem.getCanvasCode(this.getCanvasStack()));
    }

    protected void onContentsChanged(int slot) {
        if (slot == 0) {
            ItemStack canvasStack = this.getCanvasStack();
            if (canvasStack.m_41619_()) {
                this.handleCanvasChange(null);
            } else {
                String canvasCode = CanvasItem.getCanvasCode(canvasStack);
                if (canvasCode == null) {
                    int[] size = CanvasItem.getBlockSize(canvasStack);
                    assert (size != null && size.length == 2);
                    canvasCode = CanvasData.getDefaultCanvasCode(size[0], size[1]);
                }
                this.handleCanvasChange(canvasCode);
            }
        }
        if (this.listeners != null) {
            for (ItemStackHandlerListener listener : this.listeners) {
                listener.containerChanged(this, slot);
            }
        }
    }
}

