/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.gui.easel;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.client.gui.EaselScreen;
import me.dantaeusb.zetter.client.gui.easel.AbstractEaselWidget;
import me.dantaeusb.zetter.client.gui.easel.SliderWidget;
import me.dantaeusb.zetter.core.tools.Color;
import me.dantaeusb.zetter.menu.EaselMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class HsbWidget
extends AbstractEaselWidget
implements Renderable {
    static final int SLIDER_DISTANCE = 5;
    static final int WIDTH = 162;
    static final int HEIGHT = 37;
    private final SliderWidget hueSlider;
    private final SliderWidget saturationSlider;
    private final SliderWidget brightnessSlider;
    private final List<SliderWidget> sliders = new ArrayList<SliderWidget>();

    public HsbWidget(EaselScreen parentScreen, int x, int y) {
        super(parentScreen, x, y, 162, 37, (Component)Component.m_237115_((String)"container.zetter.painting.sliders"));
        int sliderOffset = 12;
        this.hueSlider = new SliderWidget(parentScreen, x + 12, y, (Component)Component.m_237115_((String)"container.zetter.painting.sliders.hue"), this::updateHue, null, this::renderHueForeground);
        this.saturationSlider = new SliderWidget(parentScreen, x + 12, y + 9 + 5, (Component)Component.m_237115_((String)"container.zetter.painting.sliders.saturation"), this::updateSaturation, null, this::renderSaturationForeground);
        this.brightnessSlider = new SliderWidget(parentScreen, x + 12, y + 28, (Component)Component.m_237115_((String)"container.zetter.painting.sliders.brightness"), this::updateBrightness, null, this::renderBrightnessForeground);
        this.sliders.add(this.hueSlider);
        this.sliders.add(this.saturationSlider);
        this.sliders.add(this.brightnessSlider);
    }

    public void updateColor(int color) {
        Color newColor = new Color(color);
        float[] hsb = newColor.toHSB();
        this.hueSlider.setSliderState(hsb[0]);
        this.saturationSlider.setSliderState(hsb[1]);
        this.brightnessSlider.setSliderState(hsb[2]);
    }

    @Override
    @Nullable
    public Component getTooltip(int mouseX, int mouseY) {
        return null;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean result = this.hueSlider.m_6375_(mouseX, mouseY, button) || this.saturationSlider.m_6375_(mouseX, mouseY, button) || this.brightnessSlider.m_6375_(mouseX, mouseY, button);
        this.m_93692_(result);
        return result;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.hueSlider.m_7979_(mouseX, mouseY, button, dragX, dragY);
        this.saturationSlider.m_7979_(mouseX, mouseY, button, dragX, dragY);
        this.brightnessSlider.m_7979_(mouseX, mouseY, button, dragX, dragY);
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.hueSlider.m_6348_(mouseX, mouseY, button);
        this.saturationSlider.m_6348_(mouseX, mouseY, button);
        this.brightnessSlider.m_6348_(mouseX, mouseY, button);
        return super.m_6348_(mouseX, mouseY, button);
    }

    public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        for (SliderWidget slider : this.sliders) {
            slider.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void renderLabels(GuiGraphics guiGraphics, int posX, int posY) {
        int i = 0;
        for (SliderWidget slider : this.sliders) {
            guiGraphics.m_280056_(this.parentScreen.getFont(), slider.m_6035_().getString().substring(0, 1).concat("."), this.m_252754_() - this.parentScreen.getGuiLeft(), this.m_252907_() + 14 * i++ - this.parentScreen.getGuiTop() + 1, Color.DARK_GRAY.getRGB(), false);
        }
    }

    public void updateSlidersWithCurrentColor() {
        Color currentColor = new Color(((EaselMenu)this.parentScreen.m_6262_()).getCurrentColor());
        float[] currentColorHSB = currentColor.toHSB();
    }

    public int renderHueForeground(float percent) {
        return Color.HSBtoRGB(percent, 1.0f, 1.0f);
    }

    public void updateHue(float percent) {
        this.pushColorUpdate();
    }

    public int renderSaturationForeground(float percent) {
        return Color.HSBtoRGB(this.hueSlider.getSliderState(), percent, 1.0f);
    }

    public void updateSaturation(float percent) {
        this.pushColorUpdate();
    }

    public int renderBrightnessForeground(float percent) {
        return Color.HSBtoRGB(this.hueSlider.getSliderState(), this.saturationSlider.getSliderState(), percent);
    }

    public void updateBrightness(float percent) {
        this.pushColorUpdate();
    }

    public void pushColorUpdate() {
        float hue = this.hueSlider.getSliderState();
        float saturation = this.saturationSlider.getSliderState();
        float brightness = this.brightnessSlider.getSliderState();
        ((EaselMenu)this.parentScreen.m_6262_()).setPaletteColor(Color.HSBtoRGB(hue, saturation, brightness));
    }
}

