/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.gui.easel;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.client.gui.EaselScreen;
import me.dantaeusb.zetter.client.gui.easel.AbstractEaselWidget;
import me.dantaeusb.zetter.client.renderer.CanvasRenderer;
import me.dantaeusb.zetter.menu.EaselMenu;
import me.dantaeusb.zetter.painting.Tools;
import me.dantaeusb.zetter.painting.parameters.AbstractToolParameters;
import me.dantaeusb.zetter.painting.parameters.SizeParameterHolder;
import me.dantaeusb.zetter.painting.tools.AbstractTool;
import me.dantaeusb.zetter.storage.CanvasData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.lwjgl.glfw.GLFW;

public class CanvasWidget
extends AbstractEaselWidget
implements Renderable {
    public static final int SIZE = 128;
    public static final ResourceLocation PAINTING_CHECKER_RESOURCE = new ResourceLocation("zetter", "textures/gui/easel/checker.png");
    private boolean canvasDragging = false;
    private double scrollDistance = 0.0;
    private long scrollTimestamp = 0L;

    public CanvasWidget(EaselScreen parentScreen, int x, int y) {
        super(parentScreen, x, y, 128, 128, (Component)Component.m_237115_((String)"container.zetter.painting.canvas"));
    }

    private int getCanvasScale() {
        return ((EaselMenu)this.parentScreen.m_6262_()).getCanvasScaleFactor() * 2;
    }

    @Override
    @Nullable
    public Component getTooltip(int mouseX, int mouseY) {
        return null;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_5953_(mouseX, mouseY)) {
            this.canvasDragging = true;
            this.handleCanvasInteraction(mouseX, mouseY);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.m_5953_(mouseX, mouseY)) {
            if (this.canvasDragging) {
                this.handleCanvasInteraction(mouseX, mouseY);
                return true;
            }
            return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.canvasDragging = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.m_5953_(mouseX, mouseY)) {
            this.scrollDistance += delta;
            this.scrollTimestamp = System.currentTimeMillis();
            if (this.scrollDistance <= -1.5) {
                ((EaselMenu)this.parentScreen.m_6262_()).decreaseCanvasScale();
                this.scrollDistance = 0.0;
            } else if (this.scrollDistance >= 1.5) {
                ((EaselMenu)this.parentScreen.m_6262_()).increaseCanvasScale();
                this.scrollDistance = 0.0;
            }
            return true;
        }
        return false;
    }

    public void tick() {
        if (this.scrollDistance != 0.0 && System.currentTimeMillis() - this.scrollTimestamp > 1500L) {
            this.scrollDistance = 0.0;
        }
    }

    protected boolean handleCanvasInteraction(double mouseX, double mouseY) {
        float canvasX = (float)((mouseX - (double)this.m_252754_() - (double)((EaselMenu)this.parentScreen.m_6262_()).getCanvasOffsetX()) / (double)this.getCanvasScale());
        float canvasY = (float)((mouseY - (double)this.m_252907_() - (double)((EaselMenu)this.parentScreen.m_6262_()).getCanvasOffsetY()) / (double)this.getCanvasScale());
        ((EaselMenu)this.parentScreen.m_6262_()).useTool(canvasX, canvasY);
        return true;
    }

    @Override
    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
    }

    public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (!((EaselMenu)this.parentScreen.m_6262_()).isCanvasAvailable()) {
            GLFW.glfwSetInputMode((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)208897, (int)212993);
            return;
        }
        int scale = (int)this.parentScreen.getMinecraft().m_91268_().m_85449_();
        int windowHeight = this.parentScreen.getMinecraft().m_91268_().m_85442_();
        RenderSystem.enableScissor((int)(this.m_252754_() * scale), (int)(windowHeight - (this.m_252907_() + this.f_93619_) * scale), (int)(this.f_93618_ * scale), (int)(this.f_93619_ * scale));
        this.renderCheckerboard(guiGraphics);
        String canvasCode = ((EaselMenu)this.parentScreen.m_6262_()).getCanvasCode();
        CanvasData canvasData = ((EaselMenu)this.parentScreen.m_6262_()).getCanvasData();
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)(this.m_252754_() + ((EaselMenu)this.parentScreen.m_6262_()).getCanvasOffsetX()), (float)(this.m_252907_() + ((EaselMenu)this.parentScreen.m_6262_()).getCanvasOffsetY()), 0.0f);
        poseStack.m_85841_((float)this.getCanvasScale(), (float)this.getCanvasScale(), 1.0f);
        MultiBufferSource.BufferSource renderTypeBufferImpl = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        CanvasRenderer.getInstance().renderCanvas(poseStack, (MultiBufferSource)renderTypeBufferImpl, canvasCode, canvasData, 0xF000F0);
        renderTypeBufferImpl.m_109911_();
        poseStack.m_85849_();
        if (mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.f_93618_ && mouseY < this.m_252907_() + this.f_93619_) {
            if (((EaselMenu)this.parentScreen.m_6262_()).getCurrentTool().getTool() == Tools.HAND.getTool()) {
                GLFW.glfwSetInputMode((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)208897, (int)212993);
            } else {
                double canvasX = (double)(mouseX - this.m_252754_() - ((EaselMenu)this.parentScreen.m_6262_()).getCanvasOffsetX()) / (double)this.getCanvasScale();
                double canvasY = (double)(mouseY - this.m_252907_() - ((EaselMenu)this.parentScreen.m_6262_()).getCanvasOffsetY()) / (double)this.getCanvasScale();
                this.renderCursor(guiGraphics, canvasX, canvasY);
            }
        } else {
            GLFW.glfwSetInputMode((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)208897, (int)212993);
        }
        RenderSystem.disableScissor();
    }

    private void renderCheckerboard(GuiGraphics guiGraphics) {
        int offsetX = Math.abs(this.getCanvasScale() * 2 - ((EaselMenu)this.parentScreen.m_6262_()).getCanvasOffsetX() % (this.getCanvasScale() * 2));
        int offsetY = Math.abs(this.getCanvasScale() * 2 - ((EaselMenu)this.parentScreen.m_6262_()).getCanvasOffsetY() % (this.getCanvasScale() * 2));
        int width = this.f_93618_ + this.getCanvasScale() * 4;
        int height = this.f_93619_ + this.getCanvasScale() * 4;
        float x1 = this.m_252754_() - offsetX;
        float x2 = x1 + (float)width;
        float y1 = this.m_252907_() - offsetY;
        float y2 = y1 + (float)height;
        float uvScale = (float)this.getCanvasScale() * 2.0f;
        float u1 = 0.0f;
        float u2 = (float)width / uvScale;
        float v1 = 0.0f;
        float v2 = (float)height / uvScale;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)PAINTING_CHECKER_RESOURCE);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(matrix, x1, y2, 0.0f).m_7421_(u1, v2).m_5752_();
        bufferBuilder.m_252986_(matrix, x2, y2, 0.0f).m_7421_(u2, v2).m_5752_();
        bufferBuilder.m_252986_(matrix, x2, y1, 0.0f).m_7421_(u2, v1).m_5752_();
        bufferBuilder.m_252986_(matrix, x1, y1, 0.0f).m_7421_(u1, v1).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        poseStack.m_85849_();
    }

    private void renderCursor(GuiGraphics guiGraphics, double canvasX, double canvasY) {
        AbstractToolParameters toolParameters = ((EaselMenu)this.parentScreen.m_6262_()).getCurrentToolParameters();
        AbstractTool.ToolShape shape = ((EaselMenu)this.parentScreen.m_6262_()).getCurrentTool().getTool().getShape(toolParameters);
        RenderSystem.blendEquation((int)32778);
        if (shape == null) {
            GLFW.glfwSetInputMode((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)208897, (int)212994);
            int radius = this.getCanvasScale() * 2;
            if (toolParameters instanceof SizeParameterHolder) {
                radius = Math.round((float)this.getCanvasScale() * ((SizeParameterHolder)((Object)toolParameters)).getSize());
            }
            if (radius < 4) {
                radius = 4;
            }
            int globalX = this.m_252754_() + ((EaselMenu)this.parentScreen.m_6262_()).getCanvasOffsetX() + (int)Math.floor(canvasX * (double)this.getCanvasScale()) - 1;
            int globalY = this.m_252907_() + ((EaselMenu)this.parentScreen.m_6262_()).getCanvasOffsetY() + (int)Math.floor(canvasY * (double)this.getCanvasScale()) - 1;
            guiGraphics.m_280656_(globalX - radius, globalX - 2, globalY, -2139062144);
            guiGraphics.m_280656_(globalX + radius, globalX + 2, globalY, -2139062144);
            guiGraphics.m_280315_(globalX, globalY - radius, globalY - 2, -2139062144);
            guiGraphics.m_280315_(globalX, globalY + radius, globalY + 2, -2139062144);
        } else {
            GLFW.glfwSetInputMode((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)208897, (int)212993);
            int offset = -(shape.getSize() / 2);
            int globalX = this.m_252754_() + ((EaselMenu)this.parentScreen.m_6262_()).getCanvasOffsetX() + (int)Math.floor(canvasX) * this.getCanvasScale();
            int globalY = this.m_252907_() + ((EaselMenu)this.parentScreen.m_6262_()).getCanvasOffsetY() + (int)Math.floor(canvasY) * this.getCanvasScale();
            for (AbstractTool.ShapeLine line : shape.getLines()) {
                int posX = (line.posX() + offset) * this.getCanvasScale();
                int posY = (line.posY() + offset) * this.getCanvasScale();
                int length = line.length() * this.getCanvasScale();
                if (line.direction() == AbstractTool.ShapeLine.LineDirection.HORIZONTAL) {
                    if (posX <= 0 && --posX + length > 0) {
                        ++length;
                    }
                    if (posY <= 0) {
                        --posY;
                    }
                    int minX = globalX + posX;
                    guiGraphics.m_280656_(minX, minX + length, globalY + posY, -2139062144);
                    continue;
                }
                if (posX <= 0) {
                    --posX;
                }
                if (posY <= 0 && --posY + length > 0) {
                    ++length;
                }
                int minY = globalY + posY;
                guiGraphics.m_280315_(globalX + posX, minY, minY + length, -2139062144);
            }
        }
        RenderSystem.blendEquation((int)32774);
    }
}

