/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import me.dantaeusb.zetter.client.renderer.CanvasRenderer;
import me.dantaeusb.zetter.core.ZetterNetwork;
import me.dantaeusb.zetter.network.packet.CSignPaintingPacket;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import me.dantaeusb.zetter.storage.CanvasData;
import me.dantaeusb.zetter.storage.PaintingData;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;

public class PaintingScreen
extends Screen {
    private static final Component DEFAULT_TITLE = Component.m_237115_((String)"item.zetter.painting.unnamed");
    private final Player owner;
    private final InteractionHand hand;
    private final String canvasCode;
    private final AbstractCanvasData canvasData;
    private final String authorName;
    private String title = "";
    private int tick = 0;
    private boolean editable = true;
    private int paintingOffsetX;
    private int paintingOffsetY;
    private int paintingWidth;
    private int paintingHeight;
    private float paintingScale;
    private int screenOffsetX;
    private int screenOffsetY;
    private int screenWidth;
    private int screenHeight;
    private Button signButton;
    private final TextFieldHelper titleEdit = new TextFieldHelper(() -> this.title, input -> {
        this.title = input;
    }, this::getClipboard, this::setClipboard, input -> input.length() <= 32);
    private static final int SCREEN_MARGIN = 10;
    private static final int SCREEN_PADDING = 5;
    private static final int SCREEN_BOTTOM_TEXT = 30;
    private static final int TEXT_COLOR_ACTIVE = -16777216;
    private static final int TEXT_COLOR = -13950965;
    private static final int BUTTON_WIDTH = 98;
    private static final int BUTTON_HEIGHT = 20;

    public static PaintingScreen createScreenForCanvas(Player player, String canvasCode, CanvasData canvasData, InteractionHand hand) {
        return new PaintingScreen(player, hand, canvasCode, canvasData, player.m_7755_().getString(), "", true);
    }

    public static PaintingScreen createScreenForPainting(Player player, String canvasCode, PaintingData paintingData, InteractionHand hand) {
        return new PaintingScreen(player, hand, canvasCode, paintingData, paintingData.getAuthorName(), paintingData.getPaintingName(), false);
    }

    private PaintingScreen(Player player, InteractionHand hand, String canvasCode, AbstractCanvasData canvasData, String authorName, String paintingTitle, boolean editable) {
        super((Component)Component.m_237115_((String)"container.zetter.painting"));
        this.owner = player;
        this.hand = hand;
        this.canvasCode = canvasCode;
        this.canvasData = canvasData;
        this.authorName = authorName;
        this.title = paintingTitle;
        this.editable = editable;
    }

    public void m_7856_() {
        this.calculatePaintingOffset();
        this.signButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"book.signButton"), p_98177_ -> this.signPainting()).m_252987_(this.screenOffsetX + this.screenWidth - 98 - 5, this.paintingOffsetY + this.paintingHeight + 5, 98, 20).m_253136_());
        this.signButton.f_93624_ = this.editable;
    }

    private void signPainting() {
        int slot = this.hand == InteractionHand.MAIN_HAND ? this.owner.m_150109_().f_35977_ : 40;
        String title = this.title.isEmpty() ? DEFAULT_TITLE.getString() : this.title;
        CSignPaintingPacket signPaintingPacket = new CSignPaintingPacket(slot, title);
        ZetterNetwork.simpleChannel.sendToServer((Object)signPaintingPacket);
        this.f_96541_.f_91074_.m_6915_();
    }

    private void calculatePaintingOffset() {
        float windowAspectRatio;
        float paintingAspectRatio = (float)this.canvasData.getWidth() / (float)this.canvasData.getHeight();
        if (paintingAspectRatio > (windowAspectRatio = (float)this.f_96543_ / (float)this.f_96544_)) {
            this.paintingWidth = this.f_96543_ - 20 - 10;
            this.paintingHeight = (int)((float)this.paintingWidth / paintingAspectRatio);
        } else {
            this.paintingHeight = this.f_96544_ - 20 - 10 - 30;
            this.paintingWidth = (int)((float)this.paintingHeight * paintingAspectRatio);
        }
        this.paintingOffsetX = (this.f_96543_ - this.paintingWidth) / 2;
        this.paintingOffsetY = (this.f_96544_ - (this.paintingHeight + 30)) / 2;
        this.paintingScale = (float)this.paintingWidth / (float)this.canvasData.getWidth();
        int minWidth = 192;
        if (this.editable) {
            minWidth += 103;
        }
        this.screenWidth = Math.max(minWidth, this.paintingWidth) + 10;
        this.screenHeight = this.paintingHeight + 30 + 10;
        this.screenOffsetX = (this.f_96543_ - this.screenWidth) / 2;
        this.screenOffsetY = (this.f_96544_ - (this.paintingHeight + 30 + 10)) / 2;
    }

    public void m_86600_() {
        ++this.tick;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.f_96541_.f_91074_.m_6915_();
            return true;
        }
        if (this.editable) {
            return this.titleEdit.m_95145_(keyCode) || super.m_7933_(keyCode, scanCode, modifiers);
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.editable) {
            return this.titleEdit.m_95143_(codePoint) || super.m_5534_(codePoint, modifiers);
        }
        return super.m_5534_(codePoint, modifiers);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        this.m_7522_(null);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280509_(this.screenOffsetX, this.screenOffsetY, this.screenOffsetX + this.screenWidth, this.screenOffsetY + this.screenHeight, -3488844);
        guiGraphics.m_280509_(this.screenOffsetX + 1, this.screenOffsetY + 1, this.screenOffsetX + this.screenWidth - 1, this.screenOffsetY + this.screenHeight - 1, -2041138);
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)this.paintingOffsetX, (float)this.paintingOffsetY, 1.0f);
        poseStack.m_85841_(this.paintingScale, this.paintingScale, 1.0f);
        MultiBufferSource.BufferSource renderTypeBufferImpl = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        CanvasRenderer.getInstance().renderCanvas(poseStack, (MultiBufferSource)renderTypeBufferImpl, this.canvasCode, this.canvasData, 0xF000F0);
        renderTypeBufferImpl.m_109911_();
        poseStack.m_85849_();
        String title = this.title.isEmpty() ? DEFAULT_TITLE.getString() : this.title;
        FormattedCharSequence formattedTitle = FormattedCharSequence.m_13714_((String)title, (Style)(this.title.isEmpty() ? Style.f_131099_.m_131140_(ChatFormatting.GRAY) : Style.f_131099_.m_131140_(ChatFormatting.BLACK)));
        if (this.editable) {
            this.renderCursor(guiGraphics, this.titleEdit.m_95194_(), this.titleEdit.m_95194_() == this.title.length());
        }
        guiGraphics.m_280649_(this.f_96547_, formattedTitle, this.screenOffsetX + 5, this.paintingOffsetY + this.paintingHeight + 7, -13950965, false);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"book.byAuthor", (Object[])new Object[]{this.authorName}), this.screenOffsetX + 5, this.paintingOffsetY + this.paintingHeight + 17, -13950965, false);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderCursor(GuiGraphics guiGraphics, int cursorPos, boolean underscore) {
        if (this.tick / 6 % 2 == 0) {
            int cursorX = this.screenOffsetX + 5 + this.f_96547_.m_92895_(this.title.substring(0, cursorPos));
            int cursorY = this.paintingOffsetY + this.paintingHeight + 7;
            if (!underscore) {
                guiGraphics.m_280509_(cursorX, cursorY - 1, cursorX + 1, cursorY + 9, -16777216);
            } else {
                guiGraphics.m_280056_(this.f_96547_, "_", cursorX, cursorY, -16777216, false);
            }
        }
    }

    private void setClipboard(String p_98148_) {
        if (this.f_96541_ != null) {
            TextFieldHelper.m_95155_((Minecraft)this.f_96541_, (String)p_98148_);
        }
    }

    private String getClipboard() {
        return this.f_96541_ != null ? TextFieldHelper.m_95169_((Minecraft)this.f_96541_) : "";
    }
}

