/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.gui;

import com.google.common.collect.Lists;
import java.util.List;
import me.dantaeusb.zetter.client.gui.artisttable.AbstractArtistTableWidget;
import me.dantaeusb.zetter.client.gui.artisttable.ChangeActionWidget;
import me.dantaeusb.zetter.client.gui.artisttable.HelpWidget;
import me.dantaeusb.zetter.client.gui.artisttable.PreviewWidget;
import me.dantaeusb.zetter.core.tools.Color;
import me.dantaeusb.zetter.menu.ArtistTableMenu;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ArtistTableScreen
extends AbstractContainerScreen<ArtistTableMenu>
implements ContainerListener {
    public static final Component TITLE = Component.m_237115_((String)"container.zetter.artist_table");
    private static final Component SPLIT_MODE_TITLE = Component.m_237115_((String)"container.zetter.artist_table.mode.split");
    private static final Component COMBINE_MODE_TITLE = Component.m_237115_((String)"container.zetter.artist_table.mode.combine");
    protected final Component titleLabel = TITLE;
    public static final ResourceLocation ARTIST_TABLE_GUI_TEXTURE_RESOURCE = new ResourceLocation("zetter", "textures/gui/artist_table.png");
    private final List<AbstractArtistTableWidget> artistTableWidgets = Lists.newArrayList();
    private PreviewWidget previewWidget;
    private ChangeActionWidget changeActionWidget;
    private HelpWidget helpWidget;
    private int tick = 0;
    final int WIDTH = 230;
    final int HEIGHT = 192;
    final int COMBINED_CANVAS_POSITION_COMBINE_X = 147;
    final int COMBINED_CANVAS_POSITION_COMBINE_Y = 23;
    final int COMBINED_CANVAS_POSITION_SPLIT_X = 17;
    final int COMBINED_CANVAS_POSITION_SPLIT_Y = 23;

    public ArtistTableScreen(ArtistTableMenu artistTableMenu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)artistTableMenu, playerInventory, title);
        this.f_97726_ = 230;
        this.f_97727_ = 192;
    }

    protected void m_7856_() {
        super.m_7856_();
        int CHANGE_ACTION_BUTTON_POSITION_X = 105;
        int CHANGE_ACTION_BUTTON_POSITION_Y = 28;
        int HELP_POSITION_X = 219;
        boolean HELP_POSITION_Y = false;
        this.artistTableWidgets.clear();
        this.previewWidget = new PreviewWidget(this, this.getGuiLeft() + 147, this.getGuiTop() + 23);
        this.changeActionWidget = new ChangeActionWidget(this, this.getGuiLeft() + 105, this.getGuiTop() + 28);
        this.helpWidget = new HelpWidget(this, this.getGuiLeft() + 219, this.getGuiTop() + 0);
        this.addArtistTableWidget(this.previewWidget);
        this.addArtistTableWidget(this.changeActionWidget);
        this.addArtistTableWidget(this.helpWidget);
        ((ArtistTableMenu)this.m_6262_()).m_38893_(this);
    }

    public void updateCombinedCanvasPosition() {
        if (((ArtistTableMenu)this.m_6262_()).getMode() == ArtistTableMenu.Mode.COMBINE) {
            this.previewWidget.m_264152_(this.getGuiLeft() + 147, this.getGuiTop() + 23);
        } else {
            this.previewWidget.m_264152_(this.getGuiLeft() + 17, this.getGuiTop() + 23);
        }
    }

    public void addArtistTableWidget(AbstractArtistTableWidget widget) {
        this.artistTableWidgets.add(widget);
        this.m_7787_(widget);
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    public void m_181908_() {
        super.m_181908_();
        ++this.tick;
    }

    protected void m_7286_(@NotNull GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.m_280163_(ARTIST_TABLE_GUI_TEXTURE_RESOURCE, this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 512, 256);
        int GRID_XPOS_COMBINE = 9;
        int GRID_XPOS_SPLIT = 139;
        int GRID_YPOS_COMBINE = 15;
        int GRID_YPOS_SPLIT = 15;
        int GRID_UPOS = 250;
        int GRID_VPOS = 26;
        int GRID_SIZE = 80;
        if (((ArtistTableMenu)this.f_97732_).getMode() == ArtistTableMenu.Mode.COMBINE) {
            guiGraphics.m_280163_(ARTIST_TABLE_GUI_TEXTURE_RESOURCE, this.f_97735_ + 9, this.f_97736_ + 15, 250.0f, 26.0f, 80, 80, 512, 256);
            guiGraphics.m_280163_(ARTIST_TABLE_GUI_TEXTURE_RESOURCE, this.f_97735_ + 139, this.f_97736_ + 15, 250.0f, 106.0f, 80, 80, 512, 256);
        } else {
            guiGraphics.m_280163_(ARTIST_TABLE_GUI_TEXTURE_RESOURCE, this.f_97735_ + 139, this.f_97736_ + 15, 250.0f, 26.0f, 80, 80, 512, 256);
            guiGraphics.m_280163_(ARTIST_TABLE_GUI_TEXTURE_RESOURCE, this.f_97735_ + 9, this.f_97736_ + 15, 250.0f, 106.0f, 80, 80, 512, 256);
        }
        int COMBINED_SLOT_YPOS = 62;
        int COMBINED_SLOT_SIZE = 26;
        int COMBINED_SLOT_UPOS = 250;
        boolean COMBINED_SLOT_VPOS = false;
        int ARROWS_YPOS = 34;
        int ARROWS_WIDTH = 45;
        int ARROWS_HEIGHT = 26;
        boolean ARROWS_UPOS = false;
        int ARROWS_VPOS = 192;
        if (((ArtistTableMenu)this.f_97732_).getMode() == ArtistTableMenu.Mode.COMBINE) {
            guiGraphics.m_280163_(ARTIST_TABLE_GUI_TEXTURE_RESOURCE, this.f_97735_ + this.f_97726_ / 2 - 22, this.f_97736_ + 34, 0.0f, 192.0f, 45, 26, 512, 256);
            guiGraphics.m_280163_(ARTIST_TABLE_GUI_TEXTURE_RESOURCE, this.f_97735_ + this.f_97726_ / 2 - 13, this.f_97736_ + 62, 250.0f, 0.0f, 26, 26, 512, 256);
        } else {
            guiGraphics.m_280163_(ARTIST_TABLE_GUI_TEXTURE_RESOURCE, this.f_97735_ + this.f_97726_ / 2 - 22, this.f_97736_ + 34, 45.0f, 192.0f, 45, 26, 512, 256);
            guiGraphics.m_280163_(ARTIST_TABLE_GUI_TEXTURE_RESOURCE, this.f_97735_ + this.f_97726_ / 2 - 13, this.f_97736_ + 62, 276.0f, 0.0f, 26, 26, 512, 256);
        }
        int LOADING_UPOS = 230;
        int LOADING_VPOS = 108;
        int LOADING_WIDTH = 16;
        int LOADING_HEIGHT = 10;
        int INVALID_UPOS = 230;
        int INVALID_VPOS = 138;
        int INVALID_WIDTH = 10;
        int INVALID_HEIGHT = 10;
        this.changeActionWidget.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.helpWidget.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        switch (((ArtistTableMenu)this.m_6262_()).getActionState()) {
            case EMPTY: {
                break;
            }
            case INVALID: {
                int xPosInvalid = 35;
                int yPosInvalid = 35;
                if (((ArtistTableMenu)this.f_97732_).getMode() == ArtistTableMenu.Mode.COMBINE) {
                    xPosInvalid += 139;
                    yPosInvalid += 15;
                } else {
                    xPosInvalid += 9;
                    yPosInvalid += 15;
                }
                guiGraphics.m_280163_(ARTIST_TABLE_GUI_TEXTURE_RESOURCE, this.f_97735_ + xPosInvalid, this.f_97736_ + yPosInvalid, 230.0f, 138.0f, 10, 10, 512, 256);
                break;
            }
            case NOT_LOADED: {
                int xPosLoading = 32;
                int yPosLoading = 35;
                if (((ArtistTableMenu)this.f_97732_).getMode() == ArtistTableMenu.Mode.COMBINE) {
                    xPosLoading += 139;
                    yPosLoading += 15;
                } else {
                    xPosLoading += 9;
                    yPosLoading += 15;
                }
                int animation = this.tick % 40;
                int frame = animation / 10;
                frame = frame > 2 ? 1 : frame;
                guiGraphics.m_280163_(ARTIST_TABLE_GUI_TEXTURE_RESOURCE, this.f_97735_ + xPosLoading, this.f_97736_ + yPosLoading, 230.0f, (float)(108 + 10 * frame), 16, 10, 512, 256);
                break;
            }
            case READY: {
                this.previewWidget.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            }
        }
    }

    protected void m_280072_(@NotNull GuiGraphics guiGraphics, int x, int y) {
        super.m_280072_(guiGraphics, x, y);
        for (AbstractArtistTableWidget widget : this.artistTableWidgets) {
            if (!widget.m_5953_(x, y)) continue;
            widget.renderTooltip(guiGraphics, x, y);
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int LABEL_XPOS = 5;
        int LABEL_YPOS = 5;
        Component artistTableModelLabel = ((ArtistTableMenu)this.m_6262_()).getMode() == ArtistTableMenu.Mode.COMBINE ? COMBINE_MODE_TITLE : SPLIT_MODE_TITLE;
        MutableComponent artistTableLabel = Component.m_237110_((String)"container.zetter.artist_table.mode", (Object[])new Object[]{this.titleLabel, artistTableModelLabel});
        guiGraphics.m_280614_(this.f_96547_, (Component)artistTableLabel, 5, 5, Color.darkGray.getRGB(), false);
        int FONT_Y_SPACING = 10;
        int PLAYER_INV_LABEL_XPOS = 36;
        int PLAYER_INV_LABEL_YPOS = 100;
        guiGraphics.m_280614_(this.f_96547_, this.f_169604_, 36, 100, Color.darkGray.getRGB(), false);
    }

    public void m_7934_(AbstractContainerMenu menu, int slotId, ItemStack stack) {
    }

    public Font getFont() {
        return this.f_96547_;
    }

    public void m_142153_(AbstractContainerMenu menu, int dataSlotIndex, int value) {
        if (dataSlotIndex == 0) {
            this.updateCombinedCanvasPosition();
        }
    }

    public void m_7861_() {
        super.m_7861_();
        ((ArtistTableMenu)this.m_6262_()).m_38943_(this);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.f_96541_.f_91074_.m_6915_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public static boolean isInRect(int x, int y, int xSize, int ySize, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + xSize && mouseY >= y && mouseY <= y + ySize;
    }
}

