/*
 * Decompiled with CFR 0.152.
 */
package codechicken.mixin.util;

import codechicken.mixin.util.ClassInfo;
import codechicken.mixin.util.MixinInfo;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;

public class Utils {
    public static String asmName(Class<?> clazz) {
        return Utils.asmName(clazz.getName());
    }

    public static String asmName(String name) {
        return name.replace(".", "/");
    }

    public static <E> Iterable<E> toIterable(final Enumeration<E> enumeration) {
        return () -> new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public E next() {
                return enumeration.nextElement();
            }
        };
    }

    @Nullable
    public static <T> Constructor<T> findConstructor(Class<T> clazz, Class<?> ... parameters) {
        try {
            return clazz.getConstructor(parameters);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static <T> T newInstance(Constructor<T> ctor, Object ... args) {
        try {
            return ctor.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate class.", e);
        }
    }

    public static void deleteFolder(Path folder) throws IOException {
        try (Stream<Path> stream = Files.walk(folder, new FileVisitOption[0]);){
            stream.sorted(Comparator.reverseOrder()).forEach(p -> {
                try {
                    Files.delete(p);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
    }

    public static String staticDesc(String owner, String desc) {
        Type descT = Type.getMethodType((String)desc);
        ArrayList<Type> args = new ArrayList<Type>(Arrays.asList(descT.getArgumentTypes()));
        args.add(0, Type.getType((String)("L" + owner + ";")));
        return Type.getMethodDescriptor((Type)descT.getReturnType(), (Type[])args.toArray(new Type[0]));
    }

    public static String timeString(long start, long end) {
        long delta = end - start;
        long millis = TimeUnit.NANOSECONDS.toMillis(delta);
        String s = millis >= 5L ? millis + "ms(" + delta + "ns)" : delta + "ns";
        return s;
    }

    public static FastStream<ClassInfo> allParents(ClassInfo info) {
        return FastStream.concat((Iterable[])new Iterable[]{FastStream.of((Object)info), FastStream.concat((Iterable[])new Iterable[]{FastStream.ofNullable((Object)info.getSuperClass()), info.getInterfaces()}).flatMap(Utils::allParents)});
    }

    public static void finishBridgeCall(MethodVisitor mv, String mvDesc, int opcode, String owner, String name, String desc, boolean isInterface) {
        Type[] args = Type.getArgumentTypes((String)mvDesc);
        Type returnType = Type.getReturnType((String)mvDesc);
        int localIndex = 1;
        for (Type arg : args) {
            mv.visitVarInsn(arg.getOpcode(21), localIndex);
            localIndex += arg.getSize();
        }
        mv.visitMethodInsn(opcode, owner, name, desc, isInterface);
        mv.visitInsn(returnType.getOpcode(172));
        mv.visitMaxs(-1, -1);
    }

    @Deprecated
    public static void writeBridge(MethodVisitor mv, String mvDesc, int opcode, String owner, String name, String desc) {
        Utils.writeBridge(mv, mvDesc, opcode, owner, name, desc, opcode == 185);
    }

    public static void writeBridge(MethodVisitor mv, String mvDesc, int opcode, String owner, String name, String desc, boolean isInterface) {
        mv.visitVarInsn(25, 0);
        Utils.finishBridgeCall(mv, mvDesc, opcode, owner, name, desc, isInterface);
    }

    public static void writeStaticBridge(MethodNode mv, String mName, MixinInfo info) {
        Utils.writeBridge((MethodVisitor)mv, mv.desc, 184, info.name(), mName + "$", Utils.staticDesc(info.name(), mv.desc), true);
    }
}

