/*
 * Decompiled with CFR 0.152.
 */
package codechicken.asm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.objectweb.asm.ConstantDynamic;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackAnalyser {
    private static final boolean DEBUG = Boolean.getBoolean("codechicken.mixin.StackAnalyser.debug");
    private static final boolean DEBUG_FRAMES = Boolean.getBoolean("codechicken.mixin.StackAnalyser.debug_frames");
    private static final Logger LOGGER = LoggerFactory.getLogger(StackAnalyser.class);
    public final Type owner;
    public final MethodNode mNode;
    private final List<StackEntry> stack = new LinkedList<StackEntry>();
    private final List<LocalEntry> locals = new LinkedList<LocalEntry>();
    private final Map<LabelNode, TryCatchBlockNode> catchHandlers = new HashMap<LabelNode, TryCatchBlockNode>();

    public static int width(Type type) {
        return type.getSize();
    }

    public static int width(String type) {
        return StackAnalyser.width(Type.getType((String)type));
    }

    public static int width(Iterable<Type> it) {
        return StackAnalyser.width(StreamSupport.stream(it.spliterator(), false));
    }

    public static int width(Type[] it) {
        return StackAnalyser.width(Arrays.stream(it));
    }

    public static int width(Stream<Type> stream) {
        return stream.mapToInt(StackAnalyser::width).reduce(Integer::sum).orElse(0);
    }

    public StackAnalyser(Type owner, MethodNode mNode) {
        this.owner = owner;
        this.mNode = mNode;
        if ((mNode.access & 8) == 0) {
            this.pushL(new This(owner));
        }
        Type[] pTypes = Type.getArgumentTypes((String)mNode.desc);
        for (int i = 0; i < pTypes.length; ++i) {
            this.pushL(new Param(pTypes[i], i));
        }
        for (TryCatchBlockNode node : mNode.tryCatchBlocks) {
            this.catchHandlers.put(node.handler, node);
        }
    }

    public void pushL(LocalEntry entry) {
        this.locals.add(entry);
    }

    public void setL(int i, LocalEntry entry) {
        while (i + entry.type.getSize() > this.locals.size()) {
            this.locals.add(null);
        }
        this.locals.set(i, entry);
        if (entry.type.getSize() == 2) {
            this.locals.set(i + 1, entry);
        }
    }

    public void push(StackEntry entry) {
        this.insert(0, entry);
    }

    public StackEntry _pop() {
        return this._pop(0);
    }

    public StackEntry _pop(int i) {
        return this.stack.remove(this.stack.size() - i - 1);
    }

    public StackEntry pop() {
        return this.pop(0);
    }

    public StackEntry pop(int i) {
        StackEntry e = this._pop(i);
        if (e.type.getSize() == 2) {
            if (this.peek(i) != e) {
                throw new IllegalStateException("Wide stack entry elems don't match (" + e + ", " + this.peek(i) + ")");
            }
            this._pop(i);
        }
        return e;
    }

    public StackEntry peek() {
        return this.peek(0);
    }

    public StackEntry peek(int i) {
        return this.stack.get(this.stack.size() - i - 1);
    }

    public void insert(int i, StackEntry entry) {
        if (entry.type.getSize() == 0) {
            return;
        }
        this.stack.add(this.stack.size() - i, entry);
        if (entry.type.getSize() == 2) {
            this.stack.add(this.stack.size() - i, entry);
        }
    }

    public List<StackEntry> popArgs(String desc) {
        int len = Type.getArgumentTypes((String)desc).length;
        StackEntry[] args = new StackEntry[len];
        for (int i = 0; i < len; ++i) {
            args[len - i - 1] = this.pop();
        }
        return Arrays.asList(args);
    }

    public void visitInsn(AbstractInsnNode aInsn) {
        block0 : switch (aInsn.getType()) {
            case 0: {
                this.handleInsnNode((InsnNode)aInsn);
                break;
            }
            case 1: {
                IntInsnNode insn = (IntInsnNode)aInsn;
                switch (insn.getOpcode()) {
                    case 16: {
                        this.push(new Const((AbstractInsnNode)insn, (byte)insn.operand));
                        break block0;
                    }
                    case 17: {
                        this.push(new Const((AbstractInsnNode)insn, (short)insn.operand));
                        break block0;
                    }
                }
                if (!DEBUG) break;
                LOGGER.warn("Unhandled Opcode for IntInsnNode: {}", (Object)insn.getOpcode());
                break;
            }
            case 9: {
                LdcInsnNode insn = (LdcInsnNode)aInsn;
                if (insn.getOpcode() == 18) {
                    this.push(new Const((AbstractInsnNode)insn, insn.cst));
                    break;
                }
                if (!DEBUG) break;
                LOGGER.warn("Unhandled Opcode for LdcInsnNode: {}", (Object)insn.getOpcode());
                break;
            }
            case 2: {
                VarInsnNode insn = (VarInsnNode)aInsn;
                switch (insn.getOpcode()) {
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: {
                        this.push(new Load((AbstractInsnNode)insn, this.locals.get(insn.var)));
                        break block0;
                    }
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: {
                        this.setL(insn.var, new Store(this.pop()));
                        break block0;
                    }
                }
                if (!DEBUG) break;
                LOGGER.warn("Unhandled Opcode for VarInsnNode: {}", (Object)insn.getOpcode());
                break;
            }
            case 10: {
                IincInsnNode insn = (IincInsnNode)aInsn;
                if (insn.getOpcode() == 132) {
                    this.setL(insn.var, new Store(new BinaryOp((AbstractInsnNode)insn, new Const((AbstractInsnNode)insn, insn.incr), new Load((AbstractInsnNode)insn, this.locals.get(insn.var)))));
                    break;
                }
                if (!DEBUG) break;
                LOGGER.warn("Unhandled Opcode for IincInsnNode: {}", (Object)insn.getOpcode());
                break;
            }
            case 7: {
                JumpInsnNode insn = (JumpInsnNode)aInsn;
                switch (insn.getOpcode()) {
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: {
                        this.pop();
                        break block0;
                    }
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: {
                        this.pop();
                        this.pop();
                        break block0;
                    }
                    case 168: {
                        this.push(new ReturnAddress((AbstractInsnNode)insn));
                        break block0;
                    }
                    case 198: 
                    case 199: {
                        this.pop();
                        break block0;
                    }
                    case 167: {
                        break block0;
                    }
                }
                if (!DEBUG) break;
                LOGGER.warn("Unhandled Opcode for JumpInsnNode: {}", (Object)insn.getOpcode());
                break;
            }
            case 11: 
            case 12: {
                this.pop();
                break;
            }
            case 4: {
                FieldInsnNode insn = (FieldInsnNode)aInsn;
                switch (aInsn.getOpcode()) {
                    case 178: {
                        this.push(new GetField(insn, null));
                        break block0;
                    }
                    case 179: {
                        this.pop();
                        break block0;
                    }
                    case 180: {
                        this.push(new GetField(insn, this.pop()));
                        break block0;
                    }
                    case 181: {
                        this.pop();
                        this.pop();
                        break block0;
                    }
                }
                if (!DEBUG) break;
                LOGGER.warn("Unhandled Opcode for FieldInsnNode: {}", (Object)insn.getOpcode());
                break;
            }
            case 5: {
                MethodInsnNode insn = (MethodInsnNode)aInsn;
                switch (insn.getOpcode()) {
                    case 182: 
                    case 183: 
                    case 185: {
                        this.push(new Invoke(insn, this.popArgs(insn.desc), this.pop()));
                        break block0;
                    }
                    case 184: {
                        this.push(new Invoke(insn, this.popArgs(insn.desc), null));
                        break block0;
                    }
                }
                if (!DEBUG) break;
                LOGGER.warn("Unhandled Opcode for MethodInsnNode: {}", (Object)insn.getOpcode());
                break;
            }
            case 6: {
                InvokeDynamicInsnNode insn = (InvokeDynamicInsnNode)aInsn;
                this.push(new InvokeDynamic(insn, this.popArgs(insn.desc)));
                break;
            }
            case 3: {
                TypeInsnNode insn = (TypeInsnNode)aInsn;
                switch (insn.getOpcode()) {
                    case 187: {
                        this.push(new New((AbstractInsnNode)insn, Type.getObjectType((String)insn.desc)));
                        break block0;
                    }
                    case 188: {
                        this.push(new NewArray((AbstractInsnNode)insn, Type.getObjectType((String)insn.desc), this.pop()));
                        break block0;
                    }
                    case 189: {
                        this.push(new NewArray((AbstractInsnNode)insn, Type.getType((String)("[" + insn.desc)), this.pop()));
                        break block0;
                    }
                    case 192: {
                        this.push(new Cast((AbstractInsnNode)insn, Type.getObjectType((String)insn.desc), this.pop()));
                        break block0;
                    }
                    case 193: {
                        this.push(new UnaryOp((AbstractInsnNode)insn, this.pop()));
                        break block0;
                    }
                }
                if (!DEBUG) break;
                LOGGER.warn("Unhandled Opcode for TypeInsnNode: {}", (Object)insn.getOpcode());
                break;
            }
            case 13: {
                MultiANewArrayInsnNode insn = (MultiANewArrayInsnNode)aInsn;
                ArrayList<StackEntry> sizes = new ArrayList<StackEntry>(insn.dims);
                for (int i = 0; i < insn.dims; ++i) {
                    sizes.add(this.pop());
                }
                this.push(new NewMultiArray((AbstractInsnNode)insn, Type.getType((String)insn.desc), sizes));
                break;
            }
            case 14: {
                if (!DEBUG_FRAMES) break;
                FrameNode insn = (FrameNode)aInsn;
                switch (insn.type) {
                    case -1: 
                    case 0: {
                        LOGGER.info("Reset stacks/locals.");
                        break block0;
                    }
                    case 1: {
                        LOGGER.info("Add locals.");
                        break block0;
                    }
                    case 2: {
                        LOGGER.info("Remove locals.");
                        break block0;
                    }
                    case 3: {
                        LOGGER.info("Reset.");
                        break block0;
                    }
                    case 4: {
                        LOGGER.info("Reset locals and all but bottom stack.");
                        break block0;
                    }
                }
                LOGGER.info("Unhandled frame type: {}", (Object)insn.type);
                break;
            }
            case 8: {
                LabelNode insn = (LabelNode)aInsn;
                TryCatchBlockNode handlerNode = this.catchHandlers.get(insn);
                if (handlerNode == null || handlerNode.type == null) break;
                this.push(new CaughtException((AbstractInsnNode)insn, Type.getObjectType((String)handlerNode.type)));
                break;
            }
            default: {
                if (!DEBUG) break;
                LOGGER.warn("Unhandled AbstractInsnNode type: {}", (Object)aInsn.getType());
            }
        }
    }

    private void handleInsnNode(InsnNode insn) {
        switch (insn.getOpcode()) {
            case 1: {
                this.push(new Const((AbstractInsnNode)insn, (Object)null));
                break;
            }
            case 2: {
                this.push(new Const((AbstractInsnNode)insn, -1));
                break;
            }
            case 3: {
                this.push(new Const((AbstractInsnNode)insn, 0));
                break;
            }
            case 4: {
                this.push(new Const((AbstractInsnNode)insn, 1));
                break;
            }
            case 5: {
                this.push(new Const((AbstractInsnNode)insn, 2));
                break;
            }
            case 6: {
                this.push(new Const((AbstractInsnNode)insn, 3));
                break;
            }
            case 7: {
                this.push(new Const((AbstractInsnNode)insn, 4));
                break;
            }
            case 8: {
                this.push(new Const((AbstractInsnNode)insn, 5));
                break;
            }
            case 9: {
                this.push(new Const((AbstractInsnNode)insn, 0L));
                break;
            }
            case 10: {
                this.push(new Const((AbstractInsnNode)insn, 1L));
                break;
            }
            case 11: {
                this.push(new Const((AbstractInsnNode)insn, Float.valueOf(0.0f)));
                break;
            }
            case 12: {
                this.push(new Const((AbstractInsnNode)insn, Float.valueOf(1.0f)));
                break;
            }
            case 13: {
                this.push(new Const((AbstractInsnNode)insn, Float.valueOf(2.0f)));
                break;
            }
            case 14: {
                this.push(new Const((AbstractInsnNode)insn, 0.0));
                break;
            }
            case 15: {
                this.push(new Const((AbstractInsnNode)insn, 1.0));
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                this.push(new ArrayLoad((AbstractInsnNode)insn, this.pop(), this.pop()));
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                this.pop();
                this.pop();
                this.pop();
                break;
            }
            case 87: {
                this.pop();
                break;
            }
            case 88: {
                this._pop();
                this._pop();
                break;
            }
            case 89: {
                this.push(this.peek());
                break;
            }
            case 90: {
                this.insert(2, this.peek());
                break;
            }
            case 91: {
                this.insert(3, this.peek());
                break;
            }
            case 92: {
                this.push(this.peek(1));
                this.push(this.peek(1));
                break;
            }
            case 93: {
                this.insert(3, this.peek(1));
                this.insert(3, this.peek());
                break;
            }
            case 94: {
                this.insert(4, this.peek(1));
                this.insert(4, this.peek());
                break;
            }
            case 95: {
                this.push(this.pop(1));
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                this.push(new BinaryOp((AbstractInsnNode)insn, this.pop(), this.pop()));
                break;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                this.push(new UnaryOp((AbstractInsnNode)insn, this.pop()));
                break;
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                this.push(new BinaryOp((AbstractInsnNode)insn, this.pop(), this.pop()));
                break;
            }
            case 136: 
            case 139: 
            case 142: {
                this.push(new PrimitiveCast((AbstractInsnNode)insn, Type.INT_TYPE, this.pop()));
                break;
            }
            case 133: 
            case 140: 
            case 143: {
                this.push(new PrimitiveCast((AbstractInsnNode)insn, Type.LONG_TYPE, this.pop()));
                break;
            }
            case 134: 
            case 137: 
            case 144: {
                this.push(new PrimitiveCast((AbstractInsnNode)insn, Type.FLOAT_TYPE, this.pop()));
                break;
            }
            case 135: 
            case 138: 
            case 141: {
                this.push(new PrimitiveCast((AbstractInsnNode)insn, Type.DOUBLE_TYPE, this.pop()));
                break;
            }
            case 145: {
                this.push(new PrimitiveCast((AbstractInsnNode)insn, Type.BYTE_TYPE, this.pop()));
                break;
            }
            case 146: {
                this.push(new PrimitiveCast((AbstractInsnNode)insn, Type.CHAR_TYPE, this.pop()));
                break;
            }
            case 147: {
                this.push(new PrimitiveCast((AbstractInsnNode)insn, Type.SHORT_TYPE, this.pop()));
                break;
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                this.push(new BinaryOp((AbstractInsnNode)insn, this.pop(), this.pop()));
                break;
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                this.pop();
                break;
            }
            case 190: {
                this.push(new ArrayLength((AbstractInsnNode)insn, this.pop()));
                break;
            }
            case 191: {
                this.pop();
                break;
            }
            case 194: 
            case 195: {
                this.pop();
                break;
            }
            default: {
                if (!DEBUG) break;
                LOGGER.warn("Unhandled Opcode for InsnNode: {}", (Object)insn.getOpcode());
            }
        }
    }

    private static Type computeConstType(Object obj) {
        if (obj instanceof Byte) {
            return Type.BYTE_TYPE;
        }
        if (obj instanceof Short) {
            return Type.SHORT_TYPE;
        }
        if (obj instanceof Integer) {
            return Type.INT_TYPE;
        }
        if (obj instanceof Long) {
            return Type.LONG_TYPE;
        }
        if (obj instanceof Float) {
            return Type.FLOAT_TYPE;
        }
        if (obj instanceof Double) {
            return Type.DOUBLE_TYPE;
        }
        if (obj instanceof Character) {
            return Type.CHAR_TYPE;
        }
        if (obj instanceof Boolean) {
            return Type.BOOLEAN_TYPE;
        }
        if (obj instanceof String) {
            return Type.getObjectType((String)"java/lang/String");
        }
        if (obj == null) {
            return Type.getObjectType((String)"java/lang/Object");
        }
        if (obj instanceof Type) {
            int sort = ((Type)obj).getSort();
            if (sort == 10 || sort == 9) {
                return Type.getObjectType((String)"java/lang/Class");
            }
            if (sort == 11) {
                return Type.getObjectType((String)"java/lang/invoke/MethodType");
            }
            throw new IllegalArgumentException("Invalid Type const: " + obj);
        }
        if (obj instanceof Handle) {
            return Type.getObjectType((String)"java/lang/invoke/MethodHandle");
        }
        if (obj instanceof ConstantDynamic) {
            throw new IllegalArgumentException("ConstantDynamic currently not supported.");
        }
        throw new IllegalArgumentException("Unknown const: " + obj);
    }

    public static class CaughtException
    extends StackEntry {
        public CaughtException(AbstractInsnNode insn, Type type) {
            super(insn, type);
        }
    }

    public static class NewMultiArray
    extends StackEntry {
        public final List<StackEntry> sizes;

        public NewMultiArray(AbstractInsnNode insn, Type type, List<StackEntry> sizes) {
            super(insn, type);
            this.sizes = sizes;
        }
    }

    public static class Cast
    extends StackEntry {
        public final StackEntry obj;

        public Cast(AbstractInsnNode insn, Type type, StackEntry obj) {
            super(insn, type);
            this.obj = obj;
        }
    }

    public static class ArrayLoad
    extends StackEntry {
        public final StackEntry index;
        public final StackEntry array;

        public ArrayLoad(AbstractInsnNode insn, StackEntry index, StackEntry array) {
            super(insn, array.type.getElementType());
            this.index = index;
            this.array = array;
        }
    }

    public static class ArrayLength
    extends StackEntry {
        public final StackEntry array;

        public ArrayLength(AbstractInsnNode insn, StackEntry array) {
            super(insn, Type.INT_TYPE);
            this.array = array;
        }
    }

    public static class NewArray
    extends StackEntry {
        public final StackEntry len;

        public NewArray(AbstractInsnNode insn, Type type, StackEntry len) {
            super(insn, type);
            this.len = len;
        }
    }

    public static class New
    extends StackEntry {
        public New(AbstractInsnNode insn, Type type) {
            super(insn, type);
        }
    }

    public static class InvokeDynamic
    extends StackEntry {
        public final int op;
        public final List<StackEntry> params;

        public InvokeDynamic(InvokeDynamicInsnNode method, List<StackEntry> params) {
            this(method, method.getOpcode(), params);
        }

        public InvokeDynamic(InvokeDynamicInsnNode method, int op, List<StackEntry> params) {
            super((AbstractInsnNode)method, Type.getReturnType((String)method.desc));
            this.op = op;
            this.params = params;
        }
    }

    public static class Invoke
    extends StackEntry {
        public final int op;
        public final List<StackEntry> params;
        public final StackEntry obj;

        public Invoke(MethodInsnNode method, List<StackEntry> params, StackEntry obj) {
            this(method, method.getOpcode(), params, obj);
        }

        public Invoke(MethodInsnNode method, int op, List<StackEntry> params, StackEntry obj) {
            super((AbstractInsnNode)method, Type.getReturnType((String)method.desc));
            this.op = op;
            this.params = params;
            this.obj = obj;
        }
    }

    public static class GetField
    extends StackEntry {
        public final FieldInsnNode field;
        public final StackEntry obj;

        public GetField(FieldInsnNode field, StackEntry obj) {
            super((AbstractInsnNode)field, Type.getType((String)field.desc));
            this.obj = obj;
            this.field = field;
        }
    }

    public static class ReturnAddress
    extends StackEntry {
        public ReturnAddress(AbstractInsnNode insn) {
            super(insn, Type.INT_TYPE);
        }
    }

    public static class PrimitiveCast
    extends StackEntry {
        public final StackEntry e;

        public PrimitiveCast(AbstractInsnNode insn, Type type, StackEntry e) {
            super(insn, type);
            this.e = e;
        }
    }

    public static class BinaryOp
    extends StackEntry {
        public final StackEntry e2;
        public final StackEntry e1;
        public final int op;

        public BinaryOp(AbstractInsnNode insn, StackEntry e2, StackEntry e1) {
            this(insn, e2, e1, insn.getOpcode());
        }

        public BinaryOp(AbstractInsnNode insn, StackEntry e2, StackEntry e1, int op) {
            super(insn, e1.type);
            this.e2 = e2;
            this.e1 = e1;
            this.op = op;
        }
    }

    public static class UnaryOp
    extends StackEntry {
        public final StackEntry e;
        public final int op;

        public UnaryOp(AbstractInsnNode insn, StackEntry e) {
            this(insn, e, insn.getOpcode());
        }

        public UnaryOp(AbstractInsnNode insn, StackEntry e, int op) {
            super(insn, e.type);
            this.e = e;
            this.op = op;
        }
    }

    public static class Load
    extends StackEntry {
        public final LocalEntry e;

        public Load(AbstractInsnNode insn, LocalEntry e) {
            super(insn, e.type);
            this.e = e;
        }
    }

    public static class Const
    extends StackEntry {
        public final Object constObj;

        public Const(AbstractInsnNode insn, Object constObj) {
            super(insn, StackAnalyser.computeConstType(constObj));
            this.constObj = constObj;
        }
    }

    public static class Store
    extends LocalEntry {
        public final StackEntry e;

        public Store(StackEntry e) {
            super(e.type);
            this.e = e;
        }
    }

    public static class Param
    extends LocalEntry {
        public final int i;

        public Param(Type type, int i) {
            super(type);
            this.i = i;
        }
    }

    public static class This
    extends LocalEntry {
        public This(Type type) {
            super(type);
        }
    }

    public static abstract class LocalEntry
    extends Entry {
        public LocalEntry(Type type) {
            super(type);
        }
    }

    public static abstract class StackEntry
    extends Entry {
        public final AbstractInsnNode insn;

        public StackEntry(AbstractInsnNode insn, Type type) {
            super(type);
            this.insn = insn;
        }
    }

    public static abstract class Entry {
        public final Type type;

        public Entry(Type type) {
            this.type = type;
        }
    }
}

