/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.client.renderer;

import com.direwolf20.buildinggadgets2.client.renderer.DireVertexConsumer;
import com.direwolf20.buildinggadgets2.client.renderer.DireVertexConsumerSquished;
import com.direwolf20.buildinggadgets2.client.renderer.OurRenderTypes;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class MyRenderMethods {
    private static Map<BlockEntityType<?>, BlockEntityRenderer<?>> renderers = ImmutableMap.of();

    public static void renderBETransparent(BlockState pState, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay, float alpha) {
        MultiplyAlphaRenderTypeBuffer multiplyAlphaRenderTypeBuffer = new MultiplyAlphaRenderTypeBuffer(pBufferSource, alpha);
        ItemStack stack = new ItemStack((ItemLike)pState.m_60734_());
        IClientItemExtensions.of((ItemStack)stack).getCustomRenderer().m_108829_(stack, ItemDisplayContext.NONE, pPoseStack, (MultiBufferSource)multiplyAlphaRenderTypeBuffer, pPackedLight, pPackedOverlay);
    }

    public static void renderBESquished(BlockState pState, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay, float alpha) {
        SquishedRenderTypeBuffer multiplyAlphaRenderTypeBuffer = new SquishedRenderTypeBuffer(pBufferSource, alpha, pPoseStack.m_85850_().m_252922_());
        ItemStack stack = new ItemStack((ItemLike)pState.m_60734_());
        IClientItemExtensions.of((ItemStack)stack).getCustomRenderer().m_108829_(stack, ItemDisplayContext.NONE, pPoseStack, (MultiBufferSource)multiplyAlphaRenderTypeBuffer, pPackedLight, pPackedOverlay);
    }

    public static void renderCopy(PoseStack matrix, BlockPos startPos, BlockPos endPos, Color color) {
        if (startPos.equals((Object)GadgetNBT.nullPos) || endPos.equals((Object)GadgetNBT.nullPos)) {
            return;
        }
        int x = Math.min(startPos.m_123341_(), endPos.m_123341_());
        int y = Math.min(startPos.m_123342_(), endPos.m_123342_());
        int z = Math.min(startPos.m_123343_(), endPos.m_123343_());
        int dx = startPos.m_123341_() > endPos.m_123341_() ? startPos.m_123341_() + 1 : endPos.m_123341_() + 1;
        int dy = startPos.m_123342_() > endPos.m_123342_() ? startPos.m_123342_() + 1 : endPos.m_123342_() + 1;
        int dz = startPos.m_123343_() > endPos.m_123343_() ? startPos.m_123343_() + 1 : endPos.m_123343_() + 1;
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer builder = buffer.m_6299_(OurRenderTypes.m_110504_());
        matrix.m_85836_();
        Matrix4f matrix4f = matrix.m_85850_().m_252922_();
        Matrix3f matrix3f = matrix.m_85850_().m_252943_();
        int colorRGB = color.getRGB();
        builder.m_252986_(matrix4f, (float)x, (float)y, (float)z).m_193479_(colorRGB).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, (float)dx, (float)y, (float)z).m_193479_(colorRGB).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, (float)x, (float)y, (float)z).m_193479_(colorRGB).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, (float)x, (float)dy, (float)z).m_193479_(colorRGB).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, (float)x, (float)y, (float)z).m_193479_(colorRGB).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(matrix4f, (float)x, (float)y, (float)dz).m_193479_(colorRGB).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(matrix4f, (float)dx, (float)y, (float)z).m_193479_(colorRGB).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, (float)dx, (float)dy, (float)z).m_193479_(colorRGB).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, (float)dx, (float)dy, (float)z).m_193479_(colorRGB).m_252939_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, (float)x, (float)dy, (float)z).m_193479_(colorRGB).m_252939_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, (float)x, (float)dy, (float)z).m_193479_(colorRGB).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(matrix4f, (float)x, (float)dy, (float)dz).m_193479_(colorRGB).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(matrix4f, (float)x, (float)dy, (float)dz).m_193479_(colorRGB).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, (float)x, (float)y, (float)dz).m_193479_(colorRGB).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, (float)x, (float)y, (float)dz).m_193479_(colorRGB).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, (float)dx, (float)y, (float)dz).m_193479_(colorRGB).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, (float)dx, (float)y, (float)dz).m_193479_(colorRGB).m_252939_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
        builder.m_252986_(matrix4f, (float)dx, (float)y, (float)z).m_193479_(colorRGB).m_252939_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
        builder.m_252986_(matrix4f, (float)x, (float)dy, (float)dz).m_193479_(colorRGB).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, (float)dx, (float)dy, (float)dz).m_193479_(colorRGB).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, (float)dx, (float)y, (float)dz).m_193479_(colorRGB).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, (float)dx, (float)dy, (float)dz).m_193479_(colorRGB).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, (float)dx, (float)dy, (float)z).m_193479_(colorRGB).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(matrix4f, (float)dx, (float)dy, (float)dz).m_193479_(colorRGB).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_109912_(OurRenderTypes.m_110504_());
        matrix.m_85849_();
    }

    public static void renderBoxSolid(Matrix4f matrix, VertexConsumer builder, BlockPos pos, float r, float g, float b, float alpha) {
        double x = (double)pos.m_123341_() - 0.001;
        double y = (double)pos.m_123342_() - 0.001;
        double z = (double)pos.m_123343_() - 0.001;
        double xEnd = (double)pos.m_123341_() + 1.0015;
        double yEnd = (double)pos.m_123342_() + 1.0015;
        double zEnd = (double)pos.m_123343_() + 1.0015;
        MyRenderMethods.renderBoxSolid(matrix, builder, x, y, z, xEnd, yEnd, zEnd, r, g, b, alpha);
    }

    protected static void renderBoxSolid(Matrix4f matrix, VertexConsumer builder, double x, double y, double z, double xEnd, double yEnd, double zEnd, float red, float green, float blue, float alpha) {
        float startX = (float)x;
        float startY = (float)y;
        float startZ = (float)z;
        float endX = (float)xEnd;
        float endY = (float)yEnd;
        float endZ = (float)zEnd;
        builder.m_252986_(matrix, startX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
    }

    public static class MultiplyAlphaRenderTypeBuffer
    implements MultiBufferSource {
        private final MultiBufferSource inner;
        private final float constantAlpha;

        public MultiplyAlphaRenderTypeBuffer(MultiBufferSource inner, float constantAlpha) {
            this.inner = inner;
            this.constantAlpha = constantAlpha;
        }

        public VertexConsumer m_6299_(RenderType type) {
            RenderType localType = type;
            if (localType instanceof RenderType.CompositeRenderType) {
                ResourceLocation texture = ((RenderStateShard.TextureStateShard)((RenderType.CompositeRenderType)localType).f_110511_.f_110576_).f_110328_.orElse(InventoryMenu.f_39692_);
                localType = RenderType.m_110470_((ResourceLocation)texture);
            } else if (localType.toString().equals(Sheets.m_110792_().toString())) {
                localType = Sheets.m_110792_();
            }
            return new DireVertexConsumer(this.inner.m_6299_(localType), this.constantAlpha);
        }
    }

    public static class SquishedRenderTypeBuffer
    implements MultiBufferSource {
        private final MultiBufferSource inner;
        private final float squishAmt;
        private final Matrix4f matrix4f;

        public SquishedRenderTypeBuffer(MultiBufferSource inner, float squishAmt, Matrix4f matrix4f) {
            this.inner = inner;
            this.squishAmt = squishAmt;
            this.matrix4f = matrix4f;
        }

        public VertexConsumer m_6299_(RenderType type) {
            RenderType localType = type;
            if (localType instanceof RenderType.CompositeRenderType) {
                ResourceLocation texture = ((RenderStateShard.TextureStateShard)((RenderType.CompositeRenderType)localType).f_110511_.f_110576_).f_110328_.orElse(InventoryMenu.f_39692_);
                localType = RenderType.m_110470_((ResourceLocation)texture);
            } else if (localType.toString().equals(Sheets.m_110792_().toString())) {
                localType = Sheets.m_110792_();
            }
            return new DireVertexConsumerSquished(this.inner.m_6299_(localType), 0.0f, 0.0f, 0.0f, 1.0f, this.squishAmt, 1.0f, this.matrix4f);
        }
    }
}

