/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsrpgtweaks.damage_module;

import io.redspace.ironsrpgtweaks.IronsRpgTweaks;
import io.redspace.ironsrpgtweaks.config.ClientConfig;
import io.redspace.ironsrpgtweaks.config.ServerConfigs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class DamageClientEvents {
    @SubscribeEvent
    public static void onPlayerAttack(InputEvent.InteractionKeyMappingTriggered event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (((Boolean)ServerConfigs.DAMAGE_MODULE_ENABLED.get()).booleanValue() && !((Boolean)ServerConfigs.ALLOW_NON_FULL_STRENGTH_ATTACKS.get()).booleanValue() && player != null && event.isAttack() && (double)player.m_36403_(0.0f) < (Double)ServerConfigs.MINIMUM_ATTACK_STRENGTH.get()) {
            event.setSwingHand(false);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingDamageEvent event) {
        if (!((Boolean)ServerConfigs.DAMAGE_MODULE_ENABLED.get()).booleanValue() || !((Boolean)ClientConfig.combatDebugMode.get()).booleanValue()) {
            return;
        }
        ResourceLocation attacker = DamageClientEvents.getResourceLocation(event.getSource().m_7640_());
        ResourceLocation victim = DamageClientEvents.getResourceLocation((Entity)event.getEntity());
        DamageSource damageSource = event.getSource();
        String message = attacker != null ? String.format("Attacker: %s | Victim: %s | DamageSource: %s", attacker, victim, damageSource.m_19385_()) : String.format("Victim: %s | DamageSource: %s", victim, damageSource.m_19385_());
        IronsRpgTweaks.LOGGER.info(message);
        if (Minecraft.m_91087_().f_91074_ != null) {
            Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237113_((String)message));
        }
    }

    @Nullable
    public static ResourceLocation getResourceLocation(@Nullable Entity entity) {
        if (entity == null) {
            return null;
        }
        return ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
    }
}

