/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createmechanicalextruder.compat.kubejs;

import com.mojang.datafixers.util.Either;
import dev.latvian.mods.kubejs.fluid.InputFluid;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.FluidComponents;
import dev.latvian.mods.kubejs.recipe.component.ItemComponents;
import dev.latvian.mods.kubejs.recipe.component.NumberComponent;
import dev.latvian.mods.kubejs.recipe.component.TagKeyComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;

public interface ExtrudingRecipeSchema {
    public static final RecipeKey<Either<InputFluid, InputItem>[]> INGREDIENTS = FluidComponents.INPUT_OR_ITEM_ARRAY.key("ingredients");
    public static final RecipeKey<OutputItem> RESULT = ItemComponents.OUTPUT.key("result");
    public static final RecipeKey<InputItem> CATALYST = ItemComponents.INPUT.key("catalyst").defaultOptional().allowEmpty();
    public static final RecipeKey<Integer> REQUIRED_BONKS = NumberComponent.INT.key("requiredBonks").optional((Object)1);
    public static final RecipeKey<Float> MIN_SPEED = NumberComponent.FLOAT.key("min_speed").defaultOptional().allowEmpty();
    public static final RecipeKey<Integer> MIN_HEIGHT = NumberComponent.INT.key("min_height").defaultOptional().allowEmpty();
    public static final RecipeKey<Integer> MAX_HEIGHT = NumberComponent.INT.key("max_height").defaultOptional().allowEmpty();
    public static final RecipeKey<TagKey<Biome>> BIOME = TagKeyComponent.BIOME.key("biome").defaultOptional().allowEmpty();
    public static final RecipeSchema SCHEMA = new RecipeSchema(ExtrudingRecipe.class, ExtrudingRecipe::new, new RecipeKey[]{RESULT, INGREDIENTS, CATALYST, REQUIRED_BONKS, MIN_SPEED, MIN_HEIGHT, MAX_HEIGHT, BIOME});

    public static class ExtrudingRecipe
    extends RecipeJS {
        public RecipeJS withCatalyst(InputItem item) {
            return this.setValue(CATALYST, item);
        }

        public RecipeJS minHeight(int value) {
            return this.setValue(MIN_HEIGHT, value);
        }

        public RecipeJS maxHeight(int value) {
            return this.setValue(MAX_HEIGHT, value);
        }

        public RecipeJS minSpeed(float value) {
            return this.setValue(MIN_SPEED, Float.valueOf(value));
        }
    }
}

