/*
 * Decompiled with CFR 0.152.
 */
package org.mesdag.geckojs.item.armor;

import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import dev.latvian.mods.kubejs.item.custom.ArmorItemBuilder;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import org.mesdag.geckojs.AnimationControllerBuilder;
import org.mesdag.geckojs.ExtendedGeoModel;
import org.mesdag.geckojs.item.armor.AnimatableArmorItem;
import org.mesdag.geckojs.item.armor.IAnimatableArmorRenderer;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;

public class AnimatableArmorBuilder
extends ArmorItemBuilder {
    public final ExtendedGeoModel<AnimatableArmorItem> armorModel = new ExtendedGeoModel();
    public final transient ArrayList<AnimationControllerBuilder<AnimatableArmorItem>> controllers = new ArrayList();
    public final transient ArrayList<AnimationStateCallback> animations = new ArrayList();
    public boolean useGeoModel = false;
    public BoneVisibilityCallback boneVisibilityCallback;

    public AnimatableArmorBuilder(ResourceLocation id, ArmorItem.Type type) {
        super(id, type);
    }

    public AnimatableArmorBuilder addAnimation(AnimationStateCallback callBack) {
        this.animations.add(callBack);
        return this;
    }

    public AnimatableArmorBuilder addController(Consumer<AnimationControllerBuilder<AnimatableArmorItem>> consumer) {
        AnimationControllerBuilder builder = new AnimationControllerBuilder();
        consumer.accept(builder);
        this.controllers.add(builder);
        return this;
    }

    public AnimatableArmorBuilder geoModel(Consumer<ExtendedGeoModel.Builder<AnimatableArmorItem>> consumer) {
        consumer.accept(this.armorModel.builder);
        return this;
    }

    public AnimatableArmorBuilder armorItemUseGeoModel() {
        this.useGeoModel = true;
        return this;
    }

    public AnimatableArmorBuilder defaultGeoModel() {
        this.armorModel.builder.setSimpleModel(new ResourceLocation(this.id.m_135827_(), "geo/armor/" + this.id.m_135815_() + ".geo.json"));
        this.armorModel.builder.setSimpleTexture(new ResourceLocation(this.id.m_135827_(), "textures/armor/" + this.id.m_135815_() + ".png"));
        this.armorModel.builder.setSimpleAnimation(new ResourceLocation(this.id.m_135827_(), "animations/armor/" + this.id.m_135815_() + ".animation.json"));
        return this;
    }

    public AnimatableArmorBuilder boneVisibility(BoneVisibilityCallback callback) {
        this.boneVisibilityCallback = callback;
        return this;
    }

    public Item createObject() {
        return new AnimatableArmorItem(this);
    }

    public void generateAssetJsons(AssetJsonGenerator generator) {
        if (this.useGeoModel) {
            String parent;
            if (this.parentModel.isEmpty()) {
                switch (this.armorType) {
                    case HELMET: {
                        parent = "geckojs:item/helmet";
                        break;
                    }
                    case CHESTPLATE: {
                        parent = "geckojs:item/chestplate";
                        break;
                    }
                    case LEGGINGS: {
                        parent = "geckojs:item/leggings";
                        break;
                    }
                    case BOOTS: {
                        parent = "geckojs:item/boots";
                        break;
                    }
                    default: {
                        parent = "geckojs:item/item";
                        break;
                    }
                }
            } else {
                parent = this.parentModel;
            }
            generator.itemModel(this.id, model -> model.parent(parent));
        } else {
            super.generateAssetJsons(generator);
        }
    }

    @FunctionalInterface
    public static interface BoneVisibilityCallback {
        public void apply(IAnimatableArmorRenderer var1, EquipmentSlot var2);
    }

    @FunctionalInterface
    public static interface AnimationStateCallback {
        public PlayState create(AnimationState<AnimatableArmorItem> var1);
    }
}

