/*
 * Decompiled with CFR 0.152.
 */
package org.mesdag.geckojs.item;

import dev.latvian.mods.kubejs.item.custom.BasicItemJS;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.mesdag.geckojs.item.AbstractAnimatableItemBuilder;
import org.mesdag.geckojs.item.AnimatableItemRenderer;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AnimatableItem
extends BasicItemJS
implements GeoItem {
    private final AnimatableInstanceCache CACHE = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final AbstractAnimatableItemBuilder<AnimatableItem> itemBuilder;

    public AnimatableItem(AbstractAnimatableItemBuilder<AnimatableItem> builder) {
        super(builder);
        this.itemBuilder = builder;
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.itemBuilder.usingAnimationCallback != null) {
                this.itemBuilder.usingAnimationCallback.call(this, serverLevel, (ServerPlayer)player, hand);
            }
        }
        return super.m_7203_(level, player, hand);
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.itemBuilder.finishUsingAnimationCallback != null) {
                this.itemBuilder.finishUsingAnimationCallback.call(this, serverLevel, livingEntity);
            }
        }
        return super.m_5922_(itemStack, level, livingEntity);
    }

    public void m_5551_(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull LivingEntity livingEntity, int tick) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.itemBuilder.releaseUsingAnimationCallback != null) {
                this.itemBuilder.releaseUsingAnimationCallback.call(this, serverLevel, livingEntity, tick);
            }
        }
        super.m_5551_(itemStack, level, livingEntity, tick);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private AnimatableItemRenderer<AnimatableItem> renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    AnimatableItemRenderer itemRenderer = new AnimatableItemRenderer(AnimatableItem.this.itemBuilder.itemModel);
                    if (AnimatableItem.this.itemBuilder.useEntityGuiLighting) {
                        itemRenderer.useAlternateGuiLighting();
                    }
                    this.renderer = itemRenderer;
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        this.itemBuilder.controllers.forEach(controller -> registrar.add(new AnimationController[]{controller.build(this)}));
        this.itemBuilder.animations.forEach(animation -> {
            AnimationController[] animationControllerArray = new AnimationController[1];
            animationControllerArray[0] = new AnimationController((GeoAnimatable)this, animation::create);
            registrar.add(animationControllerArray);
        });
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.CACHE;
    }

    public static class Builder
    extends AbstractAnimatableItemBuilder<AnimatableItem> {
        public Builder(ResourceLocation id) {
            super(id);
        }

        public AnimatableItem createObject() {
            return new AnimatableItem(this);
        }
    }
}

