/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.inventory.energy.impl;

import net.creeperhost.polylib.inventory.energy.EnergySnapshot;
import net.creeperhost.polylib.inventory.energy.PolyEnergyContainer;
import net.creeperhost.polylib.inventory.energy.impl.SimpleEnergySnapshot;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;

public class SimpleEnergyContainer
implements PolyEnergyContainer {
    private final long capacity;
    private long energy;

    public SimpleEnergyContainer(long maxCapacity) {
        this.capacity = maxCapacity;
    }

    @Override
    public long insertEnergy(long maxAmount, boolean simulate) {
        long inserted = (long)Mth.m_14036_((float)maxAmount, (float)0.0f, (float)(this.getMaxCapacity() - this.getStoredEnergy()));
        if (simulate) {
            return inserted;
        }
        this.setEnergy(this.energy + inserted);
        return inserted;
    }

    @Override
    public long extractEnergy(long maxAmount, boolean simulate) {
        long extracted = (long)Mth.m_14036_((float)maxAmount, (float)0.0f, (float)this.getStoredEnergy());
        if (simulate) {
            return extracted;
        }
        this.setEnergy(this.energy - extracted);
        return extracted;
    }

    @Override
    public long internalInsert(long maxAmount, boolean simulate) {
        return this.insertEnergy(maxAmount, simulate);
    }

    @Override
    public long internalExtract(long maxAmount, boolean simulate) {
        return this.extractEnergy(maxAmount, simulate);
    }

    @Override
    public void setEnergy(long energy) {
        this.energy = energy;
    }

    @Override
    public long getStoredEnergy() {
        return this.energy;
    }

    @Override
    public long getMaxCapacity() {
        return this.capacity;
    }

    @Override
    public long maxInsert() {
        return 1024L;
    }

    @Override
    public long maxExtract() {
        return 1024L;
    }

    @Override
    public CompoundTag serialize(CompoundTag root) {
        CompoundTag tag = root.m_128469_("polylib");
        tag.m_128356_("Energy", this.energy);
        root.m_128365_("polylib", (Tag)tag);
        return root;
    }

    @Override
    public void deserialize(CompoundTag root) {
        CompoundTag tag = root.m_128469_("polylib");
        this.energy = tag.m_128454_("Energy");
    }

    @Override
    public boolean allowsInsertion() {
        return true;
    }

    @Override
    public boolean allowsExtraction() {
        return true;
    }

    @Override
    public EnergySnapshot createSnapshot() {
        return new SimpleEnergySnapshot(this);
    }

    public void m_6211_() {
        this.energy = 0L;
    }
}

