/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.data.serializable;

import java.util.HashMap;
import java.util.Map;
import net.creeperhost.polylib.data.serializable.AbstractDataStore;
import net.creeperhost.polylib.helpers.MathUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumData<T extends Enum<T>>
extends AbstractDataStore<T> {
    private final Class<T> enumClass;
    public Map<Integer, T> indexToValue = new HashMap<Integer, T>();
    public Map<T, Integer> valueToIndex = new HashMap<T, Integer>();

    public EnumData(@NotNull T defaultValue) {
        this(((Enum)defaultValue).getDeclaringClass(), defaultValue);
    }

    public EnumData(Class<T> enumClass, @Nullable T defaultValue) {
        super(defaultValue);
        this.enumClass = enumClass;
        Enum[] v = (Enum[])enumClass.getEnumConstants();
        if (v.length > 255) {
            throw new RuntimeException("Max enum size supported by EnumData is 255");
        }
        for (int i = 0; i < v.length; ++i) {
            this.indexToValue.put(i, v[i]);
            this.valueToIndex.put(v[i], i);
        }
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.value == null);
        if (this.value != null) {
            buf.m_130068_((Enum)this.value);
        }
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        if (!buf.readBoolean()) {
            this.value = this.validValue(buf.m_130066_(this.enumClass), (Enum)this.value);
        }
    }

    @Override
    public Tag toTag() {
        CompoundTag nbt = new CompoundTag();
        if (this.value == null) {
            nbt.m_128379_("null", true);
        } else {
            nbt.m_128344_("value", this.valueToIndex.get(this.value).byteValue());
        }
        return nbt;
    }

    @Override
    public void fromTag(Tag tag) {
        if (tag instanceof CompoundTag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.value = nbt.m_128441_("null") ? null : this.validValue((Enum)this.indexToValue.get(MathUtil.clamp(nbt.m_128445_("value") & 0xFF, 0, this.indexToValue.size() - 1)), (Enum)this.value);
        }
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean notNull() {
        return this.value != null;
    }
}

