/*
 * Decompiled with CFR 0.152.
 */
package com.oe.rehooked.network.packets.client.processing;

import com.oe.rehooked.handlers.hook.def.IClientPlayerHookHandler;
import com.oe.rehooked.network.handlers.IHandler;
import com.oe.rehooked.network.packets.client.CHookCapabilityPacket;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class CHookCapabilityProcessor
implements IHandler {
    public static void handle(CHookCapabilityPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CHookCapabilityProcessor.handle(packet)));
        context.get().setPacketHandled(true);
    }

    private static void handle(CHookCapabilityPacket packet) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Optional optHandler = IClientPlayerHookHandler.FromPlayer((Player)player).resolve();
        if (optHandler.isPresent()) {
            IClientPlayerHookHandler handler = (IClientPlayerHookHandler)optHandler.get();
            switch (packet.packetType) {
                case ADD_HOOK: {
                    handler.addHook(packet.id);
                    break;
                }
                case RETRACT_HOOK: {
                    handler.removeHook(packet.id);
                    break;
                }
                case RETRACT_ALL_HOOKS: {
                    handler.removeAllHooks();
                    break;
                }
                case FORCE_UPDATE: {
                    handler.update();
                }
            }
        }
    }
}

