/*
 * Decompiled with CFR 0.152.
 */
package com.oe.rehooked.network.handlers;

import com.mojang.logging.LogUtils;
import com.oe.rehooked.network.handlers.IHandler;
import com.oe.rehooked.network.packets.client.CHookCapabilityPacket;
import com.oe.rehooked.network.packets.server.SHookCapabilityPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.slf4j.Logger;

public class PacketHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String PROTOCOL_VERSION = "1";
    private static final SimpleChannel INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("rehooked", "main")).serverAcceptedVersions(s -> true).clientAcceptedVersions(s -> true).networkProtocolVersion(() -> "1").simpleChannel();
    private static final Map<Class<?>, BiConsumer<? extends IHandler, Supplier<NetworkEvent.Context>>> handlers = new HashMap();

    public static <T, E extends IHandler> void addHandler(Class<T> clazz, BiConsumer<E, Supplier<NetworkEvent.Context>> handler) {
        handlers.put(clazz, handler);
    }

    private static <T> void handle(T packet, Supplier<NetworkEvent.Context> context) {
        BiConsumer<? extends IHandler, Supplier<NetworkEvent.Context>> consumer = handlers.get(packet.getClass());
        if (consumer != null) {
            consumer.accept((IHandler)packet, context);
        } else {
            context.get().setPacketHandled(true);
        }
    }

    public static void init() {
        LOGGER.debug("Packet handler register started...");
        int id = 0;
        INSTANCE.messageBuilder(SHookCapabilityPacket.class, id++).encoder(SHookCapabilityPacket::encode).decoder(SHookCapabilityPacket::new).consumerMainThread(SHookCapabilityPacket::handle).add();
        LOGGER.debug("Registered ServerHookPacket");
        INSTANCE.messageBuilder(CHookCapabilityPacket.class, id++).encoder(CHookCapabilityPacket::encode).decoder(CHookCapabilityPacket::new).consumerMainThread(PacketHandler::handle).add();
        LOGGER.debug("Registered ClientHookPacket");
    }

    public static void sendToServer(Object msg) {
        INSTANCE.send(PacketDistributor.SERVER.noArg(), msg);
    }

    public static void sendToPlayer(Object msg, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), msg);
    }

    public static void sendToAllClients(Object msg) {
        INSTANCE.send(PacketDistributor.ALL.noArg(), msg);
    }

    public static void sendToClientsInRange(ServerLevel level, Vec3 position, int range, Object message) {
        level.m_6907_().forEach(player -> {
            if (player.m_20238_(position) <= (double)(range * range)) {
                PacketHandler.sendToPlayer(message, player);
            }
        });
    }

    public static void sendToClientsInLevel(ServerLevel level, Object message) {
        LOGGER.debug("Sending message {} to all players in dimension {}", message, (Object)level);
        level.m_6907_().forEach(player -> PacketHandler.sendToPlayer(message, player));
    }
}

