/*
 * Decompiled with CFR 0.152.
 */
package com.oe.rehooked.events.subscribers.client;

import com.mojang.logging.LogUtils;
import com.oe.rehooked.client.KeyBindings;
import com.oe.rehooked.data.HookData;
import com.oe.rehooked.entities.hook.HookEntity;
import com.oe.rehooked.handlers.hook.def.IClientPlayerHookHandler;
import com.oe.rehooked.item.hook.HookItem;
import com.oe.rehooked.utils.CurioUtils;
import com.oe.rehooked.utils.VectorHelper;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="rehooked", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientForgeEvents {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static long ticksSinceShot = 0L;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.END)) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ++ticksSinceShot;
        Optional optHandler = IClientPlayerHookHandler.FromPlayer((Player)player).resolve();
        if (optHandler.isEmpty()) {
            LOGGER.debug("Player hook handler not found!");
            return;
        }
        IClientPlayerHookHandler handler = (IClientPlayerHookHandler)optHandler.get();
        if (KeyBindings.FIRE_HOOK_KEY.m_90859_() && ticksSinceShot > 5L) {
            ticksSinceShot = 0L;
            CurioUtils.getCuriosOfType(HookItem.class, (LivingEntity)player).flatMap(CurioUtils::getIfUnique).ifPresent(hookStack -> {
                Entity camera = Minecraft.m_91087_().m_91288_();
                handler.shootFromRotation(camera.m_146909_(), camera.m_146908_());
            });
        }
        if (KeyBindings.RETRACT_HOOK_KEY.m_90859_() && !handler.getHooks().isEmpty()) {
            Optional<HookEntity> target = VectorHelper.acquireLookTarget(HookEntity.class, (Player)player, 0.5);
            target.ifPresent(handler::removeHook);
        }
        handler.setOwner((Player)player).update();
        if (handler.shouldMoveThisTick()) {
            player.m_20256_(handler.getDeltaVThisTick());
        }
        if (KeyBindings.REMOVE_ALL_HOOKS_KEY.m_90859_() && !handler.getHooks().isEmpty() && !handler.getHookData().map(HookData::isCreative).orElse(true).booleanValue()) {
            handler.jump();
        }
        handler.storeLastPlayerPosition();
    }
}

