/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.entity;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.pandamods.fallingtrees.api.TreeType;
import me.pandamods.fallingtrees.config.FallingTreesConfig;
import me.pandamods.fallingtrees.registry.TreeRegistry;
import me.pandamods.fallingtrees.utils.BlockMapEntityData;
import me.pandamods.fallingtrees.utils.ItemListEntityData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;

public class TreeEntity
extends Entity {
    public static final EntityDataAccessor<Map<BlockPos, BlockState>> BLOCKS = SynchedEntityData.m_135353_(TreeEntity.class, BlockMapEntityData.BLOCK_MAP);
    public static final EntityDataAccessor<List<ItemStack>> DROPS = SynchedEntityData.m_135353_(TreeEntity.class, ItemListEntityData.ITEM_LIST);
    public static final EntityDataAccessor<BlockPos> ORIGIN_POS = SynchedEntityData.m_135353_(TreeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    public static final EntityDataAccessor<Direction> FALL_DIRECTION = SynchedEntityData.m_135353_(TreeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    public static final EntityDataAccessor<String> TREE_TYPE_LOCATION = SynchedEntityData.m_135353_(TreeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public Entity owner = null;
    public TreeType treeType = null;

    public TreeEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.f_19811_ = true;
    }

    public void setData(Entity owner, TreeType tree, BlockPos originBlock, List<BlockPos> blockPosList, List<ItemStack> drops) {
        this.owner = owner;
        this.treeType = tree;
        ResourceLocation treeTypeLocation = TreeRegistry.getTreeLocation(tree);
        if (treeTypeLocation != null) {
            this.m_20088_().m_135381_(TREE_TYPE_LOCATION, (Object)treeTypeLocation.toString());
        }
        HashMap<BlockPos, BlockState> blockPosMap = new HashMap<BlockPos, BlockState>();
        for (BlockPos pos : blockPosList) {
            blockPosMap.put(pos.m_7949_().m_121996_((Vec3i)originBlock), this.m_9236_().m_8055_(pos));
        }
        this.m_20088_().m_135381_(ORIGIN_POS, (Object)originBlock);
        this.m_20088_().m_135381_(BLOCKS, blockPosMap);
        this.m_20088_().m_135381_(DROPS, drops);
        this.m_20088_().m_135381_(FALL_DIRECTION, (Object)Direction.m_122364_((double)(-Math.toDegrees((double)Math.atan2((double)(owner.m_20185_() - (double)originBlock.m_123341_()), (double)(owner.m_20189_() - (double)originBlock.m_123343_()))))).m_122424_());
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(BLOCKS, Collections.emptyMap());
        this.m_20088_().m_135372_(DROPS, Collections.emptyList());
        this.m_20088_().m_135372_(ORIGIN_POS, (Object)new BlockPos(0, 0, 0));
        this.m_20088_().m_135372_(FALL_DIRECTION, (Object)Direction.NORTH);
        this.m_20088_().m_135372_(TREE_TYPE_LOCATION, (Object)"");
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        super.m_7350_(dataAccessor);
        if (TREE_TYPE_LOCATION.equals(dataAccessor)) {
            this.treeType = TreeRegistry.getTree(ResourceLocation.m_135820_((String)((String)this.m_20088_().m_135370_(TREE_TYPE_LOCATION))));
        }
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    public void m_8119_() {
        super.m_8119_();
        this.treeType.onTreeTick(this);
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, -0.5, 1.0));
        }
        if (this.f_19797_ >= this.getMaxLifeTimeTick()) {
            if (!this.m_9236_().m_5776_()) {
                this.dropItems();
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    private void dropItems() {
        for (ItemStack stack : (List)this.m_20088_().m_135370_(DROPS)) {
            double deltaX = Mth.m_216263_((RandomSource)this.m_9236_().f_46441_, (double)-0.1, (double)0.1);
            double deltaY = 0.25;
            double deltaZ = Mth.m_216263_((RandomSource)this.m_9236_().f_46441_, (double)-0.1, (double)0.1);
            ItemEntity entity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_() + (double)(EntityType.f_20461_.m_20679_() / 2.0f), this.m_20189_(), stack, deltaX, deltaY, deltaZ);
            entity.m_32060_();
            this.m_9236_().m_7967_((Entity)entity);
        }
    }

    public int getMaxLifeTimeTick() {
        return (int)(FallingTreesConfig.getCommonConfig().treeLifetimeLength * 20.0f);
    }

    public float getLifetime(float partialTick) {
        return ((float)this.f_19797_ + partialTick) / 20.0f;
    }

    public Map<BlockPos, BlockState> getBlocks() {
        return (Map)this.m_20088_().m_135370_(BLOCKS);
    }

    public BlockPos getOriginPos() {
        return (BlockPos)this.m_20088_().m_135370_(ORIGIN_POS);
    }

    @NotNull
    public Direction m_6350_() {
        return (Direction)this.m_20088_().m_135370_(FALL_DIRECTION);
    }

    public TreeType getTreeType() {
        return this.treeType;
    }
}

