/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui;

import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.CustomTabProvider;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.PlaceholderCategory;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.api.utils.MutableDimension;
import dev.isxander.yacl3.api.utils.OptionUtils;
import dev.isxander.yacl3.gui.DescriptionWithName;
import dev.isxander.yacl3.gui.OptionDescriptionWidget;
import dev.isxander.yacl3.gui.OptionListWidget;
import dev.isxander.yacl3.gui.SearchFieldWidget;
import dev.isxander.yacl3.gui.YACLTooltip;
import dev.isxander.yacl3.gui.controllers.ControllerPopupWidget;
import dev.isxander.yacl3.gui.controllers.PopupControllerScreen;
import dev.isxander.yacl3.gui.tab.ListHolderWidget;
import dev.isxander.yacl3.gui.tab.ScrollableNavigationBar;
import dev.isxander.yacl3.gui.tab.TabExt;
import dev.isxander.yacl3.gui.utils.GuiUtils;
import dev.isxander.yacl3.impl.utils.YACLConstants;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class YACLScreen
extends Screen {
    public final YetAnotherConfigLib config;
    private final Screen parent;
    public final TabManager tabManager = new TabManager(x$0 -> {
        AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
    }, x$0 -> this.m_169411_((GuiEventListener)x$0));
    public ScrollableNavigationBar tabNavigationBar;
    public ScreenRectangle tabArea;
    public Component saveButtonMessage;
    public Tooltip saveButtonTooltipMessage;
    private int saveButtonMessageTime;
    private boolean pendingChanges;
    public ControllerPopupWidget<?> currentPopupController = null;
    public boolean popupControllerVisible = false;

    public YACLScreen(YetAnotherConfigLib config, Screen parent) {
        super(config.title());
        this.config = config;
        this.parent = parent;
        OptionUtils.forEachOptions(config, option -> option.addListener((opt, val) -> this.onOptionChanged((Option<?>)opt)));
    }

    protected void m_7856_() {
        int currentTab;
        this.tabArea = new ScreenRectangle(0, 23, this.f_96543_, this.f_96544_ - 24 + 1);
        int n = currentTab = this.tabNavigationBar != null ? this.tabNavigationBar.getTabs().indexOf((Object)this.tabManager.m_267695_()) : 0;
        if (currentTab == -1) {
            currentTab = 0;
        }
        this.tabNavigationBar = new ScrollableNavigationBar(this.f_96543_, this.tabManager, this.config.categories().stream().map(category -> {
            if (category instanceof CustomTabProvider) {
                CustomTabProvider tabProvider = (CustomTabProvider)((Object)category);
                return tabProvider.createTab(this, this.tabArea);
            }
            if (category instanceof PlaceholderCategory) {
                PlaceholderCategory placeholder = (PlaceholderCategory)category;
                return new PlaceholderTab(placeholder, this);
            }
            return new CategoryTab(this, (ConfigCategory)category, this.tabArea);
        }).toList());
        this.tabNavigationBar.m_276089_(currentTab, false);
        this.tabNavigationBar.m_267766_();
        this.tabManager.m_267817_(this.tabArea);
        this.m_142416_((GuiEventListener)this.tabNavigationBar);
        this.config.initConsumer().accept(this);
    }

    public void addPopupControllerWidget(ControllerPopupWidget<?> controllerPopupWidget) {
        if (this.currentPopupController != null) {
            this.clearPopupControllerWidget();
        }
        this.currentPopupController = controllerPopupWidget;
        this.popupControllerVisible = true;
        OptionListWidget optionListWidget = null;
        Tab tab = this.tabNavigationBar.getTabManager().m_267695_();
        if (tab instanceof CategoryTab) {
            CategoryTab categoryTab = (CategoryTab)tab;
            optionListWidget = categoryTab.optionList.getList();
        }
        if (optionListWidget != null) {
            this.f_96541_.m_91152_((Screen)new PopupControllerScreen(this, controllerPopupWidget));
        }
    }

    public void clearPopupControllerWidget() {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof PopupControllerScreen) {
            PopupControllerScreen popupControllerScreen = (PopupControllerScreen)screen;
            popupControllerScreen.m_7379_();
        }
        this.popupControllerVisible = false;
        this.currentPopupController = null;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280039_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        super.m_280273_(guiGraphics);
        Tab tab = this.tabManager.m_267695_();
        if (tab instanceof TabExt) {
            TabExt tab2 = (TabExt)tab;
            tab2.renderBackground(guiGraphics);
        }
    }

    public void finishOrSave() {
        this.saveButtonMessage = null;
        if (this.pendingChanges()) {
            HashSet flags = new HashSet();
            OptionUtils.forEachOptions(this.config, option -> {
                if (option.applyValue()) {
                    flags.addAll(option.flags());
                }
            });
            OptionUtils.forEachOptions(this.config, option -> {
                if (option.changed()) {
                    option.forgetPendingValue();
                    YACLConstants.LOGGER.error("Option '{}' value mismatch after applying! Reset to binding's getter.", (Object)option.name().getString());
                }
            });
            this.config.saveFunction().run();
            flags.forEach(flag -> flag.accept(this.f_96541_));
            this.pendingChanges = false;
            Tab tab = this.tabManager.m_267695_();
            if (tab instanceof CategoryTab) {
                CategoryTab categoryTab = (CategoryTab)tab;
                categoryTab.updateButtons();
            }
        } else {
            this.m_7379_();
        }
    }

    public void cancelOrReset() {
        if (this.pendingChanges()) {
            OptionUtils.forEachOptions(this.config, Option::forgetPendingValue);
            this.m_7379_();
        } else {
            OptionUtils.forEachOptions(this.config, Option::requestSetDefault);
        }
    }

    public void undo() {
        OptionUtils.forEachOptions(this.config, Option::forgetPendingValue);
    }

    public void m_86600_() {
        Tab tab = this.tabManager.m_267695_();
        if (tab instanceof TabExt) {
            TabExt tabExt = (TabExt)tab;
            tabExt.m_267681_();
        }
        if ((tab = this.tabManager.m_267695_()) instanceof CategoryTab) {
            CategoryTab categoryTab = (CategoryTab)tab;
            if (this.saveButtonMessage != null) {
                if (this.saveButtonMessageTime > 140) {
                    this.saveButtonMessage = null;
                    this.saveButtonTooltipMessage = null;
                    this.saveButtonMessageTime = 0;
                } else {
                    ++this.saveButtonMessageTime;
                    categoryTab.saveFinishedButton.m_93666_(this.saveButtonMessage);
                    if (this.saveButtonTooltipMessage != null) {
                        categoryTab.saveFinishedButton.m_257544_(this.saveButtonTooltipMessage);
                    }
                }
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            this.m_7897_(true);
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.m_7222_() != null && this.m_7282_() && (button == 0 || button == 1) && this.m_7222_().m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public void setSaveButtonMessage(Component message, Component tooltip) {
        this.saveButtonMessage = message;
        this.saveButtonTooltipMessage = Tooltip.m_257550_((Component)tooltip);
        this.saveButtonMessageTime = 0;
    }

    public boolean pendingChanges() {
        return this.pendingChanges;
    }

    private void onOptionChanged(Option<?> option) {
        this.pendingChanges = false;
        OptionUtils.consumeOptions(this.config, opt -> {
            this.pendingChanges |= opt.changed();
            return this.pendingChanges;
        });
        Tab tab = this.tabManager.m_267695_();
        if (tab instanceof CategoryTab) {
            CategoryTab categoryTab = (CategoryTab)tab;
            categoryTab.updateButtons();
        }
    }

    public boolean m_6913_() {
        if (this.pendingChanges()) {
            this.setSaveButtonMessage((Component)Component.m_237115_((String)"yacl.gui.save_before_exit").m_130940_(ChatFormatting.RED), (Component)Component.m_237115_((String)"yacl.gui.save_before_exit.tooltip"));
            return false;
        }
        return true;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public static void renderMultilineTooltip(GuiGraphics graphics, Font font, MultiLineLabel text, int centerX, int yAbove, int yBelow, int screenWidth, int screenHeight) {
        if (text.m_5770_() > 0) {
            int maxWidth = text.m_214161_();
            Objects.requireNonNull(font);
            int lineHeight = 9 + 1;
            int height = text.m_5770_() * lineHeight - 1;
            int belowY = yBelow + 12;
            int aboveY = yAbove - height + 12;
            int maxBelow = screenHeight - (belowY + height);
            int minAbove = aboveY - height;
            int y = aboveY;
            if (minAbove < 8) {
                y = maxBelow > minAbove ? belowY : aboveY;
            }
            int x = Math.max(centerX - text.m_214161_() / 2 - 12, -6);
            int drawX = x + 12;
            int drawY = y - 12;
            graphics.m_280168_().m_85836_();
            TooltipRenderUtil.m_280205_((GuiGraphics)graphics, (int)drawX, (int)drawY, (int)maxWidth, (int)height, (int)400);
            graphics.m_280168_().m_85837_(0.0, 0.0, 400.0);
            text.m_6508_(graphics, drawX, drawY, lineHeight, -1);
            graphics.m_280168_().m_85849_();
        }
    }

    public static class CategoryTab
    implements TabExt {
        private final YACLScreen screen;
        private final ConfigCategory category;
        private final Tooltip tooltip;
        private ListHolderWidget<OptionListWidget> optionList;
        public final Button saveFinishedButton;
        public final Button cancelResetButton;
        public final Button undoButton;
        private final SearchFieldWidget searchField;
        private OptionDescriptionWidget descriptionWidget;
        private final ScreenRectangle rightPaneDim;

        public CategoryTab(YACLScreen screen, ConfigCategory category, ScreenRectangle tabArea) {
            this.screen = screen;
            this.category = category;
            this.tooltip = Tooltip.m_257550_((Component)category.tooltip());
            int columnWidth = screen.f_96543_ / 3;
            int padding = columnWidth / 20;
            columnWidth = Math.min(columnWidth, 400);
            int paddedWidth = columnWidth - padding * 2;
            this.rightPaneDim = new ScreenRectangle(screen.f_96543_ / 3 * 2, tabArea.m_274449_() + 1, screen.f_96543_ / 3, tabArea.f_263800_());
            MutableDimension<Integer> actionDim = Dimension.ofInt(screen.f_96543_ / 3 * 2 + screen.f_96543_ / 6, screen.f_96544_ - padding - 20, paddedWidth, 20);
            this.saveFinishedButton = Button.m_253074_((Component)Component.m_237113_((String)"Done"), btn -> screen.finishOrSave()).m_252794_((Integer)actionDim.x() - (Integer)actionDim.width() / 2, ((Integer)actionDim.y()).intValue()).m_253046_(((Integer)actionDim.width()).intValue(), ((Integer)actionDim.height()).intValue()).m_253136_();
            actionDim.expand(-((Integer)actionDim.width()).intValue() / 2 - 2, 0).move(-((Integer)actionDim.width()).intValue() / 2 - 2, -22);
            this.cancelResetButton = Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), btn -> screen.cancelOrReset()).m_252794_((Integer)actionDim.x() - (Integer)actionDim.width() / 2, ((Integer)actionDim.y()).intValue()).m_253046_(((Integer)actionDim.width()).intValue(), ((Integer)actionDim.height()).intValue()).m_253136_();
            actionDim.move((Integer)actionDim.width() + 4, 0);
            this.undoButton = Button.m_253074_((Component)Component.m_237115_((String)"yacl.gui.undo"), btn -> screen.undo()).m_252794_((Integer)actionDim.x() - (Integer)actionDim.width() / 2, ((Integer)actionDim.y()).intValue()).m_253046_(((Integer)actionDim.width()).intValue(), ((Integer)actionDim.height()).intValue()).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"yacl.gui.undo.tooltip"))).m_253136_();
            this.searchField = new SearchFieldWidget(screen, screen.f_96547_, screen.f_96543_ / 3 * 2 + screen.f_96543_ / 6 - paddedWidth / 2 + 1, this.undoButton.m_252907_() - 22, paddedWidth - 2, 18, (Component)Component.m_237115_((String)"gui.recipebook.search_hint"), (Component)Component.m_237115_((String)"gui.recipebook.search_hint"), searchQuery -> this.optionList.getList().updateSearchQuery((String)searchQuery));
            this.optionList = new ListHolderWidget<OptionListWidget>(() -> new ScreenRectangle(tabArea.f_263846_(), tabArea.f_263770_() / 3 * 2, tabArea.f_263800_()), new OptionListWidget(screen, category, screen.f_96541_, 0, 0, screen.f_96543_ / 3 * 2 + 1, screen.f_96544_, desc -> this.descriptionWidget.setOptionDescription((DescriptionWithName)desc)));
            this.descriptionWidget = new OptionDescriptionWidget(() -> new ScreenRectangle(screen.f_96543_ / 3 * 2 + padding, tabArea.m_274449_() + padding, paddedWidth, this.searchField.m_252907_() - 1 - tabArea.m_274449_() - padding * 2), null);
            this.updateButtons();
        }

        public Component m_267600_() {
            return this.category.name();
        }

        public void m_267609_(Consumer<AbstractWidget> consumer) {
            consumer.accept(this.optionList);
            consumer.accept((AbstractWidget)this.saveFinishedButton);
            consumer.accept((AbstractWidget)this.cancelResetButton);
            consumer.accept((AbstractWidget)this.undoButton);
            consumer.accept((AbstractWidget)this.searchField);
            consumer.accept(this.descriptionWidget);
        }

        public void m_267697_(ScreenRectangle screenRectangle) {
        }

        @Override
        public void m_267681_() {
            this.descriptionWidget.tick();
        }

        @Override
        @Nullable
        public Tooltip getTooltip() {
            return this.tooltip;
        }

        public void updateButtons() {
            boolean pendingChanges;
            this.undoButton.f_93623_ = pendingChanges = this.screen.pendingChanges();
            this.saveFinishedButton.m_93666_((Component)(pendingChanges ? Component.m_237115_((String)"yacl.gui.save") : GuiUtils.translatableFallback("yacl.gui.done", CommonComponents.f_130655_)));
            this.saveFinishedButton.m_257544_((Tooltip)new YACLTooltip((Component)(pendingChanges ? Component.m_237115_((String)"yacl.gui.save.tooltip") : Component.m_237115_((String)"yacl.gui.finished.tooltip")), (AbstractWidget)this.saveFinishedButton));
            this.cancelResetButton.m_93666_((Component)(pendingChanges ? GuiUtils.translatableFallback("yacl.gui.cancel", CommonComponents.f_130656_) : Component.m_237115_((String)"controls.reset")));
            this.cancelResetButton.m_257544_((Tooltip)new YACLTooltip((Component)(pendingChanges ? Component.m_237115_((String)"yacl.gui.cancel.tooltip") : Component.m_237115_((String)"yacl.gui.reset.tooltip")), (AbstractWidget)this.cancelResetButton));
        }
    }

    public static class PlaceholderTab
    implements TabExt {
        private final YACLScreen screen;
        private final PlaceholderCategory category;
        private final Tooltip tooltip;

        public PlaceholderTab(PlaceholderCategory category, YACLScreen screen) {
            this.screen = screen;
            this.category = category;
            this.tooltip = Tooltip.m_257550_((Component)category.tooltip());
        }

        public Component m_267600_() {
            return this.category.name();
        }

        public void m_267609_(Consumer<AbstractWidget> consumer) {
        }

        public void m_267697_(ScreenRectangle screenRectangle) {
            this.screen.f_96541_.m_91152_(this.category.screen().apply(this.screen.f_96541_, this.screen));
        }

        @Override
        @Nullable
        public Tooltip getTooltip() {
            return this.tooltip;
        }
    }
}

