/*
 * Decompiled with CFR 0.152.
 */
package curiousarmorstands;

import curiousarmorstands.ArmorStandCuriosDisplayLayer;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.client.render.CuriosLayer;

@Mod(value="curious_armor_stands")
public class CuriousArmorStands {
    public static final String MODID = "curious_armor_stands";
    public static final String SLOT = "curio";

    @Mod.EventBusSubscriber(modid="curious_armor_stands")
    public static class Events {
        @SubscribeEvent
        public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
            Entity entity;
            if (!event.getLevel().m_5776_() && (entity = event.getEntity()) instanceof ArmorStand) {
                ArmorStand armorStand = (ArmorStand)entity;
                CuriosApi.getSlotHelper().setSlotsForType(CuriousArmorStands.SLOT, (LivingEntity)armorStand, 8);
            }
        }

        @SubscribeEvent
        public static void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
            Entity entity = event.getTarget();
            if (entity instanceof ArmorStand) {
                ArmorStand armorStand = (ArmorStand)entity;
                ItemStack stack = event.getItemStack();
                if (!stack.m_41619_()) {
                    Events.equipItem(armorStand, stack, event);
                } else if (Events.canUnequipCurio(event.getLocalPos(), armorStand)) {
                    Events.unequipItem(armorStand, event);
                }
            }
        }

        public static void equipItem(ArmorStand armorStand, ItemStack stack, PlayerInteractEvent.EntityInteractSpecific event) {
            if (CuriosApi.getCuriosHelper().getCurioTags(stack.m_41720_()).isEmpty()) {
                return;
            }
            if (armorStand.m_9236_().m_5776_()) {
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
                return;
            }
            CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)armorStand).ifPresent(handler -> handler.getStacksHandler(CuriousArmorStands.SLOT).ifPresent(stacksHandler -> {
                IDynamicStackHandler cosmetics = stacksHandler.getCosmeticStacks();
                Optional curio = CuriosApi.getCuriosHelper().getCurio(stack).resolve();
                for (int slot = 0; slot < cosmetics.getSlots(); ++slot) {
                    SlotContext slotContext = new SlotContext(CuriousArmorStands.SLOT, (LivingEntity)armorStand, slot, true, true);
                    if (!cosmetics.getStackInSlot(slot).m_41619_() || !curio.isEmpty() && !((ICurio)curio.get()).canEquip(slotContext)) continue;
                    cosmetics.setStackInSlot(slot, stack.m_41777_());
                    if (curio.isPresent()) {
                        ((ICurio)curio.get()).playRightClickEquipSound((LivingEntity)armorStand);
                    } else {
                        armorStand.m_9236_().m_5594_(null, armorStand.m_20183_(), SoundEvents.f_11675_, armorStand.m_5720_(), 1.0f, 1.0f);
                    }
                    Events.enableArmorStandArms(armorStand, stack.m_41720_());
                    if (!event.getEntity().m_7500_()) {
                        int count = stack.m_41613_();
                        stack.m_41774_(count);
                    }
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                    return;
                }
            }));
        }

        public static void unequipItem(ArmorStand armorStand, PlayerInteractEvent.EntityInteractSpecific event) {
            CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)armorStand).ifPresent(handler -> handler.getStacksHandler(CuriousArmorStands.SLOT).ifPresent(stacksHandler -> {
                IDynamicStackHandler cosmetics = stacksHandler.getCosmeticStacks();
                for (int slot = cosmetics.getSlots() - 1; slot >= 0; --slot) {
                    ItemStack stackInSlot = cosmetics.getStackInSlot(slot);
                    if (stackInSlot.m_41619_()) continue;
                    if (!armorStand.m_9236_().m_5776_()) {
                        event.getEntity().m_21008_(event.getHand(), stackInSlot);
                        cosmetics.setStackInSlot(slot, ItemStack.f_41583_);
                    }
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                    return;
                }
            }));
        }

        private static void enableArmorStandArms(ArmorStand entity, Item item) {
            Set tags = CuriosApi.getCuriosHelper().getCurioTags(item);
            if (tags.contains("hands") || tags.contains("ring") || tags.contains("bracelet")) {
                entity.m_31675_(true);
            }
        }

        private static boolean canUnequipCurio(Vec3 localPos, ArmorStand entity) {
            double y;
            boolean isSmall = entity.m_31666_();
            double d = y = isSmall ? localPos.f_82480_ * 2.0 : localPos.f_82480_;
            return !(entity.m_21033_(EquipmentSlot.FEET) && y >= 0.1 && y < 0.1 + (isSmall ? 0.8 : 0.45) || entity.m_21033_(EquipmentSlot.CHEST) && y >= 0.9 + (isSmall ? 0.3 : 0.0) && y < 0.9 + (isSmall ? 1.0 : 0.7) || entity.m_21033_(EquipmentSlot.LEGS) && y >= 0.4 && y < 0.4 + (isSmall ? 1.0 : 0.8) || entity.m_21033_(EquipmentSlot.HEAD) && y >= 1.6 || entity.m_21033_(EquipmentSlot.MAINHAND) || entity.m_21033_(EquipmentSlot.OFFHAND));
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onAddLayers(EntityRenderersEvent.AddLayers event) {
            ResourceLocation strawStatueId = new ResourceLocation("strawstatues:straw_statue");
            if (BuiltInRegistries.f_256780_.m_7804_(strawStatueId)) {
                ClientModEvents.addLayer((EntityType)BuiltInRegistries.f_256780_.m_7745_(strawStatueId));
            }
            ClientModEvents.addLayer(EntityType.f_20529_);
        }

        private static void addLayer(EntityType<?> type) {
            EntityRenderer renderer = (EntityRenderer)Minecraft.m_91087_().m_91290_().f_114362_.get(type);
            try {
                ClientModEvents.addLayers((LivingEntityRenderer)ClientModEvents.cast(renderer));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }

        private static <E extends LivingEntity, M extends HumanoidModel<E>> void addLayers(LivingEntityRenderer<E, M> renderer) {
            renderer.m_115326_((RenderLayer)new CuriosLayer(renderer));
            renderer.m_115326_(new ArmorStandCuriosDisplayLayer<E, M>(renderer));
        }

        private static <T> T cast(Object object) {
            return (T)object;
        }
    }
}

