/*
 * Decompiled with CFR 0.152.
 */
package net.salju.trialstowers.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.salju.trialstowers.block.TrialVaultEntity;
import net.salju.trialstowers.init.TrialsBlockEntities;
import net.salju.trialstowers.init.TrialsItems;
import net.salju.trialstowers.init.TrialsProperties;
import net.salju.trialstowers.init.TrialsSounds;

public class TrialVaultBlock
extends BaseEntityBlock {
    public static final BooleanProperty ACTIVE = TrialsProperties.ACTIVE;
    public static final BooleanProperty EJECT = TrialsProperties.EJECT;
    private final boolean isOminous;

    public TrialVaultBlock(BlockBehaviour.Properties props, boolean check) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)EJECT, (Comparable)Boolean.valueOf(false)));
        this.isOminous = check;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ACTIVE});
        builder.m_61104_(new Property[]{EJECT});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rez) {
        BlockEntity entity = world.m_7702_(pos);
        ItemStack stack = player.m_21120_(hand);
        if (entity instanceof TrialVaultEntity) {
            TrialVaultEntity target = (TrialVaultEntity)entity;
            if (this.isActive(state) && !this.isEjecting(state) && stack.m_150930_(this.isOminous ? (Item)TrialsItems.TRIAL_KEY_OMNI.get() : (Item)TrialsItems.TRIAL_KEY.get())) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)EJECT, (Comparable)Boolean.valueOf(true)), 3);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                if (world instanceof ServerLevel) {
                    ServerLevel lvl = (ServerLevel)world;
                    lvl.m_5594_(null, pos, (SoundEvent)TrialsSounds.VAULT_INSERT_KEY.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int i, int e) {
        return world.m_7702_(pos) == null ? super.m_8133_(state, world, pos, i, e) : world.m_7702_(pos).m_7531_(i, e);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        TrialVaultEntity vault = new TrialVaultEntity(pos, state);
        vault.setVault(this.isOminous);
        return vault;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return TrialVaultBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)TrialsBlockEntities.VAULT.get()), TrialVaultEntity::tick);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean isActive(BlockState state) {
        return (Boolean)state.m_61143_((Property)ACTIVE);
    }

    public boolean isEjecting(BlockState state) {
        return (Boolean)state.m_61143_((Property)EJECT);
    }
}

