/*
 * Decompiled with CFR 0.152.
 */
package net.salju.trialstowers.block;

import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.salju.trialstowers.Trials;
import net.salju.trialstowers.block.TrialSpawnerBlock;
import net.salju.trialstowers.events.TrialsManager;
import net.salju.trialstowers.init.TrialsBlockEntities;
import net.salju.trialstowers.init.TrialsEffects;
import net.salju.trialstowers.init.TrialsItems;
import net.salju.trialstowers.init.TrialsSounds;
import net.salju.trialstowers.init.TrialsTags;

public class TrialSpawnerEntity
extends BlockEntity {
    private String table;
    private ItemStack egg;
    private List<UUID> mobs = Lists.newArrayList();
    private boolean isActive;
    private int d;
    private int cd;
    private int e;
    private int k;
    private boolean disableEffects;

    public TrialSpawnerEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TrialsBlockEntities.SPAWNER.get(), pos, state);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.table != null) {
            tag.m_128359_("LootTable", this.table);
        }
        if (this.egg != null) {
            tag.m_128365_("SpawnEgg", (Tag)this.egg.m_41739_(new CompoundTag()));
        }
        tag.m_128379_("DisableEffects", this.disableEffects);
        tag.m_128379_("isActive", this.isActive);
        tag.m_128405_("Difficulty", this.d);
        tag.m_128405_("Cooldown", this.cd);
        tag.m_128405_("Enemies", this.e);
        tag.m_128405_("Killed", this.k);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("LootTable")) {
            this.table = tag.m_128461_("LootTable");
        }
        if (tag.m_128441_("SpawnEgg")) {
            this.egg = ItemStack.m_41712_((CompoundTag)tag.m_128469_("SpawnEgg"));
        }
        this.disableEffects = tag.m_128471_("DisableEffects");
        this.isActive = tag.m_128471_("isActive");
        this.d = tag.m_128451_("Difficulty");
        this.cd = tag.m_128451_("Cooldown");
        this.e = tag.m_128451_("Enemies");
        this.k = tag.m_128451_("Killed");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection queen, ClientboundBlockEntityDataPacket packet) {
        if (packet != null && packet.m_131708_() != null) {
            if (packet.m_131708_().m_128441_("LootTable")) {
                this.table = packet.m_131708_().m_128461_("LootTable");
            }
            if (packet.m_131708_().m_128441_("SpawnEgg")) {
                this.egg = ItemStack.m_41712_((CompoundTag)packet.m_131708_().m_128469_("SpawnEgg"));
            }
            this.disableEffects = packet.m_131708_().m_128471_("DisableEffects");
            this.isActive = packet.m_131708_().m_128471_("isActive");
            this.d = packet.m_131708_().m_128451_("Difficulty");
            this.cd = packet.m_131708_().m_128451_("Cooldown");
            this.e = packet.m_131708_().m_128451_("Enemies");
            this.k = packet.m_131708_().m_128451_("Killed");
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        if (this.table != null) {
            tag.m_128359_("LootTable", this.table);
        }
        if (this.egg != null) {
            tag.m_128365_("SpawnEgg", (Tag)this.egg.m_41739_(new CompoundTag()));
        }
        tag.m_128379_("DisableEffects", this.disableEffects);
        tag.m_128379_("isActive", this.isActive);
        tag.m_128405_("Difficulty", this.d);
        tag.m_128405_("Cooldown", this.cd);
        tag.m_128405_("Enemies", this.e);
        tag.m_128405_("Killed", this.k);
        return tag;
    }

    public static void tick(Level world, BlockPos pos, BlockState state, TrialSpawnerEntity target) {
        Block block = state.m_60734_();
        if (block instanceof TrialSpawnerBlock) {
            TrialSpawnerBlock block2 = (TrialSpawnerBlock)block;
            if (target.getSpawnType() != null && world.m_46791_() != Difficulty.PEACEFUL) {
                target.updateBlock();
                if (world instanceof ServerLevel) {
                    ServerLevel lvl = (ServerLevel)world;
                    if (block2.isActive(state)) {
                        lvl.m_8767_((ParticleOptions)(block2.isCursed(state) ? ParticleTypes.f_123745_ : ParticleTypes.f_123744_), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1, 0.12, 0.12, 0.12, 0.0);
                        if (target.isActivelySpawning()) {
                            if (target.getRemainingEnemies() != 0) {
                                TrialSpawnerEntity.checkPlayer(lvl, pos, state, target);
                                if (target.getTotalEnemies() > 0) {
                                    if (target.getCd() != 0) {
                                        target.setCd(target.getCd() - 1);
                                    } else if (target.getRemainingEnemies() == target.getTotalEnemies()) {
                                        target.setCd(80);
                                        int e = target.getDifficulty() >= 101 ? 3 : 2;
                                        target.setTotalEnemies(target.getTotalEnemies() - e);
                                        lvl.m_5594_(null, pos, (SoundEvent)TrialsSounds.SPAWNER_SUMMON.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                                        for (int i = 0; i != e; ++i) {
                                            TrialSpawnerEntity.setUpMob(target, target.getSpawnType(), lvl, target.getDifficulty(), target.findSpawnPositionNear(target.getSpawnType(), lvl, pos.m_7494_(), 2, world.m_213780_()), target.egg);
                                        }
                                    }
                                }
                            } else if (block2.isEjecting(state)) {
                                if (target.getCd() != 0) {
                                    target.setCd(target.getCd() - 1);
                                } else {
                                    target.setActivity(false);
                                    target.setCd(36000);
                                    lvl.m_5594_(null, pos, (SoundEvent)TrialsSounds.SPAWNER_CLOSE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                                    world.m_7731_(pos, (BlockState)((BlockState)((BlockState)state.m_61124_((Property)TrialSpawnerBlock.ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TrialSpawnerBlock.EJECT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TrialSpawnerBlock.CURSED, (Comparable)Boolean.valueOf(false)), 3);
                                }
                            } else {
                                target.setCd(40);
                                Trials.queueServerWork(20, () -> {
                                    lvl.m_5594_(null, pos, (SoundEvent)TrialsSounds.SPAWNER_ITEM.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                                    for (ItemStack stack : TrialsManager.getLoot(target, world, target.getLootTable(block2.isCursed(state)))) {
                                        Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)((double)pos.m_123342_() + 1.0), (double)pos.m_123343_(), (ItemStack)stack);
                                    }
                                });
                                lvl.m_5594_(null, pos, (SoundEvent)TrialsSounds.SPAWNER_OPEN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                                world.m_7731_(pos, (BlockState)state.m_61124_((Property)TrialSpawnerBlock.EJECT, (Comparable)Boolean.valueOf(true)), 3);
                            }
                        } else {
                            Player player = lvl.m_45924_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 8.0, false);
                            if (player != null && !player.m_7500_() && !player.m_5833_() && TrialSpawnerEntity.canSpawn(lvl, pos, player)) {
                                int i = 0;
                                if (player.m_21023_(MobEffects.f_19594_)) {
                                    player.m_7292_(new MobEffectInstance((MobEffect)TrialsEffects.CURSED.get(), 12000, player.m_21124_(MobEffects.f_19594_).m_19564_()));
                                    player.m_21195_(MobEffects.f_19594_);
                                }
                                for (Player players : lvl.m_8795_(LivingEntity::m_6084_)) {
                                    if (!players.isCloseEnough((Entity)player, 32.0) || players.m_7500_() || players.m_5833_()) continue;
                                    ++i;
                                }
                                lvl.m_5594_(null, pos, (SoundEvent)TrialsSounds.SPAWNER_DETECT_PLAYER.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                                if (player.m_21023_((MobEffect)TrialsEffects.CURSED.get())) {
                                    target.setDifficulty(Mth.m_216271_((RandomSource)world.m_213780_(), (int)101, (int)200));
                                    i = 6 + i * 3 + player.m_21124_((MobEffect)TrialsEffects.CURSED.get()).m_19564_() * 3;
                                    world.m_7731_(pos, (BlockState)state.m_61124_((Property)TrialSpawnerBlock.CURSED, (Comparable)Boolean.valueOf(true)), 3);
                                    lvl.m_8767_((ParticleOptions)ParticleTypes.f_123745_, (double)pos.m_123341_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_(), 8, 0.1, 0.1, 0.1, 0.0);
                                    lvl.m_8767_((ParticleOptions)ParticleTypes.f_123745_, (double)pos.m_123341_() + 1.0, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_(), 8, 0.1, 0.1, 0.1, 0.0);
                                    lvl.m_8767_((ParticleOptions)ParticleTypes.f_123745_, (double)pos.m_123341_() + 1.0, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 1.0, 8, 0.1, 0.1, 0.1, 0.0);
                                    lvl.m_8767_((ParticleOptions)ParticleTypes.f_123745_, (double)pos.m_123341_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 1.0, 8, 0.1, 0.1, 0.1, 0.0);
                                } else {
                                    i = 4 + i * 2;
                                    target.setDifficulty(Mth.m_216271_((RandomSource)world.m_213780_(), (int)1, (int)100));
                                    lvl.m_8767_((ParticleOptions)ParticleTypes.f_123744_, (double)pos.m_123341_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_(), 8, 0.1, 0.1, 0.1, 0.0);
                                    lvl.m_8767_((ParticleOptions)ParticleTypes.f_123744_, (double)pos.m_123341_() + 1.0, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_(), 8, 0.1, 0.1, 0.1, 0.0);
                                    lvl.m_8767_((ParticleOptions)ParticleTypes.f_123744_, (double)pos.m_123341_() + 1.0, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 1.0, 8, 0.1, 0.1, 0.1, 0.0);
                                    lvl.m_8767_((ParticleOptions)ParticleTypes.f_123744_, (double)pos.m_123341_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 1.0, 8, 0.1, 0.1, 0.1, 0.0);
                                }
                                target.setActivity(true);
                                target.setTotalEnemies(i);
                                target.setRemainingEnemies(i);
                                target.setCd(20);
                            }
                        }
                    } else {
                        lvl.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.95, (double)pos.m_123343_() + 0.5, 1, 0.12, 0.12, 0.12, 0.0);
                        if (target.getCd() != 0) {
                            target.setCd(target.getCd() - 1);
                        } else {
                            world.m_7731_(pos, (BlockState)state.m_61124_((Property)TrialSpawnerBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
                        }
                    }
                }
            }
        }
    }

    public static boolean canSpawn(ServerLevel lvl, BlockPos pos, Player player) {
        boolean check = true;
        for (BlockPos checkpos : BlockPos.m_121940_((BlockPos)pos.m_7494_(), (BlockPos)player.m_20183_().m_7494_())) {
            BlockState checkstate = lvl.m_8055_(checkpos);
            if (!checkstate.m_60815_()) continue;
            check = false;
            break;
        }
        return check;
    }

    public static void checkPlayer(ServerLevel lvl, BlockPos pos, BlockState state, TrialSpawnerEntity target) {
        Player player = lvl.m_45924_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 64.0, false);
        if (player != null) {
            List<UUID> list = target.getMobs();
            if (!list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    Mob mobster;
                    Entity entity;
                    if (lvl.m_8791_(list.get(i)) != null && (!((entity = lvl.m_8791_(list.get(i))) instanceof Mob) || (mobster = (Mob)entity).m_6084_())) continue;
                    target.setRemainingEnemies(target.getRemainingEnemies() - 1);
                    target.removeUUID(i);
                }
            }
        } else {
            TrialSpawnerEntity.shutOff(lvl, pos, state, target);
        }
    }

    public static void shutOff(ServerLevel lvl, BlockPos pos, BlockState state, TrialSpawnerEntity target) {
        target.setActivity(false);
        target.setRemainingEnemies(0);
        target.setTotalEnemies(0);
        target.setCd(12000);
        lvl.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)TrialSpawnerBlock.ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TrialSpawnerBlock.CURSED, (Comparable)Boolean.valueOf(false)), 3);
    }

    public static void setUpMob(TrialSpawnerEntity spawner, EntityType<?> type, ServerLevel lvl, int i, BlockPos pos, ItemStack egg) {
        Entity entity = type.m_20592_(lvl, egg, null, pos, MobSpawnType.SPAWNER, false, false);
        lvl.m_8767_((ParticleOptions)(i >= 101 ? ParticleTypes.f_123745_ : ParticleTypes.f_123744_), (double)pos.m_123341_(), (double)pos.m_123342_() + 1.05, (double)pos.m_123343_(), 12, 0.45, 0.25, 0.45, 0.0);
        entity.m_20219_(Vec3.m_82539_((Vec3i)pos));
        if (entity instanceof Mob) {
            Mob target = (Mob)entity;
            spawner.addUUID(target.m_20148_());
            target.m_21530_();
            target.getPersistentData().m_128379_("TrialSpawned", true);
            target.m_21553_(false);
            target.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
            target.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
            target.m_21409_(EquipmentSlot.HEAD, 0.0f);
            target.m_21409_(EquipmentSlot.CHEST, 0.0f);
            target.m_21409_(EquipmentSlot.LEGS, 0.0f);
            target.m_21409_(EquipmentSlot.FEET, 0.0f);
            if (!spawner.disableEffects) {
                if (target.m_6095_().m_204039_(TrialsTags.ARMORABLE) && i > 65) {
                    if (LocalDate.now().get(ChronoField.DAY_OF_MONTH) == 31 && LocalDate.now().get(ChronoField.MONTH_OF_YEAR) == 10) {
                        target.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)(Math.random() <= 0.1 ? Blocks.f_50144_ : Blocks.f_50143_)));
                    } else if (Math.random() >= 0.25) {
                        target.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)(i >= 101 ? Items.f_42472_ : Items.f_42468_)));
                    }
                    if (Math.random() >= 0.65) {
                        target.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)(i >= 101 ? Items.f_42473_ : Items.f_42469_)));
                    }
                    if (Math.random() >= 0.54) {
                        target.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)(i >= 101 ? Items.f_42474_ : Items.f_42470_)));
                    }
                    if (Math.random() >= 0.45) {
                        target.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)(i >= 101 ? Items.f_42475_ : Items.f_42471_)));
                    }
                    Holder.Reference<TrimMaterial> m = TrialSpawnerEntity.getTrim(lvl);
                    for (ItemStack armor : target.m_6168_()) {
                        if (!armor.m_204117_(ItemTags.f_265942_)) continue;
                        ArmorTrim.m_266570_((RegistryAccess)lvl.m_9598_(), (ItemStack)armor, (ArmorTrim)new ArmorTrim(m, (Holder)TrimPatterns.m_266468_((RegistryAccess)lvl.m_9598_(), (ItemStack)new ItemStack(i <= 1 ? (ItemLike)TrialsItems.FLOW_TEMPLATE.get() : (ItemLike)TrialsItems.BOLT_TEMPLATE.get())).get()));
                    }
                }
                if (target instanceof Zombie) {
                    if ((i > 76 || i < 21) && Math.random() >= 0.45) {
                        target.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42383_));
                    }
                    if (i >= 101) {
                        if (target instanceof Drowned && Math.random() >= 0.45) {
                            target.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42713_));
                        } else if (Math.random() >= 0.65) {
                            target.m_7292_(new MobEffectInstance((MobEffect)TrialsEffects.OOZE.get(), 12000, 0));
                        }
                    }
                } else if (target instanceof AbstractSkeleton) {
                    target.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42411_));
                    if (i >= 101 && Math.random() >= 0.65) {
                        target.m_7292_(new MobEffectInstance((MobEffect)TrialsEffects.INFESTED.get(), 12000, 0));
                    }
                } else if (target instanceof Spider) {
                    if (i >= 101) {
                        if (Math.random() >= 0.65) {
                            target.m_7292_(new MobEffectInstance((MobEffect)TrialsEffects.WEAVE.get(), 12000, 0));
                        }
                        target.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 12000, 0));
                        target.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 12000, 0));
                        target.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 12000, 0));
                        target.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 12000, 0));
                    } else if (i > 90) {
                        target.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 12000, 0));
                    } else if (i > 75) {
                        target.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 12000, 0));
                    } else if (i < 10) {
                        target.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 12000, 0));
                    } else if (i < 25) {
                        target.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 12000, 0));
                    }
                } else if (target instanceof AbstractIllager) {
                    ((GroundPathNavigation)target.m_21573_()).m_26477_(true);
                    if (i >= 101) {
                        if (Math.random() >= 0.65) {
                            target.m_7292_(new MobEffectInstance((MobEffect)TrialsEffects.WINDED.get(), 12000, 0));
                        }
                        target.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 12000, 0));
                        target.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 12000, 0));
                    } else if (i > 75) {
                        target.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 12000, 0));
                    } else if (i < 45) {
                        target.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 12000, 0));
                    }
                    if (target instanceof Pillager) {
                        target.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42717_));
                    } else if (target instanceof Vindicator) {
                        target.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42386_));
                    }
                } else if (target instanceof Vex) {
                    target.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42383_));
                    target.m_21559_(false);
                } else if (target instanceof Slime) {
                    Slime slym = (Slime)target;
                    if (i >= 101) {
                        slym.m_7839_(3, true);
                    } else {
                        slym.m_7839_(2, true);
                    }
                } else {
                    target.m_6518_((ServerLevelAccessor)lvl, new DifficultyInstance(lvl.m_46791_(), 5L, 5L, 1.0f), MobSpawnType.SPAWNER, null, null);
                }
            }
        }
    }

    public static Holder.Reference<TrimMaterial> getTrim(ServerLevel lvl) {
        int i = Mth.m_216271_((RandomSource)lvl.m_213780_(), (int)0, (int)7);
        List<Item> list = TrialSpawnerEntity.getMats();
        return (Holder.Reference)TrimMaterials.m_266539_((RegistryAccess)lvl.m_9598_(), (ItemStack)new ItemStack((ItemLike)list.get(i))).get();
    }

    private static List<Item> getMats() {
        ArrayList list = Lists.newArrayList();
        list.add(Items.f_151052_);
        list.add(Items.f_42416_);
        list.add(Items.f_42417_);
        list.add(Items.f_42534_);
        list.add(Items.f_42451_);
        list.add(Items.f_151049_);
        list.add(Items.f_42616_);
        list.add(Items.f_42415_);
        return list;
    }

    @Nullable
    public EntityType<?> getSpawnType() {
        Item item;
        if (this.egg != null && (item = this.egg.m_41720_()) instanceof SpawnEggItem) {
            SpawnEggItem item2 = (SpawnEggItem)item;
            return item2.m_43228_(this.egg.m_41783_());
        }
        return null;
    }

    public String getLootTable(boolean check) {
        if (this.table != null) {
            return this.table;
        }
        return check ? "trials:gameplay/spawner_special_loot" : "trials:gameplay/spawner_loot";
    }

    public BlockPos findSpawnPositionNear(EntityType<?> type, ServerLevel lvl, BlockPos old, int range, RandomSource random) {
        BlockPos pos = old;
        for (int i = 0; i < 25; ++i) {
            int z;
            int y;
            int x = old.m_123341_() + random.m_188503_(range * 2) - range;
            BlockPos test = new BlockPos(x, y = old.m_123342_() + random.m_188503_(range * 2) - range, z = old.m_123343_() + random.m_188503_(range * 2) - range);
            if (!lvl.m_45772_(type.m_20585_((double)test.m_123341_(), (double)test.m_123342_(), (double)test.m_123343_()))) continue;
            pos = test;
            break;
        }
        return BlockPos.m_274561_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
    }

    public void addUUID(UUID id) {
        this.mobs.add(id);
    }

    public void removeUUID(int i) {
        this.mobs.remove(i);
    }

    public void setEgg(ItemStack stack) {
        this.egg = stack;
    }

    public List<UUID> getMobs() {
        return this.mobs;
    }

    public boolean isActivelySpawning() {
        return this.isActive;
    }

    public int getDifficulty() {
        return this.d;
    }

    public int getCd() {
        return this.cd;
    }

    public int getTotalEnemies() {
        return this.e;
    }

    public int getRemainingEnemies() {
        return this.k;
    }

    public void setActivity(boolean check) {
        this.isActive = check;
    }

    public void setDifficulty(int i) {
        this.d = i;
    }

    public void setCd(int i) {
        this.cd = i;
    }

    public void setTotalEnemies(int i) {
        this.e = i;
    }

    public void setRemainingEnemies(int i) {
        this.k = i;
    }

    public void updateBlock() {
        this.m_6596_();
        this.m_58904_().m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }
}

