/*
 * Decompiled with CFR 0.152.
 */
package cool.bot.dewdropwateringcans.item.wateringCan;

import cool.bot.botslib.util.Util;
import cool.bot.dewdropwateringcans.Config;
import cool.bot.dewdropwateringcans.event.WateringCanFailEvent;
import cool.bot.dewdropwateringcans.event.WateringCanFillEvent;
import cool.bot.dewdropwateringcans.event.WateringCanPourEvent;
import cool.bot.dewdropwateringcans.event.WateringCanSuperEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class WateringCanItem
extends Item {
    private int cooldown;
    private int requiredCharge;
    private int maxSuperLevel;
    private int chargePerLevel;
    private static final int USE_DURATION = 72000;

    public WateringCanItem(Item.Properties properties, int requiredCharge, int cooldown, int maxSuperLevel) {
        super(properties);
        this.requiredCharge = requiredCharge;
        this.cooldown = cooldown;
        this.maxSuperLevel = maxSuperLevel;
        this.chargePerLevel = maxSuperLevel >= 1 ? requiredCharge / maxSuperLevel : 0;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_142159_(ItemStack pStack) {
        return Mth.m_14169_((float)0.6f, (float)1.0f, (float)1.0f);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (level.m_5776_()) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
        }
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6117_()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (player.m_36335_().m_41519_((Item)this)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (player.m_6047_() && this.maxSuperLevel >= 1) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        BlockPos pos = Util.blockHighlightedOrNull((Player)player);
        if (pos == null) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        BlockState blockState = level.m_8055_(pos);
        if (blockState.m_60819_().m_205070_(FluidTags.f_13131_)) {
            MinecraftForge.EVENT_BUS.post((Event)new WateringCanFillEvent((ServerLevel)level, (ServerPlayer)player, stack));
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        if (player.m_20154_().m_7098_() > 0.0) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (stack.m_41773_() >= stack.m_41776_() && !player.m_7500_()) {
            MinecraftForge.EVENT_BUS.post((Event)new WateringCanFailEvent((ServerLevel)level, (ServerPlayer)player, stack));
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (level.m_8055_(pos.m_7494_()).m_60804_((BlockGetter)level, pos.m_7494_())) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        MinecraftForge.EVENT_BUS.post((Event)new WateringCanPourEvent((ServerLevel)level, (ServerPlayer)player, stack, pos, blockState, false));
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (level.m_5776_()) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.m_20154_().m_7098_() > 0.0) {
            return;
        }
        BlockPos pos = Util.blockHighlightedOrNull((Player)player);
        if (pos == null) {
            return;
        }
        int useDuration = this.m_8105_(stack) - timeLeft;
        if (useDuration < this.chargePerLevel) {
            return;
        }
        int superLevelToUse = Math.floorDiv(useDuration, this.chargePerLevel);
        if (superLevelToUse > this.maxSuperLevel) {
            superLevelToUse = this.maxSuperLevel;
        }
        AABB area = this.getAreaForSuper(superLevelToUse, player, pos);
        MinecraftForge.EVENT_BUS.post((Event)new WateringCanSuperEvent((ServerLevel)level, (ServerPlayer)player, stack, area, this.maxSuperLevel));
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack stack, int timeLeft) {
        if (level.m_5776_()) {
            return;
        }
        int useDuration = this.m_8105_(stack) - timeLeft;
        Player player = (Player)livingEntity;
        if (useDuration == this.chargePerLevel || useDuration % this.chargePerLevel == 0 && useDuration <= this.chargePerLevel * this.maxSuperLevel && useDuration > 0) {
            player.m_6330_(SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (useDuration % 8 != 0) {
            return;
        }
        int superLevelToUse = Math.floorDiv(useDuration, this.chargePerLevel);
        if (superLevelToUse > this.maxSuperLevel) {
            superLevelToUse = this.maxSuperLevel;
        }
        if (superLevelToUse <= 0) {
            return;
        }
        BlockPos pos = Util.blockHighlightedOrNull((Player)player);
        if (pos == null) {
            return;
        }
        AABB area = this.getAreaForSuper(superLevelToUse, player, pos);
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos.m_121921_((AABB)area).forEach(bp -> {
            double yoff = level.m_8055_(bp).m_60795_() ? -1.0 + level.m_8055_(bp.m_7495_()).m_60808_((BlockGetter)level, bp.m_7495_()).m_83297_(Direction.Axis.Y) + 0.1 : level.m_8055_(bp).m_60808_((BlockGetter)level, bp).m_83297_(Direction.Axis.Y) + 0.1;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123749_, (double)bp.m_123341_() + 0.5, (double)bp.m_123342_() + yoff, (double)bp.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        });
    }

    private AABB getAreaForSuper(int superLevelToUse, Player player, BlockPos pos) {
        int forward = 0;
        int back = 0;
        int left = 0;
        int right = 0;
        switch (superLevelToUse) {
            case 1: {
                forward = Config.super1forward;
                back = Config.super1back;
                left = Config.super1left;
                right = Config.super1right;
                break;
            }
            case 2: {
                forward = Config.super2forward;
                back = Config.super2back;
                left = Config.super2left;
                right = Config.super2right;
                break;
            }
            case 3: {
                forward = Config.super3forward;
                back = Config.super3back;
                left = Config.super3left;
                right = Config.super3right;
                break;
            }
            case 4: {
                forward = Config.super4forward;
                back = Config.super4back;
                left = Config.super4left;
                right = Config.super4right;
                break;
            }
        }
        Direction facing = player.m_6350_();
        BlockPos start = pos;
        BlockPos end = pos;
        switch (facing) {
            case NORTH: {
                start = pos.m_7918_(-left, 0, -forward);
                end = pos.m_7918_(right, 0, back);
                break;
            }
            case SOUTH: {
                start = pos.m_7918_(-right, 0, -back);
                end = pos.m_7918_(left, 0, forward);
                break;
            }
            case WEST: {
                start = pos.m_7918_(-forward, 0, right);
                end = pos.m_7918_(back, 0, -left);
                break;
            }
            case EAST: {
                start = pos.m_7918_(forward, 0, -right);
                end = pos.m_7918_(-back, 0, left);
                break;
            }
        }
        return new AABB(start, end);
    }
}

