/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.gallery.core;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class GalleryConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (Common)commonSpecPair.getLeft();
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Boolean> paintingsDropVariants;
        public final ForgeConfigSpec.ConfigValue<Boolean> requiresShears;
        public final ForgeConfigSpec.ConfigValue<Boolean> requiresSilkTouch;
        public final ForgeConfigSpec.ConfigValue<Boolean> paintingSelector;
        public final ForgeConfigSpec.ConfigValue<Boolean> paintingSelectorRequiresCrouching;
        public final ForgeConfigSpec.ConfigValue<Boolean> paintingSelectorOpensOnBlocks;

        Common(ForgeConfigSpec.Builder builder) {
            builder.push("paintings");
            builder.push("painting_drops");
            this.paintingsDropVariants = builder.comment("If Paintings drop their variants when broken").define("Paintings drop variants", true);
            this.requiresShears = builder.comment("If Paintings only drop their variants when broken with Shears").define("Paintings drop variants with Shears", true);
            this.requiresSilkTouch = builder.comment("If Paintings only drop their variants when broken with Silk Touch").define("Paintings drop variants with Silk Touch", true);
            builder.pop();
            builder.push("painting_selector");
            this.paintingSelector = builder.comment("If right-clicking with a Painting item opens up a Painting selector menu").define("Painting selector", true);
            this.paintingSelectorRequiresCrouching = builder.comment("If you must be crouching to open the Painting selector").define("Painting selector requires crouching", false);
            this.paintingSelectorOpensOnBlocks = builder.comment("If the Painting selector can be opened while right-clicking the top or bottom face of a block").define("Painting selector can open on blocks", true);
            builder.pop();
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<Boolean> paintingIcons;
        public boolean paintingIconsEnabled;

        Client(ForgeConfigSpec.Builder builder) {
            builder.push("paintings");
            this.paintingIcons = builder.comment("If Paintings have item icons").define("Painting icons", true);
            builder.pop();
        }

        public void load() {
            this.paintingIconsEnabled = (Boolean)this.paintingIcons.get();
        }
    }
}

