/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.utils.typeadapter;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import me.pandamods.joml.Matrix4f;
import me.pandamods.joml.Matrix4fc;
import me.pandamods.joml.Quaternionf;
import me.pandamods.joml.Vector3f;
import me.pandamods.joml.Vector3fc;
import me.pandamods.pandalib.utils.typeadapter.QuaternionfTypeAdapter;

public class Matrix4fTypeAdapter
extends TypeAdapter<Matrix4fc> {
    public void write(JsonWriter jsonWriter, Matrix4fc matrix4fc) throws IOException {
        jsonWriter.beginObject();
        jsonWriter.name("position");
        this.writeVector(jsonWriter, matrix4fc.getTranslation(new Vector3f()));
        jsonWriter.name("rotation");
        QuaternionfTypeAdapter.writeQuaternion(jsonWriter, matrix4fc.getUnnormalizedRotation(new Quaternionf()));
        jsonWriter.name("scale");
        this.writeVector(jsonWriter, matrix4fc.getScale(new Vector3f()));
        jsonWriter.endObject();
    }

    private void writeVector(JsonWriter jsonWriter, Vector3fc vector) throws IOException {
        jsonWriter.beginArray();
        jsonWriter.value(vector.x());
        jsonWriter.value(vector.y());
        jsonWriter.value(vector.z());
        jsonWriter.endArray();
    }

    public Matrix4fc read(JsonReader jsonReader) throws IOException {
        Vector3f translation = null;
        Quaternionf rotation = null;
        Vector3f scale = null;
        jsonReader.beginObject();
        block10: while (jsonReader.hasNext()) {
            String name;
            switch (name = jsonReader.nextName()) {
                case "position": {
                    translation = this.readVector(jsonReader);
                    continue block10;
                }
                case "rotation": {
                    rotation = new Quaternionf(QuaternionfTypeAdapter.readQuaternion(jsonReader));
                    continue block10;
                }
                case "scale": {
                    scale = this.readVector(jsonReader);
                    continue block10;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return new Matrix4f().identity().translationRotateScale(translation, rotation, scale);
    }

    private Vector3f readVector(JsonReader jsonReader) throws IOException {
        jsonReader.beginArray();
        float x = (float)jsonReader.nextDouble();
        float y = (float)jsonReader.nextDouble();
        float z = (float)jsonReader.nextDouble();
        jsonReader.endArray();
        return new Vector3f(x, y, z);
    }
}

