/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class NBTUtils {
    public static Tag convertJsonToTag(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            JsonPrimitive primitive = jsonElement.getAsJsonPrimitive();
            if (primitive.isString()) {
                return StringTag.m_129297_((String)primitive.getAsString());
            }
            if (primitive.isNumber()) {
                return DoubleTag.m_128500_((double)primitive.getAsDouble());
            }
            if (primitive.isBoolean()) {
                return ByteTag.m_128273_((boolean)primitive.getAsBoolean());
            }
        } else {
            if (jsonElement.isJsonArray()) {
                JsonArray array = jsonElement.getAsJsonArray();
                ListTag list = new ListTag();
                array.forEach(element -> list.add((Object)NBTUtils.convertJsonToTag(element)));
                return list;
            }
            if (jsonElement.isJsonObject()) {
                CompoundTag compound = new CompoundTag();
                JsonObject object = jsonElement.getAsJsonObject();
                object.entrySet().forEach(entry -> compound.m_128365_((String)entry.getKey(), NBTUtils.convertJsonToTag((JsonElement)entry.getValue())));
                return compound;
            }
        }
        return null;
    }

    public static JsonElement convertTagToJson(Tag tag) {
        if (tag instanceof StringTag) {
            return new JsonPrimitive(tag.m_7916_());
        }
        if (tag instanceof DoubleTag) {
            return new JsonPrimitive((Number)((DoubleTag)tag).m_7061_());
        }
        if (tag instanceof ByteTag) {
            ByteTag byteTag = (ByteTag)tag;
            return new JsonPrimitive(Boolean.valueOf(byteTag == ByteTag.f_128257_));
        }
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            JsonObject object = new JsonObject();
            compoundTag.m_128431_().forEach(key -> object.add(key, NBTUtils.convertTagToJson(compoundTag.m_128423_(key))));
            return object;
        }
        if (tag instanceof ListTag) {
            ListTag listTag = (ListTag)tag;
            JsonArray array = new JsonArray();
            listTag.forEach(element -> array.add(NBTUtils.convertTagToJson(element)));
            return array;
        }
        return null;
    }
}

