/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.blocks;

import com.blackgear.vanillabackport.client.level.particles.particleoptions.TrailParticleOption;
import com.blackgear.vanillabackport.client.registries.ModSoundEvents;
import com.blackgear.vanillabackport.common.level.blocks.CreakingHeartBlock;
import com.blackgear.vanillabackport.common.registries.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class EyeblossomBlock
extends FlowerBlock {
    private final Type type;

    public EyeblossomBlock(Type type, BlockBehaviour.Properties properties) {
        super(type.effect, type.effectDuration, properties);
        this.type = type;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockState floorState;
        if (this.type.emitSounds() && random.m_188503_(700) == 0 && (floorState = level.m_8055_(pos.m_7495_())).m_60713_(ModBlocks.PALE_MOSS_BLOCK.get())) {
            level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), ModSoundEvents.EYEBLOSSOM_IDLE.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.tryChangingState(state, level, pos, random)) {
            level.m_5594_(null, pos, this.type.transform().longSwitchSound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        super.m_213898_(state, level, pos, random);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.tryChangingState(state, level, pos, random)) {
            level.m_5594_(null, pos, this.type.transform().shortSwitchSound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        super.m_213897_(state, level, pos, random);
    }

    private boolean tryChangingState(BlockState state, ServerLevel level, BlockPos origin, RandomSource random) {
        if (!level.m_6042_().f_63858_()) {
            return false;
        }
        if (CreakingHeartBlock.isNaturalNight((Level)level) == this.type.open) {
            return false;
        }
        Type type = this.type.transform();
        level.m_7731_(origin, type.state(), 3);
        level.m_220407_(GameEvent.f_157792_, origin, GameEvent.Context.m_223722_((BlockState)state));
        type.spawnTransformParticle(level, origin, random);
        BlockPos.m_121940_((BlockPos)origin.m_7918_(-3, -2, -3), (BlockPos)origin.m_7918_(3, 2, 3)).forEach(pos -> {
            BlockState closeState = level.m_8055_(pos);
            if (closeState == state) {
                double distance = Math.sqrt(origin.m_123331_((Vec3i)pos));
                int ticks = random.m_216332_((int)(distance * 5.0), (int)(distance * 10.0));
                level.m_186460_(pos, state.m_60734_(), ticks);
            }
        });
        return true;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        Bee bee;
        if (!level.m_5776_() && level.m_46791_() != Difficulty.PEACEFUL && entity instanceof Bee && !(bee = (Bee)entity).m_21023_(MobEffects.f_19614_)) {
            bee.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 25));
        }
    }

    public static enum Type {
        OPEN(true, MobEffects.f_19610_, 11, ModSoundEvents.EYEBLOSSOM_OPEN_LONG.get(), ModSoundEvents.EYEBLOSSOM_OPEN.get(), 16545810),
        CLOSED(false, MobEffects.f_19604_, 7, ModSoundEvents.EYEBLOSSOM_CLOSE_LONG.get(), ModSoundEvents.EYEBLOSSOM_CLOSE.get(), 0x5F5F5F);

        final boolean open;
        final MobEffect effect;
        final int effectDuration;
        final SoundEvent longSwitchSound;
        final SoundEvent shortSwitchSound;
        final int particleColor;

        private Type(boolean open, MobEffect effect, int effectDuration, SoundEvent longSwitchSound, SoundEvent shortSwitchSound, int particleColor) {
            this.open = open;
            this.effect = effect;
            this.effectDuration = effectDuration;
            this.longSwitchSound = longSwitchSound;
            this.shortSwitchSound = shortSwitchSound;
            this.particleColor = particleColor;
        }

        public Block block() {
            return this.open ? ModBlocks.OPEN_EYEBLOSSOM.get() : ModBlocks.CLOSED_EYEBLOSSOM.get();
        }

        public BlockState state() {
            return this.block().m_49966_();
        }

        public Type transform() {
            return Type.fromBoolean(!this.open);
        }

        public boolean emitSounds() {
            return this.open;
        }

        public static Type fromBoolean(boolean open) {
            return open ? OPEN : CLOSED;
        }

        public void spawnTransformParticle(ServerLevel level, BlockPos pos, RandomSource random) {
            Vec3 center = pos.m_252807_();
            double scale = 0.5 + random.m_188500_();
            Vec3 offset = new Vec3(random.m_188500_() - 0.5, random.m_188500_() + 1.0, random.m_188500_() - 0.5);
            Vec3 target = center.m_82549_(offset.m_82490_(scale));
            TrailParticleOption particle = new TrailParticleOption(target, this.particleColor, (int)(20.0 * scale));
            level.m_8767_((ParticleOptions)particle, center.f_82479_, center.f_82480_, center.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }

        public SoundEvent longSwitchSound() {
            return this.longSwitchSound;
        }
    }
}

